/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common.tracing;

import io.vertx.core.Context;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.common.tracing.TraceContext;
import io.vertx.kafka.client.common.tracing.TraceTags;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Utils;

public class ConsumerTracer<S> {
    private final VertxTracer<S, Void> tracer;
    private final String address;
    private final String hostname;
    private final String port;
    private final TracingPolicy policy;

    public static <S> ConsumerTracer create(VertxTracer tracer, KafkaClientOptions opts) {
        TracingPolicy policy;
        TracingPolicy tracingPolicy = policy = opts.getTracingPolicy() != null ? opts.getTracingPolicy() : TracingPolicy.ALWAYS;
        if (policy == TracingPolicy.IGNORE || tracer == null) {
            return null;
        }
        String address = opts.getTracePeerAddress();
        if (address == null) {
            address = opts.getConfig() != null ? (String)opts.getConfig().getOrDefault("bootstrap.servers", "") : "";
        }
        return new ConsumerTracer<S>(tracer, policy, address);
    }

    private ConsumerTracer(VertxTracer<S, Void> tracer, TracingPolicy policy, String bootstrapServer) {
        this.tracer = tracer;
        this.address = bootstrapServer;
        this.hostname = Utils.getHost((String)bootstrapServer);
        Integer port = Utils.getPort((String)bootstrapServer);
        this.port = port == null ? null : port.toString();
        this.policy = policy;
    }

    private static Iterable<Map.Entry<String, String>> convertHeaders(Headers headers) {
        if (headers == null) {
            return Collections.emptyList();
        }
        return () -> StreamSupport.stream(headers.spliterator(), false).map(h -> new AbstractMap.SimpleEntry<String, String>(h.key(), new String(h.value()))).iterator();
    }

    public StartedSpan prepareMessageReceived(Context context, ConsumerRecord rec) {
        TraceContext tc = new TraceContext("consumer", this.address, this.hostname, this.port, rec.topic());
        Object span = this.tracer.receiveRequest(context, SpanKind.MESSAGING, this.policy, (Object)tc, "kafka_receive", ConsumerTracer.convertHeaders(rec.headers()), TraceTags.TAG_EXTRACTOR);
        return new StartedSpan(span);
    }

    public class StartedSpan {
        private final S span;

        private StartedSpan(S span) {
            this.span = span;
        }

        public void finish(Context context) {
            ConsumerTracer.this.tracer.sendResponse(context, null, this.span, null, TagExtractor.empty());
        }

        public void fail(Context context, Throwable failure) {
            ConsumerTracer.this.tracer.sendResponse(context, null, this.span, failure, TagExtractor.empty());
        }
    }
}

