/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.plugins;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.InitialContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.security._private.SecurityLogger;
import org.jboss.as.security.plugins.AuthenticationCacheFactory;
import org.jboss.as.security.plugins.SecurityActions;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.modules.ModuleLoader;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.CacheableManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.authentication.JBossCachedAuthenticationManager;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.mapping.MappingManager;

public class JNDIBasedSecurityManagement
implements ISecurityManagement {
    private static final long serialVersionUID = 1924631329555621041L;
    private transient ConcurrentHashMap<String, SecurityDomainContext> securityMgrMap = new ConcurrentHashMap();
    private transient ConcurrentHashMap<String, AuthenticationManager> authMgrMap = new ConcurrentHashMap();
    private transient ConcurrentHashMap<String, AuthorizationManager> authzMgrMap = new ConcurrentHashMap();
    private transient ConcurrentHashMap<String, AuditManager> auditMgrMap = new ConcurrentHashMap();
    private transient ConcurrentHashMap<String, IdentityTrustManager> idmMgrMap = new ConcurrentHashMap();
    private transient ConcurrentHashMap<String, MappingManager> mappingMgrMap = new ConcurrentHashMap();
    private transient ConcurrentHashMap<String, JSSESecurityDomain> jsseMap = new ConcurrentHashMap();
    private String authenticationManagerClassName;
    private boolean deepCopySubjectMode;
    private String callbackHandlerClassName;
    private String authorizationManagerClassName;
    private String auditManagerClassName;
    private String identityTrustManagerClassName;
    private String mappingManagerClassName;
    private ModuleLoader loader;

    public JNDIBasedSecurityManagement(ModuleLoader loader) {
        this.loader = loader;
    }

    public ConcurrentHashMap<String, SecurityDomainContext> getSecurityManagerMap() {
        return this.securityMgrMap;
    }

    public AuditManager getAuditManager(String securityDomain) {
        AuditManager am = null;
        try {
            am = this.auditMgrMap.get(securityDomain);
            if (am == null) {
                am = (AuditManager)this.lookUpJNDI(securityDomain + "/auditMgr");
                this.auditMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            SecurityLogger.ROOT_LOGGER.tracef(e, "Exception getting AuditManager for domain=%s", securityDomain);
        }
        return am;
    }

    public AuthenticationManager getAuthenticationManager(String securityDomain) {
        AuthenticationManager am = null;
        try {
            am = this.authMgrMap.get(securityDomain);
            if (am == null) {
                am = (AuthenticationManager)this.lookUpJNDI(securityDomain + "/authenticationMgr");
                this.authMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            SecurityLogger.ROOT_LOGGER.tracef(e, "Exception getting AuthenticationManager for domain=%s", securityDomain);
        }
        return am;
    }

    public AuthorizationManager getAuthorizationManager(String securityDomain) {
        AuthorizationManager am = null;
        try {
            am = this.authzMgrMap.get(securityDomain);
            if (am == null) {
                am = (AuthorizationManager)this.lookUpJNDI(securityDomain + "/authorizationMgr");
                this.authzMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            SecurityLogger.ROOT_LOGGER.tracef(e, "Exception getting AuthorizationManager for domain=%s", securityDomain);
        }
        return am;
    }

    public IdentityTrustManager getIdentityTrustManager(String securityDomain) {
        IdentityTrustManager itm = null;
        try {
            itm = this.idmMgrMap.get(securityDomain);
            if (itm == null) {
                itm = (IdentityTrustManager)this.lookUpJNDI(securityDomain + "/identityTrustMgr");
                this.idmMgrMap.put(securityDomain, itm);
            }
        }
        catch (Exception e) {
            SecurityLogger.ROOT_LOGGER.tracef(e, "Exception getting IdentityTrustManager for domain=%s" + securityDomain, new Object[0]);
        }
        return itm;
    }

    public MappingManager getMappingManager(String securityDomain) {
        MappingManager mm = null;
        try {
            mm = this.mappingMgrMap.get(securityDomain);
            if (mm == null) {
                mm = (MappingManager)this.lookUpJNDI(securityDomain + "/mappingMgr");
                this.mappingMgrMap.put(securityDomain, mm);
            }
        }
        catch (Exception e) {
            SecurityLogger.ROOT_LOGGER.tracef(e, "Exception getting MappingManager for domain=%s", securityDomain);
        }
        return mm;
    }

    public JSSESecurityDomain getJSSE(String securityDomain) {
        JSSESecurityDomain jsse = null;
        try {
            jsse = this.jsseMap.get(securityDomain);
            if (jsse == null) {
                jsse = (JSSESecurityDomain)this.lookUpJNDI(securityDomain + "/jsse");
                this.jsseMap.put(securityDomain, jsse);
            }
        }
        catch (Exception e) {
            SecurityLogger.ROOT_LOGGER.tracef(e, "Exception getting JSSESecurityDomain for domain=%s", securityDomain);
        }
        return jsse;
    }

    public String getAuthenticationManagerClassName() {
        return this.authenticationManagerClassName;
    }

    public void setAuthenticationManagerClassName(String authenticationManagerClassName) {
        this.authenticationManagerClassName = authenticationManagerClassName;
    }

    public boolean isDeepCopySubjectMode() {
        return this.deepCopySubjectMode;
    }

    public void setDeepCopySubjectMode(boolean deepCopySubjectMode) {
        this.deepCopySubjectMode = deepCopySubjectMode;
    }

    public String getCallbackHandlerClassName() {
        return this.callbackHandlerClassName;
    }

    public void setCallbackHandlerClassName(String callbackHandlerClassName) {
        this.callbackHandlerClassName = callbackHandlerClassName;
    }

    public String getAuthorizationManagerClassName() {
        return this.authorizationManagerClassName;
    }

    public void setAuthorizationManagerClassName(String authorizationManagerClassName) {
        this.authorizationManagerClassName = authorizationManagerClassName;
    }

    public String getAuditManagerClassName() {
        return this.auditManagerClassName;
    }

    public void setAuditManagerClassName(String auditManagerClassName) {
        this.auditManagerClassName = auditManagerClassName;
    }

    public String getIdentityTrustManagerClassName() {
        return this.identityTrustManagerClassName;
    }

    public void setIdentityTrustManagerClassName(String identityTrustManagerClassName) {
        this.identityTrustManagerClassName = identityTrustManagerClassName;
    }

    public String getMappingManagerClassName() {
        return this.mappingManagerClassName;
    }

    public void setMappingManagerClassName(String mappingManagerClassName) {
        this.mappingManagerClassName = mappingManagerClassName;
    }

    public void removeSecurityDomain(String securityDomain) {
        this.securityMgrMap.remove(securityDomain);
        this.auditMgrMap.remove(securityDomain);
        this.authMgrMap.remove(securityDomain);
        this.authzMgrMap.remove(securityDomain);
        this.idmMgrMap.remove(securityDomain);
        this.mappingMgrMap.remove(securityDomain);
        this.jsseMap.remove(securityDomain);
    }

    private Object lookUpJNDI(String contextName) {
        Object result = null;
        try {
            InitialContext ctx = new InitialContext();
            result = contextName.startsWith("java:jboss/jaas/") ? ctx.lookup(contextName) : ctx.lookup("java:jboss/jaas/" + contextName);
        }
        catch (Exception e) {
            SecurityLogger.ROOT_LOGGER.tracef("Look up of JNDI for %s failed with %s", contextName, e.getLocalizedMessage());
            return null;
        }
        return result;
    }

    public SecurityDomainContext createSecurityDomainContext(String securityDomain, AuthenticationCacheFactory cacheFactory) throws Exception {
        return this.createSecurityDomainContext(securityDomain, cacheFactory, null);
    }

    public SecurityDomainContext createSecurityDomainContext(String securityDomain, AuthenticationCacheFactory cacheFactory, JSSESecurityDomain jsseSecurityDomain) throws Exception {
        ConcurrentMap<Principal, JBossCachedAuthenticationManager.DomainInfo> cache;
        SecurityLogger.ROOT_LOGGER.debugf("Creating SDC for domain = %s", securityDomain);
        AuthenticationManager am = this.createAuthenticationManager(securityDomain);
        if (cacheFactory != null && am instanceof CacheableManager && (cache = cacheFactory.getCache()) != null) {
            CacheableManager cm = (CacheableManager)am;
            cm.setCache(cache);
        }
        if (this.deepCopySubjectMode) {
            JNDIBasedSecurityManagement.setDeepCopySubjectMode(am);
        }
        return new SecurityDomainContext(am, this.createAuthorizationManager(securityDomain), this.createAuditManager(securityDomain), this.createIdentityTrustManager(securityDomain), this.createMappingManager(securityDomain), jsseSecurityDomain);
    }

    private AuthenticationManager createAuthenticationManager(String securityDomain) throws Exception {
        int i = this.callbackHandlerClassName.lastIndexOf(":");
        if (i == -1) {
            throw SecurityLogger.ROOT_LOGGER.missingModuleName("default-callback-handler-class-name attribute");
        }
        String moduleSpec = this.callbackHandlerClassName.substring(0, i);
        String className = this.callbackHandlerClassName.substring(i + 1);
        Class callbackHandlerClazz = SecurityActions.getModuleClassLoader(this.loader, moduleSpec).loadClass(className);
        CallbackHandler ch = (CallbackHandler)callbackHandlerClazz.newInstance();
        i = this.authenticationManagerClassName.lastIndexOf(":");
        if (i == -1) {
            throw SecurityLogger.ROOT_LOGGER.missingModuleName("authentication-manager-class-name attribute");
        }
        moduleSpec = this.authenticationManagerClassName.substring(0, i);
        className = this.authenticationManagerClassName.substring(i + 1);
        Class clazz = SecurityActions.getModuleClassLoader(this.loader, moduleSpec).loadClass(className);
        Constructor ctr = clazz.getConstructor(String.class, CallbackHandler.class);
        return (AuthenticationManager)ctr.newInstance(securityDomain, ch);
    }

    private AuthorizationManager createAuthorizationManager(String securityDomain) throws Exception {
        int i = this.authorizationManagerClassName.lastIndexOf(":");
        if (i == -1) {
            throw SecurityLogger.ROOT_LOGGER.missingModuleName("authorization manager class");
        }
        String moduleSpec = this.authorizationManagerClassName.substring(0, i);
        String className = this.authorizationManagerClassName.substring(i + 1);
        Class clazz = SecurityActions.getModuleClassLoader(this.loader, moduleSpec).loadClass(className);
        Constructor ctr = clazz.getConstructor(String.class);
        return (AuthorizationManager)ctr.newInstance(securityDomain);
    }

    private AuditManager createAuditManager(String securityDomain) throws Exception {
        int i = this.auditManagerClassName.lastIndexOf(":");
        if (i == -1) {
            throw SecurityLogger.ROOT_LOGGER.missingModuleName("audit manager class");
        }
        String moduleSpec = this.auditManagerClassName.substring(0, i);
        String className = this.auditManagerClassName.substring(i + 1);
        Class clazz = SecurityActions.getModuleClassLoader(this.loader, moduleSpec).loadClass(className);
        Constructor ctr = clazz.getConstructor(String.class);
        return (AuditManager)ctr.newInstance(securityDomain);
    }

    private IdentityTrustManager createIdentityTrustManager(String securityDomain) throws Exception {
        int i = this.identityTrustManagerClassName.lastIndexOf(":");
        if (i == -1) {
            throw SecurityLogger.ROOT_LOGGER.missingModuleName("identity trust manager class");
        }
        String moduleSpec = this.identityTrustManagerClassName.substring(0, i);
        String className = this.identityTrustManagerClassName.substring(i + 1);
        Class clazz = SecurityActions.getModuleClassLoader(this.loader, moduleSpec).loadClass(className);
        Constructor ctr = clazz.getConstructor(String.class);
        return (IdentityTrustManager)ctr.newInstance(securityDomain);
    }

    private MappingManager createMappingManager(String securityDomain) throws Exception {
        int i = this.mappingManagerClassName.lastIndexOf(":");
        if (i == -1) {
            throw SecurityLogger.ROOT_LOGGER.missingModuleName("mapping manager class");
        }
        String moduleSpec = this.mappingManagerClassName.substring(0, i);
        String className = this.mappingManagerClassName.substring(i + 1);
        Class clazz = SecurityActions.getModuleClassLoader(this.loader, moduleSpec).loadClass(className);
        Constructor ctr = clazz.getConstructor(String.class);
        return (MappingManager)ctr.newInstance(securityDomain);
    }

    private static void setDeepCopySubjectMode(AuthenticationManager authenticationManager) {
        try {
            Class[] argsType = new Class[]{Boolean.class};
            Method m = authenticationManager.getClass().getMethod("setDeepCopySubjectOption", argsType);
            Object[] deepCopyArgs = new Object[]{Boolean.TRUE};
            m.invoke((Object)authenticationManager, deepCopyArgs);
        }
        catch (Exception e) {
            SecurityLogger.ROOT_LOGGER.tracef("Optional setDeepCopySubjectMode failed: %s", e.getLocalizedMessage());
        }
    }
}

