/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ModuleInfo;

public class FilteredIndexView
implements IndexView {
    private final IndexView delegate;
    private final Pattern scanClasses;
    private final Pattern scanPackages;
    private final Pattern scanExcludeClasses;
    private final Pattern scanExcludePackages;

    public FilteredIndexView(IndexView delegate, OpenApiConfig config) {
        this.delegate = delegate;
        this.scanClasses = config.scanClasses();
        this.scanPackages = config.scanPackages();
        this.scanExcludeClasses = config.scanExcludeClasses();
        this.scanExcludePackages = config.scanExcludePackages();
    }

    public boolean accepts(DotName className) {
        return this.accepts(className, true);
    }

    public boolean explicitlyAccepts(DotName className) {
        return this.accepts(className, false);
    }

    public boolean accepts(DotName className, boolean allowImpliedInclusion) {
        MatchHandler match = new MatchHandler(className);
        boolean accept = match.isQualifiedNameExcluded() ? false : (match.isQualifiedNameIncluded() ? true : (match.isSimpleNameExcluded() ? false : (match.isSimpleNameIncluded() ? true : (match.isPackageExcluded() ? false : (match.isPackageIncluded() ? true : allowImpliedInclusion && match.isImpliedInclusion())))));
        return accept;
    }

    String matchingGroup(String value, Pattern pattern) {
        if (pattern == null || pattern.pattern().isEmpty() || value.isEmpty()) {
            return "";
        }
        Matcher m = pattern.matcher(value);
        return m.find() ? m.group() : "";
    }

    public Collection<ClassInfo> getKnownClasses() {
        return this.filterClasses(this.delegate.getKnownClasses());
    }

    public ClassInfo getClassByName(DotName className) {
        if (this.accepts(className)) {
            return this.delegate.getClassByName(className);
        }
        return null;
    }

    public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
        return this.filterClasses(this.delegate.getKnownDirectSubclasses(className));
    }

    public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
        return this.filterClasses(this.delegate.getAllKnownSubclasses(className));
    }

    public Collection<ClassInfo> getKnownDirectImplementors(DotName className) {
        return this.filterClasses(this.delegate.getKnownDirectImplementors(className));
    }

    public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        return this.filterClasses(this.delegate.getAllKnownImplementors(interfaceName));
    }

    public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
        return this.filterInstances(this.delegate.getAnnotations(annotationName));
    }

    public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName annotationName, IndexView annotationIndex) {
        return this.filterInstances(this.delegate.getAnnotationsWithRepeatable(annotationName, annotationIndex));
    }

    public Collection<ModuleInfo> getKnownModules() {
        return this.delegate.getKnownModules();
    }

    public ModuleInfo getModuleByName(DotName moduleName) {
        return this.delegate.getModuleByName(moduleName);
    }

    public Collection<ClassInfo> getKnownUsers(DotName className) {
        return this.filterClasses(this.delegate.getKnownUsers(className));
    }

    private Collection<AnnotationInstance> filterInstances(Collection<AnnotationInstance> annotations) {
        if (annotations != null && !annotations.isEmpty()) {
            return annotations.stream().filter(ai -> {
                AnnotationTarget target = ai.target();
                switch (target.kind()) {
                    case CLASS: {
                        return this.accepts(target.asClass().name());
                    }
                    case FIELD: {
                        return this.accepts(target.asField().declaringClass().name());
                    }
                    case METHOD: {
                        return this.accepts(target.asMethod().declaringClass().name());
                    }
                    case METHOD_PARAMETER: {
                        return this.accepts(target.asMethodParameter().method().declaringClass().name());
                    }
                    case TYPE: {
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList());
        }
        return annotations;
    }

    private Collection<ClassInfo> filterClasses(Collection<ClassInfo> classes) {
        return classes.stream().filter(classInfo -> this.accepts(classInfo.name())).collect(Collectors.toList());
    }

    class MatchHandler {
        final DotName className;
        final String fqcn;
        final String simpleName;
        final String packageName;
        final String classExclGroup;
        final String classInclGroup;
        final String pkgExclGroup;
        final String pkgInclGroup;

        public MatchHandler(DotName className) {
            this.className = className;
            this.fqcn = className.toString();
            this.simpleName = className.withoutPackagePrefix();
            int index = this.fqcn.lastIndexOf(46);
            this.packageName = index > -1 ? this.fqcn.substring(0, index) : "";
            this.classExclGroup = FilteredIndexView.this.matchingGroup(this.fqcn, FilteredIndexView.this.scanExcludeClasses);
            this.classInclGroup = FilteredIndexView.this.matchingGroup(this.fqcn, FilteredIndexView.this.scanClasses);
            this.pkgExclGroup = FilteredIndexView.this.matchingGroup(this.packageName, FilteredIndexView.this.scanExcludePackages);
            this.pkgInclGroup = FilteredIndexView.this.matchingGroup(this.packageName, FilteredIndexView.this.scanPackages);
        }

        public boolean isQualifiedNameExcluded() {
            return this.fqcn.equals(this.classExclGroup);
        }

        public boolean isQualifiedNameIncluded() {
            return this.fqcn.equals(this.classInclGroup);
        }

        public boolean isSimpleNameExcluded() {
            if (this.classExclGroup.endsWith(this.simpleName)) {
                if (this.isSimpleNameIncluded()) {
                    return this.classExclGroup.length() >= this.classInclGroup.length();
                }
                return true;
            }
            return false;
        }

        public boolean isSimpleNameIncluded() {
            return this.classInclGroup.endsWith(this.simpleName);
        }

        public boolean isPackageExcluded() {
            if (this.pkgExclGroup.isEmpty()) {
                return false;
            }
            if (this.packageName.equals(this.pkgExclGroup)) {
                return true;
            }
            if (this.packageName.startsWith(this.pkgExclGroup)) {
                if (this.isPackageIncluded()) {
                    return this.pkgExclGroup.length() >= this.pkgInclGroup.length();
                }
                return true;
            }
            return false;
        }

        public boolean isPackageIncluded() {
            if (this.pkgInclGroup.isEmpty()) {
                return false;
            }
            if (this.packageName.equals(this.pkgInclGroup)) {
                return true;
            }
            return this.packageName.startsWith(this.pkgInclGroup);
        }

        public boolean isImpliedInclusion() {
            return !(FilteredIndexView.this.scanClasses != null && !FilteredIndexView.this.scanClasses.pattern().isEmpty() || FilteredIndexView.this.scanPackages != null && !FilteredIndexView.this.scanPackages.pattern().isEmpty());
        }
    }
}

