/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.rest;

import edu.psu.swe.scim.server.exception.UnableToResolveIdException;
import edu.psu.swe.scim.server.provider.ProviderRegistry;
import edu.psu.swe.scim.server.provider.SelfIdResolver;
import edu.psu.swe.scim.spec.protocol.SelfResource;
import edu.psu.swe.scim.spec.protocol.UserResource;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReferenceListWrapper;
import edu.psu.swe.scim.spec.protocol.data.ErrorResponse;
import edu.psu.swe.scim.spec.protocol.data.PatchRequest;
import edu.psu.swe.scim.spec.protocol.exception.ScimException;
import edu.psu.swe.scim.spec.resources.ScimUser;
import java.security.Principal;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class SelfResourceImpl
implements SelfResource {
    private static final Logger log = LoggerFactory.getLogger(SelfResourceImpl.class);
    @Inject
    ProviderRegistry providerRegistry;
    @Inject
    UserResource userResource;
    @Inject
    SelfIdResolver selfIdResolver;
    @Resource
    private SessionContext sessionContext;

    public Response getSelf(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) {
        try {
            String internalId = this.getInternalId();
            return this.userResource.getById(internalId, attributes, excludedAttributes);
        }
        catch (UnableToResolveIdException e) {
            return this.createErrorResponse(e);
        }
        catch (ScimException e) {
            return this.createErrorResponse(e);
        }
    }

    public Response update(ScimUser resource, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) {
        try {
            String internalId = this.getInternalId();
            return this.userResource.update((Object)resource, internalId, attributes, excludedAttributes);
        }
        catch (UnableToResolveIdException e) {
            return this.createErrorResponse(e);
        }
        catch (ScimException e) {
            return this.createErrorResponse(e);
        }
    }

    public Response patch(PatchRequest patchRequest, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) {
        try {
            String internalId = this.getInternalId();
            return this.userResource.patch(patchRequest, internalId, attributes, excludedAttributes);
        }
        catch (UnableToResolveIdException e) {
            return this.createErrorResponse(e);
        }
        catch (ScimException e) {
            return this.createErrorResponse(e);
        }
    }

    public Response delete() {
        try {
            String internalId = this.getInternalId();
            return this.userResource.delete(internalId);
        }
        catch (UnableToResolveIdException e) {
            return this.createErrorResponse(e);
        }
        catch (ScimException e) {
            return this.createErrorResponse(e);
        }
    }

    private Response createErrorResponse(ScimException e) {
        ErrorResponse er = new ErrorResponse(e.getStatus(), "Error");
        er.addErrorMessage(e.getMessage());
        return er.toResponse();
    }

    private Response createErrorResponse(UnableToResolveIdException e) {
        ErrorResponse er = new ErrorResponse(e.getStatus(), "Error");
        er.addErrorMessage(e.getMessage());
        return er.toResponse();
    }

    private String getInternalId() throws UnableToResolveIdException {
        Principal callerPrincipal = this.sessionContext.getCallerPrincipal();
        if (callerPrincipal == null) {
            throw new UnableToResolveIdException(Response.Status.UNAUTHORIZED, "Unauthorized");
        }
        log.info("Resolved SelfResource principal to : {}", (Object)callerPrincipal.getName());
        String internalId = this.selfIdResolver.resolveToInternalId(callerPrincipal);
        return internalId;
    }
}

