/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.rest;

import edu.psu.swe.scim.server.schema.Registry;
import edu.psu.swe.scim.spec.protocol.SchemaResource;
import edu.psu.swe.scim.spec.protocol.data.ListResponse;
import edu.psu.swe.scim.spec.schema.Meta;
import edu.psu.swe.scim.spec.schema.Schema;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Stateless
public class SchemaResourceImpl
implements SchemaResource {
    @Inject
    Registry registry;
    @Context
    private UriInfo uriInfo;

    public Response getAllSchemas(String filter) {
        if (filter != null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ListResponse listResponse = new ListResponse();
        Collection<Schema> schemas = this.registry.getAllSchemas();
        for (Schema schema : schemas) {
            Meta meta = new Meta();
            meta.setLocation(this.uriInfo.getAbsolutePathBuilder().path(schema.getId()).build(new Object[0]).toString());
            meta.setResourceType("Schema");
            schema.setMeta(meta);
        }
        listResponse.setItemsPerPage(Integer.valueOf(schemas.size()));
        listResponse.setStartIndex(Integer.valueOf(1));
        listResponse.setTotalResults(schemas.size());
        ArrayList<Schema> objectList = new ArrayList<Schema>(schemas);
        listResponse.setResources(objectList);
        return Response.ok((Object)listResponse).build();
    }

    public Response getSchema(String urn) {
        Schema schema = this.registry.getSchema(urn);
        if (schema == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Meta meta = new Meta();
        meta.setLocation(this.uriInfo.getAbsolutePath().toString());
        meta.setResourceType("Schema");
        schema.setMeta(meta);
        return Response.ok((Object)schema).build();
    }
}

