/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.task;

import org.silverpeas.core.workflow.api.TaskManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.Actor;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.instance.Question;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.model.StateImpl;
import org.silverpeas.core.workflow.engine.task.CreationTaskImpl;
import org.silverpeas.core.workflow.engine.task.TaskImpl;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractTaskManager
implements TaskManager {
    @Override
    public Task createTask(Actor actor, ProcessInstance processInstance) throws WorkflowException {
        return new TaskImpl(actor.getUser(), actor.getUserRoleName(), actor.getGroupId(), processInstance, actor.getState());
    }

    @Override
    public Task[] createTasks(Actor[] actors, ProcessInstance processInstance) throws WorkflowException {
        Task[] tasks = new TaskImpl[actors.length];
        for (int i = 0; i < actors.length; ++i) {
            tasks[i] = this.createTask(actors[i], processInstance);
        }
        return tasks;
    }

    @Override
    public Task[] getTasks(User user, String roleName, ProcessInstance processInstance) throws WorkflowException {
        ProcessModel model = processInstance.getProcessModel();
        String[] stateNames = processInstance.getAssignedStates(user, roleName);
        Task[] tasks = new Task[stateNames.length];
        for (int i = 0; i < stateNames.length; ++i) {
            HistoryStep[] steps = processInstance.getBackSteps(user, roleName, stateNames[i]);
            Question[] pendingQuestions = processInstance.getPendingQuestions(stateNames[i]);
            Question[] sentQuestions = processInstance.getSentQuestions(stateNames[i]);
            Question[] relevantQuestions = processInstance.getRelevantQuestions(stateNames[i]);
            State state = StringUtil.isDefined((String)stateNames[i]) ? model.getState(stateNames[i]) : new StateImpl("");
            if (state == null) {
                throw new WorkflowException("TaskManager.getTasks", "workflowEngine.EXP_UNKNOWN_STATE");
            }
            tasks[i] = new TaskImpl(user, roleName, processInstance, state, steps, sentQuestions, relevantQuestions, pendingQuestions);
        }
        return tasks;
    }

    @Override
    public Task getCreationTask(User user, String roleName, ProcessModel processModel) throws WorkflowException {
        return new CreationTaskImpl(user, roleName, processModel);
    }
}

