/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.AllowedActions;
import org.silverpeas.core.workflow.api.model.ContextualDesignation;
import org.silverpeas.core.workflow.api.model.ContextualDesignations;
import org.silverpeas.core.workflow.api.model.QualifiedUsers;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.model.TimeOutAction;
import org.silverpeas.core.workflow.api.model.TimeOutActions;
import org.silverpeas.core.workflow.engine.model.ActionImpl;
import org.silverpeas.core.workflow.engine.model.ActionRefs;
import org.silverpeas.core.workflow.engine.model.QualifiedUsersImpl;
import org.silverpeas.core.workflow.engine.model.SpecificLabel;
import org.silverpeas.core.workflow.engine.model.SpecificLabelListHelper;
import org.silverpeas.core.workflow.engine.model.TimeOutActionsImpl;

@XmlRootElement(name="state")
@XmlAccessorType(value=XmlAccessType.NONE)
public class StateImpl
implements State {
    private static final long serialVersionUID = -3019436287850255663L;
    @XmlAttribute
    @XmlID
    private String name;
    @XmlElement(name="label", type=SpecificLabel.class)
    private List<ContextualDesignation> labels;
    @XmlElement(name="description", type=SpecificLabel.class)
    private List<ContextualDesignation> descriptions;
    @XmlElement(name="activity", type=SpecificLabel.class)
    private List<ContextualDesignation> activities;
    @XmlElement(type=QualifiedUsersImpl.class)
    private QualifiedUsers workingUsers;
    @XmlElement(type=QualifiedUsersImpl.class)
    private QualifiedUsers interestedUsers;
    @XmlElement(type=ActionRefs.class)
    private AllowedActions allowedActions;
    private AllowedActions filteredActions;
    @XmlElement(type=TimeOutActionsImpl.class)
    private TimeOutActions timeOutActions;
    @XmlIDREF
    @XmlAttribute
    private ActionImpl timeOutAction;
    @XmlAttribute
    private int timeoutInterval;
    @XmlAttribute
    private boolean timeoutNotifyAdmin;

    public StateImpl() {
        this.reset();
    }

    public StateImpl(String name) {
        this();
        this.name = name;
    }

    private void reset() {
        this.labels = new ArrayList<ContextualDesignation>();
        this.descriptions = new ArrayList<ContextualDesignation>();
        this.activities = new ArrayList<ContextualDesignation>();
        this.timeOutAction = null;
        this.timeoutInterval = -1;
        this.timeoutNotifyAdmin = true;
    }

    @Override
    public ContextualDesignations getLabels() {
        return new SpecificLabelListHelper(this.labels);
    }

    @Override
    public String getLabel(String role, String language) {
        return this.getLabels().getLabel(role, language);
    }

    @Override
    public ContextualDesignations getActivities() {
        return new SpecificLabelListHelper(this.activities);
    }

    @Override
    public ContextualDesignations getDescriptions() {
        return new SpecificLabelListHelper(this.descriptions);
    }

    @Override
    public String getDescription(String role, String language) {
        return this.getDescriptions().getLabel(role, language);
    }

    @Override
    public Action[] getAllowedActions() {
        if (this.allowedActions == null) {
            return new Action[0];
        }
        return this.allowedActions.getAllowedActions();
    }

    @Override
    public TimeOutAction[] getTimeOutActions() {
        if (this.timeOutActions == null) {
            return new TimeOutAction[0];
        }
        return this.timeOutActions.getTimeOutActions();
    }

    @Override
    public AllowedActions getAllowedActionsEx() {
        return this.allowedActions;
    }

    @Override
    public AllowedActions createAllowedActions() {
        return new ActionRefs();
    }

    @Override
    public Action[] getFilteredActions() {
        if (this.filteredActions == null) {
            return new Action[0];
        }
        return this.filteredActions.getAllowedActions();
    }

    @Override
    public void setFilteredActions(AllowedActions allowedActions) {
        this.filteredActions = allowedActions;
    }

    @Override
    public QualifiedUsers getInterestedUsers() {
        return Objects.requireNonNullElseGet(this.interestedUsers, QualifiedUsersImpl::new);
    }

    @Override
    public QualifiedUsers getInterestedUsersEx() {
        return this.interestedUsers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public QualifiedUsers getWorkingUsers() {
        return Objects.requireNonNullElseGet(this.workingUsers, QualifiedUsersImpl::new);
    }

    @Override
    public QualifiedUsers getWorkingUsersEx() {
        return this.workingUsers;
    }

    @Override
    public void setAllowedActions(AllowedActions allowedActions) {
        this.allowedActions = allowedActions;
    }

    @Override
    public void setInterestedUsers(QualifiedUsers interestedUsers) {
        this.interestedUsers = interestedUsers;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setWorkingUsers(QualifiedUsers workingUsers) {
        this.workingUsers = workingUsers;
    }

    @Override
    public int getTimeoutInterval() {
        return this.timeoutInterval;
    }

    @Override
    public void setTimeoutInterval(int hours) {
        this.timeoutInterval = hours;
    }

    @Override
    public Action getTimeoutAction() {
        return this.timeOutAction;
    }

    @Override
    public void setTimeoutAction(Action timeoutAction) {
        this.timeOutAction = (ActionImpl)timeoutAction;
    }

    @Override
    public boolean getTimeoutNotifyAdmin() {
        return this.timeoutNotifyAdmin;
    }

    @Override
    public void setTimeoutNotifyAdmin(boolean timeoutAction) {
        this.timeoutNotifyAdmin = timeoutAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateImpl state = (StateImpl)o;
        return this.name.equals(state.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

