/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.model.Column;
import org.silverpeas.core.workflow.api.model.Columns;
import org.silverpeas.core.workflow.api.model.ContextualDesignation;
import org.silverpeas.core.workflow.api.model.ContextualDesignations;
import org.silverpeas.core.workflow.api.model.Presentation;
import org.silverpeas.core.workflow.engine.model.ColumnsImpl;
import org.silverpeas.core.workflow.engine.model.SpecificLabel;
import org.silverpeas.core.workflow.engine.model.SpecificLabelListHelper;

@XmlRootElement(name="presentation")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PresentationImpl
implements Presentation {
    private static final long serialVersionUID = 8175832964614235239L;
    @XmlElement(name="title", type=SpecificLabel.class)
    private List<ContextualDesignation> titles = new ArrayList<ContextualDesignation>();
    @XmlElement(name="columns", type=ColumnsImpl.class)
    private List<Columns> columnsList = new Vector<Columns>();

    @Override
    public ContextualDesignations getTitles() {
        return new SpecificLabelListHelper(this.titles);
    }

    @Override
    public String getTitle(String role, String language) {
        return this.getTitles().getLabel(role, language);
    }

    @Override
    public Column[] getColumns(String strRoleName) {
        Columns columns = this.getColumnsByRole(strRoleName);
        if (columns == null) {
            return new Column[0];
        }
        return columns.getColumnList().toArray(new Column[0]);
    }

    @Override
    public Columns getColumnsByRole(String strRoleName) {
        if (this.columnsList == null) {
            return null;
        }
        Columns search = this.createColumns();
        search.setRoleName(strRoleName);
        int index = this.columnsList.indexOf(search);
        if (index == -1) {
            search.setRoleName("default");
            int indexDefault = this.columnsList.indexOf(search);
            if (indexDefault == -1) {
                return null;
            }
            return this.columnsList.get(indexDefault);
        }
        return this.columnsList.get(index);
    }

    @Override
    public Columns createColumns() {
        return new ColumnsImpl();
    }

    @Override
    public void addColumns(Columns columns) {
        this.columnsList.add(columns);
    }

    @Override
    public Iterator<Columns> iterateColumns() {
        return this.columnsList.iterator();
    }

    @Override
    public void deleteColumns(String strRoleName) {
        if (this.columnsList == null) {
            return;
        }
        this.columnsList.removeIf(c -> c.getRoleName().equals(strRoleName));
    }
}

