/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericRecordTemplate;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.model.DataFolder;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.core.workflow.api.model.Parameter;
import org.silverpeas.core.workflow.engine.model.ItemImpl;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DataFolderImpl
implements DataFolder,
Serializable {
    private static final long serialVersionUID = -2779065735195457809L;
    @XmlElement(name="item", type=ItemImpl.class)
    private List<Item> itemList = new ArrayList<Item>();

    @Override
    public Item[] getItems() {
        return this.itemList.toArray(new Item[0]);
    }

    @Override
    public Item getItem(String strRoleName) {
        if (strRoleName == null) {
            return null;
        }
        Item search = this.createItem();
        search.setName(strRoleName);
        int idx = this.itemList.indexOf(search);
        if (idx >= 0) {
            return this.itemList.get(idx);
        }
        return null;
    }

    @Override
    public void addItem(Item item) {
        this.itemList.add(item);
    }

    @Override
    public Item createItem() {
        return new ItemImpl();
    }

    @Override
    public Iterator<Item> iterateItem() {
        return this.itemList.iterator();
    }

    @Override
    public void removeItem(String strItemName) throws WorkflowException {
        if (this.itemList == null) {
            return;
        }
        Item item = this.createItem();
        item.setName(strItemName);
        if (!this.itemList.remove(item)) {
            throw new WorkflowException("DataFolderImpl.removeItem()", "workflowEngine.EX_ITEM_NOT_FOUND", strItemName == null ? "<null>" : strItemName);
        }
    }

    @Override
    public RecordTemplate toRecordTemplate(String role, String lang, boolean readonly) throws WorkflowException {
        GenericRecordTemplate rt = new GenericRecordTemplate();
        if (this.itemList == null) {
            return rt;
        }
        try {
            this.addFieldDescription(rt, role, lang, readonly);
        }
        catch (FormException fe) {
            throw new WorkflowException("DataFolderImpl.toRecordTemplate", "workflowEngine.EX_ERR_BUILD_FIELD_TEMPLATE", (Exception)((Object)fe));
        }
        return rt;
    }

    private void addFieldDescription(GenericRecordTemplate rt, String role, String lang, boolean readonly) throws FormException {
        for (Item item : this.itemList) {
            if (item.getMapTo() != null && !item.getMapTo().isEmpty()) continue;
            GenericFieldTemplate ft = new GenericFieldTemplate(item.getName(), item.getType());
            Iterator<Parameter> parameters = item.iterateParameter();
            while (parameters.hasNext()) {
                Parameter parameter = parameters.next();
                if (parameter == null) continue;
                ft.addParameter(parameter.getName(), parameter.getValue());
            }
            if (role != null && lang != null) {
                ft.setReadOnly(readonly);
                ft.setMandatory(!readonly);
                ft.addLabel(item.getLabel(role, lang), lang);
            }
            rt.addFieldTemplate((FieldTemplate)ft);
        }
    }
}

