/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.Actor;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.core.workflow.engine.instance.ActorImpl;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceImpl;
import org.silverpeas.core.workflow.engine.instance.RolePlayer;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="sb_workflow_workinguser")
public class WorkingUser
extends BasicJpaEntity<WorkingUser, UniqueIntegerIdentifier>
implements RolePlayer {
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="instanceid", nullable=false)
    private ProcessInstanceImpl processInstance = null;
    @Column
    private String userId = null;
    @Column
    private String usersRole = null;
    @Column
    private String state = null;
    @Column
    private String role = null;
    @Column
    private String groupId = null;

    @Override
    public String getState() {
        return this.state == null ? "" : this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    public List<String> getRoles() {
        return Arrays.asList(this.role.split(":"));
    }

    @Override
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUsersRole() {
        return this.usersRole;
    }

    @Override
    public void setUsersRole(String usersRole) {
        this.usersRole = usersRole;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public ProcessInstanceImpl getProcessInstance() {
        return this.processInstance;
    }

    @Override
    public void setProcessInstance(ProcessInstanceImpl processInstance) {
        this.processInstance = processInstance;
    }

    public Collection<Actor> toActors() throws WorkflowException {
        ArrayList<Actor> actors;
        block4: {
            User[] users;
            State actualState;
            block3: {
                actualState = this.processInstance.getProcessModel().getState(this.state);
                actors = new ArrayList<Actor>();
                if (this.getUserId() != null) {
                    User user = WorkflowHub.getUserManager().getUser(this.getUserId());
                    actors.add(new ActorImpl(user, this.role, actualState));
                }
                if (!StringUtil.isDefined((String)this.getGroupId())) break block3;
                for (User anUser : users = WorkflowHub.getUserManager().getUsersInGroup(this.getGroupId(), this.processInstance.getModelId())) {
                    actors.add(new ActorImpl(anUser, this.role, actualState));
                }
                break block4;
            }
            if (this.usersRole == null) break block4;
            for (User anUser : users = WorkflowHub.getUserManager().getUsersInRole(this.usersRole, this.processInstance.getModelId())) {
                actors.add(new ActorImpl(anUser, this.role, actualState));
            }
        }
        return actors;
    }

    public static User[] toUser(WorkingUser[] workingUsers) throws WorkflowException {
        String[] userIds = new String[workingUsers.length];
        for (int i = 0; i < workingUsers.length; ++i) {
            userIds[i] = workingUsers[i].getUserId();
        }
        return WorkflowHub.getUserManager().getUsers(userIds);
    }

    private String getKey() {
        return this.getUserId() + "--" + this.getState() + "--" + this.getRole() + "--" + this.getUsersRole();
    }

    public boolean equals(Object theOther) {
        if (theOther instanceof String) {
            return this.getKey().equals(theOther);
        }
        if (theOther instanceof WorkingUser) {
            return this.getKey().equals(((WorkingUser)theOther).getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

