/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.instance;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.workflow.api.UpdatableProcessInstanceManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.Actor;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.core.workflow.engine.instance.ActiveState;
import org.silverpeas.core.workflow.engine.instance.ActorImpl;
import org.silverpeas.core.workflow.engine.instance.HistoryStepImpl;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceImpl;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceRepository;

@Service
@Singleton
public class ProcessInstanceManagerImpl
implements UpdatableProcessInstanceManager {
    private static final String MODEL_ID_CRITERION = "I.modelId = ?";
    private static final String SB_WORKFLOW_PROCESS_INSTANCE_TABLE = "SB_Workflow_ProcessInstance I";
    @Inject
    private SilverpeasCalendar calendar;
    @Inject
    private ProcessInstanceRepository repository;

    @Override
    public List<ProcessInstance> getProcessInstances(String peasId, User user, String role) throws WorkflowException {
        return this.getProcessInstances(peasId, user, role, null, null);
    }

    @Override
    public List<ProcessInstance> getProcessInstances(String peasId, User user, String role, String[] userRoles, String[] userGroupIds) throws WorkflowException {
        ListSlice listSlice;
        block15: {
            JdbcSqlQuery select;
            if ("supervisor".equals(role)) {
                select = JdbcSqlQuery.select((String)"I.instanceId, I.modelId, I.locked, I.errorStatus, I.timeoutStatus").from(new String[]{SB_WORKFLOW_PROCESS_INSTANCE_TABLE}).where(MODEL_ID_CRITERION, new Object[]{peasId}).orderBy(new String[]{"I.instanceId DESC"});
            } else {
                select = JdbcSqlQuery.select((String)"*").from(new String[]{"("}).addSqlPart("SELECT I.instanceId, I.modelId, I.locked, I.errorStatus, I.timeoutStatus", new Object[0]).from(new String[]{"SB_Workflow_InterestedUser intUser"}).join(SB_WORKFLOW_PROCESS_INSTANCE_TABLE).on("I.instanceId = intUser.instanceId", new Object[0]).where(MODEL_ID_CRITERION, new Object[]{peasId}).and("(intUser.userId = ?", new Object[]{user.getUserId()});
                if (ArrayUtil.isNotEmpty((Object[])userRoles)) {
                    select.or("intUser.usersRole", new Object[0]).in((Object[])userRoles);
                }
                if (ArrayUtil.isNotEmpty((Object[])userGroupIds)) {
                    select.or("(intUser.groupId is not null", new Object[0]).and("intUser.groupId", new Object[0]).in((Object[])userGroupIds).addSqlPart(")", new Object[0]);
                }
                select.addSqlPart(")", new Object[0]).and("intUser.role = ?", new Object[]{role}).union().addSqlPart("SELECT I.instanceId, I.modelId, I.locked, I.errorStatus, I.timeoutStatus", new Object[0]).from(new String[]{"SB_Workflow_WorkingUser wkUser"}).join(SB_WORKFLOW_PROCESS_INSTANCE_TABLE).on("I.instanceId = wkUser.instanceId", new Object[0]).where(MODEL_ID_CRITERION, new Object[]{peasId}).and("(wkUser.userId = ?", new Object[]{user.getUserId()});
                if (ArrayUtil.isNotEmpty((Object[])userRoles)) {
                    select.or("wkUser.usersRole", new Object[0]).in((Object[])userRoles);
                }
                if (ArrayUtil.isNotEmpty((Object[])userGroupIds)) {
                    select.or("(wkUser.groupId is not null", new Object[0]).and("wkUser.groupId", new Object[0]).in((Object[])userGroupIds).addSqlPart(")", new Object[0]);
                }
                select.addSqlPart(")", new Object[0]).and("(wkUser.role = ?", new Object[]{role}).or("wkUser.role like ?", new Object[]{"%," + role}).or("wkUser.role like ?", new Object[]{role + ",%"}).or("wkUser.role like ?)", new Object[]{"%," + role + ",%"}).addSqlPart(") u", new Object[0]).orderBy(new String[]{"u.instanceId DESC"});
            }
            Connection connection = DBUtil.openConnection();
            try {
                LinkedList instanceIds = new LinkedList();
                ListSlice instances = select.executeWith(connection, r -> {
                    ProcessInstanceImpl instance = new ProcessInstanceImpl();
                    int i = 1;
                    int instanceId = r.getInt(i++);
                    instance.setInstanceId(String.valueOf(instanceId));
                    instance.setModelId(r.getString(i++));
                    instance.setLockedByAdmin(r.getBoolean(i++));
                    instance.setErrorStatus(r.getBoolean(i++));
                    instance.setTimeoutStatus(r.getBoolean(i));
                    instanceIds.add(instanceId);
                    return instance;
                });
                if (!instanceIds.isEmpty()) {
                    CollectionUtil.RuptureContext ruptureContext = CollectionUtil.RuptureContext.newOne((List)instances);
                    JdbcSqlQuery.executeBySplittingOn(instanceIds, (idBatch, result) -> JdbcSqlQuery.select((String)"instanceId, id, userId, userRoleName, action, actionDate, resolvedState, toState, actionStatus").from(new String[]{"SB_Workflow_HistoryStep"}).where("instanceId", new Object[0]).in(idBatch).orderBy(new String[]{"instanceId DESC, id ASC"}).executeWith(connection, r -> {
                        int i = 1;
                        String instanceId = r.getString(i++);
                        HistoryStepImpl historyStep = new HistoryStepImpl(r.getInt(i++));
                        historyStep.setUserId(r.getString(i++));
                        historyStep.setUserRoleName(r.getString(i++));
                        historyStep.setAction(r.getString(i++));
                        historyStep.setActionDate(new Date(r.getTimestamp(i++).getTime()));
                        historyStep.setResolvedState(r.getString(i++));
                        historyStep.setResultingState(r.getString(i++));
                        historyStep.setActionStatus(ActionStatus.from(r.getInt(i)));
                        CollectionUtil.findNextRupture((CollectionUtil.RuptureContext)ruptureContext, p -> p.getInstanceId().equals(instanceId)).ifPresent(p -> p.addHistoryStep(historyStep));
                        return null;
                    }));
                    ruptureContext.reset();
                    JdbcSqlQuery.executeBySplittingOn(instanceIds, (idBatch, result) -> JdbcSqlQuery.select((String)"id, instanceId, state, backStatus, timeoutStatus").from(new String[]{"SB_Workflow_ActiveState"}).where("instanceId", new Object[0]).in(idBatch).orderBy(new String[]{"instanceId DESC, id ASC"}).executeWith(connection, rs -> {
                        int i = 1;
                        ActiveState state = new ActiveState(rs.getInt(i++));
                        String instanceId = rs.getString(i++);
                        state.setState(rs.getString(i++));
                        state.setBackStatus(rs.getBoolean(i++));
                        state.setTimeoutStatus(rs.getInt(i));
                        CollectionUtil.findNextRupture((CollectionUtil.RuptureContext)ruptureContext, p -> p.getInstanceId().equals(instanceId)).ifPresent(p -> p.addActiveState(state));
                        return null;
                    }));
                }
                listSlice = instances;
                if (connection == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new WorkflowException("ProcessInstanceManagerImpl.getProcessInstances", "EX_ERR_GET_INSTANCES", "sql query : " + select.getSqlQuery(), (Exception)se);
                }
            }
            connection.close();
        }
        return listSlice;
    }

    @Override
    public ProcessInstance getProcessInstance(String instanceId) throws WorkflowException {
        try {
            return this.repository.getById(instanceId);
        }
        catch (Exception e) {
            throw new WorkflowException("ProcessInstanceManagerImpl.getProcessInstance", "EX_ERR_GET_INSTANCE", "Process instance #" + instanceId + " not found !");
        }
    }

    @Override
    @Transactional
    public synchronized ProcessInstance createProcessInstance(String modelId) throws WorkflowException {
        ProcessInstanceImpl instance = new ProcessInstanceImpl();
        instance.setModelId(modelId);
        this.repository.save((IdentifiableEntity)instance);
        return instance;
    }

    @Override
    @Transactional
    public void removeProcessInstance(String instanceId) throws WorkflowException {
        ProcessInstanceImpl instance = this.repository.getById(instanceId);
        this.removeProcessInstanceData(instance);
        WorkflowHub.getErrorManager().removeErrorsOfInstance(instanceId);
        this.repository.delete((IdentifiableEntity[])new ProcessInstanceImpl[]{instance});
    }

    public void removeProcessInstanceData(ProcessInstance instance) throws WorkflowException {
        String id = instance.getInstanceId();
        String componentId = instance.getModelId();
        AttachmentServiceProvider.getAttachmentService().deleteAllAttachments(id, componentId);
        try {
            RecordSet folderRecordSet = instance.getProcessModel().getFolderRecordSet();
            folderRecordSet.delete(id);
        }
        catch (FormException e) {
            throw new WorkflowException("ProcessInstanceManagerImpl.removeProcessInstanceData", "EX_ERR_CANT_REMOVE_FOLDER", (Exception)((Object)e));
        }
        HistoryStep[] steps = instance.getHistorySteps();
        if (steps != null) {
            for (HistoryStep step : steps) {
                if ("#question#".equals(step.getAction()) || "#response#".equals(step.getAction())) continue;
                step.deleteActionRecord();
            }
        }
        this.calendar.removeToDoFromExternal("useless", componentId, id + "##%");
    }

    @Override
    @Transactional
    public void lock(ProcessInstance instance, State state, User user) throws WorkflowException {
        ProcessInstanceImpl copyInstance = this.repository.getById(instance.getInstanceId());
        copyInstance.lock(state, user);
        this.repository.save((IdentifiableEntity)copyInstance);
    }

    @Override
    @Transactional
    public void unlock(ProcessInstance instance, State state, User user) throws WorkflowException {
        ProcessInstanceImpl copyInstance = this.repository.getById(instance.getInstanceId());
        copyInstance.unLock(state, user);
        this.repository.save((IdentifiableEntity)copyInstance);
    }

    @Override
    public HistoryStep createHistoryStep() {
        return new HistoryStepImpl();
    }

    @Override
    public Actor createActor(User user, String roleName, State state) {
        return new ActorImpl(user, roleName, state);
    }

    @Override
    public SilverpeasList<ProcessInstance> getTimeOutProcessInstances() throws WorkflowException {
        try {
            JdbcSqlQuery query = JdbcSqlQuery.select((String)"instanceid").from(new String[]{"SB_Workflow_ActiveState"}).where("timeoutDate < ? ", new Object[]{new Timestamp(new Date().getTime())});
            ListSlice ids = query.execute(row -> String.valueOf(row.getInt(1)));
            HashSet<String> instanceIds = new HashSet<String>((Collection<String>)ids);
            return this.repository.getById(instanceIds);
        }
        catch (SQLException se) {
            throw new WorkflowException("ProcessInstanceManagerImpl.getTimeOutProcessInstances", "EX_ERR_GET_TIMEOUT_INSTANCES", se);
        }
    }
}

