/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.cdx.CdxFields;
import org.netpreserve.jwarc.cdx.CdxRecord;

public class CdxFormat {
    public static final CdxFormat CDX9 = new CdxFormat("N b a m s k r V g");
    public static final CdxFormat CDX10 = new CdxFormat("N b a m s k r M V g");
    public static final CdxFormat CDX11 = new CdxFormat("N b a m s k r M S V g");
    private final byte[] fieldNames;
    private final byte[] fieldIndices;

    public CdxFormat(String legend) {
        String[] fields = legend.replaceFirst("^ ?CDX ", "").split(" ");
        this.fieldNames = new byte[fields.length];
        this.fieldIndices = new byte[128];
        Arrays.fill(this.fieldIndices, (byte)-1);
        for (int i = 0; i < fields.length; i = (int)((byte)(i + 1))) {
            byte fieldName;
            if (fields[i].length() != 1) {
                throw new IllegalArgumentException("CDX field names must be a single ASCII character");
            }
            this.fieldNames[i] = fieldName = (byte)fields[i].charAt(0);
            this.fieldIndices[fieldName] = i;
        }
    }

    int indexOf(int field) {
        if (field > this.fieldIndices.length) {
            return -1;
        }
        return this.fieldIndices[field];
    }

    public String legend() {
        StringBuilder builder = new StringBuilder();
        for (byte fieldName : this.fieldNames) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append((char)fieldName);
        }
        return builder.toString();
    }

    public String toString() {
        return "CdxFormat(\"" + this.legend() + "\")";
    }

    public CdxRecord parse(String line) {
        try {
            return new CdxRecord(line, this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String format(WarcCaptureRecord record, String filename, long position, long size) {
        return this.format(record, filename, position, size, null);
    }

    public String format(WarcCaptureRecord record, String filename, long position, long size, String urlkey) {
        StringBuilder builder = new StringBuilder();
        for (byte fieldName : this.fieldNames) {
            String value;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            switch (fieldName) {
                case 103: {
                    value = filename;
                    break;
                }
                case 86: {
                    value = String.valueOf(position);
                    break;
                }
                case 83: {
                    value = String.valueOf(size);
                    break;
                }
                case 78: {
                    if (urlkey != null) {
                        value = urlkey;
                        break;
                    }
                    value = CdxFields.format(fieldName, record);
                    break;
                }
                default: {
                    value = CdxFields.format(fieldName, record);
                }
            }
            builder.append(value);
        }
        return builder.toString();
    }
}

