/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.jcr.security.AccessContext;
import org.silverpeas.core.jcr.security.SilverpeasJCRLoginModule;
import org.silverpeas.core.jcr.security.WebDavAccessContext;
import org.silverpeas.kernel.util.StringUtil;

public class SilverpeasTokenJCRLoginModule
extends SilverpeasJCRLoginModule {
    static final Set<Class> SUPPORTED_CREDENTIALS = Set.of(TokenCredentials.class);

    @Nonnull
    protected Set<Class> getSupportedCredentials() {
        return SUPPORTED_CREDENTIALS;
    }

    @Override
    protected User authenticateUser(Credentials credentials) throws LoginException {
        String token = ((TokenCredentials)credentials).getToken();
        User user = User.provider().getUserByToken(token);
        if (user == null) {
            throw new LoginException("User API Token '" + token + "' non valid!");
        }
        return user;
    }

    @Override
    @Nonnull
    protected AccessContext getAccessContext(Credentials credentials) {
        String grantedDocPath = ((TokenCredentials)credentials).getAttribute("AuthorizedDocumentPath");
        return StringUtil.isDefined((String)grantedDocPath) ? new WebDavAccessContext(grantedDocPath) : AccessContext.EMPTY;
    }
}

