/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.security;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.jcr.security.AccessContext;
import org.silverpeas.core.jcr.security.JCRAccessController;
import org.silverpeas.core.jcr.security.JCRNode;

class SilverpeasTreePermission
extends JCRAccessController
implements TreePermission {
    private final JCRTree tree;

    SilverpeasTreePermission(Tree tree, User user, AccessContext context) {
        super(user, context);
        this.tree = new JCRTree(tree);
    }

    @Nonnull
    public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
        Tree child = this.tree.getChild(childName);
        return new SilverpeasTreePermission(child, this.getUser(), this.getAccessContext());
    }

    public boolean canRead() {
        return this.isGranted(3L);
    }

    public boolean canRead(@Nonnull PropertyState property) {
        return this.isGranted(3L, property);
    }

    public boolean canReadAll() {
        return this.isGranted(131L);
    }

    public boolean canReadProperties() {
        return this.isGranted(3L);
    }

    public boolean isGranted(long permissions) {
        return this.isGranted(this.tree, permissions);
    }

    public boolean isGranted(long permissions, @Nonnull PropertyState property) {
        return this.isGranted(permissions);
    }

    private static class JCRTree
    extends JCRNode<Tree> {
        JCRTree(Tree tree) {
            super(tree);
        }

        @Override
        public String getPath() {
            return ((Tree)this.getNode()).getPath();
        }

        @Override
        public String getPrimaryType() {
            return TreeUtil.getPrimaryTypeName((Tree)((Tree)this.getNode()));
        }

        @Override
        public Stream<String> getMixinTypes() {
            Iterable mixins = TreeUtil.getMixinTypeNames((Tree)((Tree)this.getNode()));
            return StreamSupport.stream(mixins.spliterator(), false);
        }

        @Override
        public String getProperty(String name, int type) {
            PropertyState prop = ((Tree)this.getNode()).getProperty(name);
            Type propType = Type.fromTag((int)type, (boolean)false);
            return prop != null && prop.getType() == propType ? prop.getValue(propType).toString() : null;
        }

        public Tree getChild(String childName) {
            return ((Tree)this.getNode()).getChild(childName);
        }
    }
}

