/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.factories;

import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.slf4j.helpers.MessageFormatter;

public class GCLogger
implements GCMonitor {
    private final SilverLogger logger = SilverLogger.getLogger((Object)this);

    public void info(String message, Object ... arguments) {
        this.logger.info(MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), new Object[0]);
    }

    public void warn(String message, Object ... arguments) {
        this.logger.warn(MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), new Object[0]);
    }

    public void error(String message, Exception exception) {
        this.logger.error(message, (Throwable)exception);
    }

    public void skipped(String reason, Object ... arguments) {
        this.logger.info(MessageFormatter.arrayFormat((String)reason, (Object[])arguments).getMessage(), new Object[0]);
    }

    public void compacted() {
        this.logger.info("File store compacted", new Object[0]);
    }

    public void cleaned(long reclaimedSize, long currentSize) {
        this.logger.info("File store cleaned with reclaimed size of {0}. New current size of {1}", new Object[]{UnitUtil.formatMemSize((long)reclaimedSize), UnitUtil.formatMemSize((long)currentSize)});
    }

    public void updateStatus(String status) {
        this.logger.info("Current garbage collector status: {0}", new Object[]{status});
    }
}

