/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.X509Cert;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.jce.PKCS10CertificationRequest;

public class X509CertTest
extends TestCase {
    private String pkcs10request = "-----BEGIN CERTIFICATE REQUEST-----\r\nMIIBmTCCAQICAQAwXTELMAkGA1UEBhMCQkUxDDAKBgNVBAoTA25ldDEUMBIGA1UECxMLc291cmNlZm9yZ2UxDDAKBgNVBAMTA2JvYjEcMBoGA1UEChMTYm9iQHNvdXJjZWZvcmdlLm5ldDCBnTANBgkqhkiG9w0BAQEFAAOBiwAwgYcCgYEAjgiky6GyOaM1Yg5yVn/3FFX9/oZ/dEh778sfUVl3/GIa3ZJ5V7D/LzoDQhe813oej3f1xHFl0sw8zLiin7h00NshpLfuD1YQR7+0hCkZ4eSMWPJjBttn4BHF1xIM5RuvLhSoEmEQmCH1NIlddla2Ho/K53Bi03KzwdhTnYuKEksCAREwDQYJKoZIhvcNAQEEBQADgYEAfsks77dYx5SRFro2fpffJJw6wZidfaOvIbxll+9oKEjyWMFofe4Ni4TjcUuQKrjHM82hPfITB7qoIR+1Phv8YDUJF9ERP/UJJ/rj+4C+1utF62qRwMJ8XJn1S4R7/vSRfVT2/CENTTIYCh7TBDU/8BHvAOgYTqf7Jw7i/u13UJ0=\r\n-----END CERTIFICATE REQUEST-----";

    public void testPCKS10Request() throws Exception {
        PKCS10CertificationRequest cr = X509Cert.getPKCS10Request(this.pkcs10request);
        CertificationRequestInfo reqinfo = cr.getCertificationRequestInfo();
        Assert.assertEquals((String)"C=BE,O=net,OU=sourceforge,CN=bob,O=bob@sourceforge.net", (String)reqinfo.getSubject().toString());
    }

    public void testVerifyCertificate() throws Exception {
        X509Certificate alicecert = X509Cert.getCertificateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        X509Certificate bobcert = X509Cert.getCertificateFromP12("C:/tmp/bob.p12", "bob", new StringBuffer("password"));
        X509Certificate cacert = X509Cert.getCertificateFromP12("C:/tmp/ca.p12", "ca", new StringBuffer("password"));
        PrivateKey caprivkey = X509Cert.getPrivateFromP12("C:/tmp/ca.p12", "ca", new StringBuffer("password"));
        BigInteger[] certnumbers = new BigInteger[]{bobcert.getSerialNumber()};
        X509CRL crl = X509Cert.CreateCRL(certnumbers, 1, 24L, "MD5WithRSAEncryption", cacert, caprivkey);
        Assert.assertEquals((String)"VERIFIED", (String)X509Cert.verifyCertificate(alicecert, cacert, crl));
        Assert.assertEquals((String)"REVOKED", (String)X509Cert.verifyCertificate(bobcert, cacert, crl));
    }
}

