/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import net.sourceforge.jcetaglib.lib.CertTools;
import net.sourceforge.jcetaglib.lib.Seed;
import net.sourceforge.jcetaglib.tools.FileTools;
import net.sourceforge.jcetaglib.tools.KeyTools;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.misc.NetscapeCertType;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V2CRLGenerator;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class X509Cert {
    private static final String NS_CA = "ca";
    private static final String NS_SERVER = "server";
    private static final String NS_CLIENT = "client";
    private static final String NS_ALL = "all";

    public static KeyPair generateKeyPair(String keypairalgorithm, int keylength, byte[] seed) throws NoSuchAlgorithmException, NoSuchProviderException, CryptoException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator g = KeyPairGenerator.getInstance(keypairalgorithm, "BC");
        SecureRandom sr = Seed.getSecureRandom(seed);
        g.initialize(keylength, sr);
        return g.generateKeyPair();
    }

    public static X509Certificate selfsign(PrivateKey privatekey, PublicKey publickey, String signaturealgorithm, long validity, String subjectdn, boolean isca, String netscapeextensions) throws CertificateException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Date firstDate = new Date();
            firstDate.setTime(firstDate.getTime() - 600000L);
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 86400000L);
            X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
            byte[] serno = new byte[8];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(new Date().getTime());
            random.nextBytes(serno);
            BigInteger sn = new BigInteger(serno).abs();
            v3CertGen.setSerialNumber(sn);
            v3CertGen.setIssuerDN((X509Name)new X509Principal(subjectdn));
            v3CertGen.setNotBefore(firstDate);
            v3CertGen.setNotAfter(lastDate);
            v3CertGen.setSubjectDN((X509Name)new X509Principal(subjectdn));
            v3CertGen.setPublicKey(publickey);
            v3CertGen.setSignatureAlgorithm(signaturealgorithm);
            v3CertGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)CertTools.createSubjectKeyId(publickey));
            v3CertGen.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(isca));
            if (NS_CA.equalsIgnoreCase(netscapeextensions)) {
                v3CertGen.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(7));
            } else if (NS_SERVER.equalsIgnoreCase(netscapeextensions)) {
                v3CertGen.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(64));
            } else if (NS_CLIENT.equalsIgnoreCase(netscapeextensions)) {
                v3CertGen.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(176));
            } else if (NS_ALL.equalsIgnoreCase(netscapeextensions)) {
                v3CertGen.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(247));
            }
            X509Certificate cert = v3CertGen.generateX509Certificate(privatekey);
            cert.checkValidity(new Date());
            cert.verify(publickey);
            return cert;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CertificateException(e.getMessage());
        }
    }

    public static X509Certificate sign(PublicKey publickey, PrivateKey issuerprivatekey, X509Certificate issuercertificate, String signaturealgorithm, long validity, String subjectdn, boolean isca, String crldisturi, String netscapeextensions) throws CertificateException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Date firstDate = new Date();
            firstDate.setTime(firstDate.getTime() - 600000L);
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 86400000L);
            X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
            byte[] serno = new byte[8];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(new Date().getTime());
            random.nextBytes(serno);
            BigInteger sn = new BigInteger(serno).abs();
            String issuerDN = ((Object)issuercertificate.getSubjectDN()).toString();
            v3CertGen.setSerialNumber(sn);
            v3CertGen.setIssuerDN((X509Name)new X509Principal(issuerDN));
            v3CertGen.setNotBefore(firstDate);
            v3CertGen.setNotAfter(lastDate);
            v3CertGen.setSubjectDN((X509Name)new X509Principal(subjectdn));
            v3CertGen.setPublicKey(publickey);
            v3CertGen.setSignatureAlgorithm(signaturealgorithm);
            v3CertGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)CertTools.createSubjectKeyId(publickey));
            v3CertGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)CertTools.createAuthorityKeyId(issuercertificate.getPublicKey()));
            v3CertGen.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(isca));
            if (crldisturi != null && !crldisturi.equalsIgnoreCase("")) {
                GeneralName gn = new GeneralName((DERObject)new DERIA5String(crldisturi), 6);
                DERSequence seq = new DERSequence((DEREncodable)gn);
                GeneralNames gns = new GeneralNames((ASN1Sequence)seq);
                DistributionPointName dpn = new DistributionPointName(0, (DEREncodable)gns);
                DistributionPoint distp = new DistributionPoint(dpn, null, null);
                v3CertGen.addExtension(X509Extensions.CRLDistributionPoints.getId(), false, (DEREncodable)distp);
            }
            if (NS_CA.equalsIgnoreCase(netscapeextensions)) {
                v3CertGen.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(7));
            } else if (NS_SERVER.equalsIgnoreCase(netscapeextensions)) {
                v3CertGen.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(64));
            } else if (NS_CLIENT.equalsIgnoreCase(netscapeextensions)) {
                v3CertGen.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(176));
            } else if (NS_ALL.equalsIgnoreCase(netscapeextensions)) {
                v3CertGen.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(247));
            }
            X509Certificate cert = v3CertGen.generateX509Certificate(issuerprivatekey);
            cert.checkValidity(new Date());
            cert.verify(issuercertificate.getPublicKey());
            return cert;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CertificateException(e.getMessage());
        }
    }

    public static X509CRL CreateCRL(BigInteger[] certserialnumbers, int crlnumber, long crlperiod, String signaturealgorithm, X509Certificate cacert, PrivateKey caprivkey) throws CertificateException {
        X509CRL crl = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Date thisUpdate = new Date();
            Date nextUpdate = new Date();
            nextUpdate.setTime(nextUpdate.getTime() + crlperiod * 60L * 60L * 1000L);
            X509V2CRLGenerator crlgen = new X509V2CRLGenerator();
            crlgen.setThisUpdate(thisUpdate);
            crlgen.setNextUpdate(nextUpdate);
            crlgen.setSignatureAlgorithm(signaturealgorithm);
            crlgen.setIssuerDN((X509Name)new X509Principal(((Object)cacert.getSubjectDN()).toString()));
            for (int i = 0; i < certserialnumbers.length; ++i) {
                crlgen.addCRLEntry(certserialnumbers[i], thisUpdate, 0);
            }
            crlgen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)CertTools.createAuthorityKeyId(cacert.getPublicKey()));
            CRLNumber crlnum = new CRLNumber(BigInteger.valueOf(crlnumber));
            crlgen.addExtension(X509Extensions.CRLNumber.getId(), false, (DEREncodable)crlnum);
            crl = crlgen.generateX509CRL(caprivkey);
            return crl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CertificateException(e.getMessage());
        }
    }

    public static String verifyCertificate(X509Certificate cert, X509Certificate cacert, X509CRL crl) throws CertificateException {
        String status = "INVALID";
        try {
            if (crl.isRevoked(cert)) {
                status = "REVOKED";
            } else {
                try {
                    cert.checkValidity(new Date());
                }
                catch (Exception vae) {
                    status = "EXPIRED";
                }
                if (!status.equals("EXPIRED")) {
                    try {
                        cert.verify(cacert.getPublicKey());
                        status = "VERIFIED";
                    }
                    catch (Exception vee) {
                        status = "INVALID";
                    }
                }
            }
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CertificateException(e.getMessage());
        }
    }

    public static String getCertificateAsPem(X509Certificate cert) throws CertificateEncodingException {
        byte[] output = cert.getEncoded();
        byte[] certB64 = Base64.encode((byte[])output);
        return "-----BEGIN CERTIFICATE-----\n" + new String(certB64) + "\n-----END CERTIFICATE-----";
    }

    public static String getPrivateAsPem(PrivateKey privatekey) {
        byte[] output = privatekey.getEncoded();
        byte[] certB64 = Base64.encode((byte[])output);
        return "-----BEGIN PRIVATE KEY-----\n" + new String(certB64) + "\n-----END PRIVATE KEY-----";
    }

    public static void saveAsP12(X509Certificate cert, X509Certificate signedby, PrivateKey privatekey, String keystore, String entryname, StringBuffer password) throws KeyStoreException, NoSuchProviderException, Exception {
        KeyStore store = KeyStore.getInstance("PKCS12", "BC");
        store = KeyTools.createP12(entryname, privatekey, cert, signedby);
        store.store(new FileOutputStream(keystore), password.toString().toCharArray());
    }

    public static X509Certificate getCertificateFromP12(String keystore, String entryname, StringBuffer password) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, IOException, CertificateException {
        KeyStore store = KeyStore.getInstance("PKCS12", "BC");
        store.load(new FileInputStream(keystore), password.toString().toCharArray());
        Certificate[] certchain = KeyTools.getCertChain(store, entryname);
        return (X509Certificate)certchain[0];
    }

    public static X509Certificate getCACertificateFromP12(String keystore, String entryname, StringBuffer password) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, IOException, CertificateException {
        KeyStore store = KeyStore.getInstance("PKCS12", "BC");
        store.load(new FileInputStream(keystore), password.toString().toCharArray());
        Certificate[] certchain = KeyTools.getCertChain(store, entryname);
        return (X509Certificate)certchain[certchain.length - 1];
    }

    public static PrivateKey getPrivateFromP12(String keystore, String entryname, StringBuffer password) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, IOException, CertificateException, UnrecoverableKeyException {
        KeyStore store = KeyStore.getInstance("PKCS12", "BC");
        store.load(new FileInputStream(keystore), password.toString().toCharArray());
        return (PrivateKey)store.getKey(entryname, password.toString().toCharArray());
    }

    public static String replace(String text, String repl, String with) {
        if (text == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static PKCS10CertificationRequest getPKCS10Request(String request) throws CertificateException {
        PKCS10CertificationRequest pkcs10 = null;
        try {
            byte[] buffer;
            try {
                String beginKey = "-----BEGIN CERTIFICATE REQUEST-----";
                String endKey = "-----END CERTIFICATE REQUEST-----";
                buffer = FileTools.getBytesFromPEM(request.getBytes(), beginKey, endKey);
            }
            catch (IOException e) {
                try {
                    String beginKey = "-----BEGIN NEW CERTIFICATE REQUEST-----";
                    String endKey = "-----END NEW CERTIFICATE REQUEST-----";
                    buffer = FileTools.getBytesFromPEM(request.getBytes(), beginKey, endKey);
                }
                catch (IOException ioe) {
                    request = X509Cert.replace(request, "\n", "");
                    request = X509Cert.replace(request, "\r", "");
                    buffer = Base64.decode((byte[])request.getBytes());
                }
            }
            DERObject derobj = new DERInputStream((InputStream)new ByteArrayInputStream(buffer)).readObject();
            ASN1Sequence seq = (ASN1Sequence)derobj;
            pkcs10 = new PKCS10CertificationRequest(seq);
            if (!pkcs10.verify()) {
                throw new CertificateException("Not a valid PKCS10 request");
            }
            return pkcs10;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CertificateException(e.getMessage());
        }
    }

    public static NetscapeCertRequest getNetscapeRequest(String request) throws CertificateException {
        NetscapeCertRequest nscr = null;
        try {
            request = X509Cert.replace(request, "\n", "");
            request = X509Cert.replace(request, "\r", "");
            byte[] buffer = Base64.decode((byte[])request.getBytes());
            DERInputStream in = new DERInputStream((InputStream)new ByteArrayInputStream(buffer));
            DERSequence spkac = (DERSequence)in.readObject();
            nscr = new NetscapeCertRequest((ASN1Sequence)spkac);
            nscr.setChallenge("challenge");
            if (!nscr.verify("challenge")) {
                throw new CertificateException("Not a valid Netscape request");
            }
            return nscr;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CertificateException(e.getMessage());
        }
    }
}

