/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import net.sourceforge.jcetaglib.exceptions.HeaderException;
import net.sourceforge.jcetaglib.exceptions.InvalidHMACException;
import net.sourceforge.jcetaglib.exceptions.InvalidSignatureException;
import net.sourceforge.jcetaglib.lib.Clean;
import net.sourceforge.jcetaglib.lib.Seed;
import net.sourceforge.jcetaglib.tools.MacInputStream;
import net.sourceforge.jcetaglib.tools.MacOutputStream;
import net.sourceforge.jcetaglib.tools.SignatureInputStream;
import net.sourceforge.jcetaglib.tools.SignatureOutputStream;
import net.sourceforge.jcetaglib.tools.SignerCertificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class Hybrid {
    private static int BUFFERSIZE_TEXT = 1204;
    private static int BUFFERSIZE_FILE = 8192;
    static final int FILE_HEADER = 32257;
    static final int DATA_BLOCK = 1;
    static final int FINAL_DATA_BLOCK = 2;
    static final int HMAC_BLOCK = 3;
    static final int SIG_BLOCK = 3;
    static final int CERT_BLOCK = 4;
    static final int KEY_BLOCK = 16;
    static final int IV_BLOCK = 17;
    static final int LOCK_BLOCK = 18;
    static final int HMAC_KEY_BLOCK = 18;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer encryptWithHMAC(StringBuffer text, PublicKey receiverKey, String algorithm, byte[] seed, int strength, String mode, String padding) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Hybrid.encryptWithHMAC(new ByteArrayInputStream(text.toString().getBytes()), dao, receiverKey, algorithm, seed, strength, mode, padding, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
                Object var11_11 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static void encryptFileWithHMAC(String file, String newfile, PublicKey receiverKey, String algorithm, byte[] seed, int strength, String mode, String padding) throws CryptoException, IOException {
        block14: {
            IOException e22;
            FilterOutputStream dao;
            FileInputStream fis;
            block13: {
                fis = null;
                FileOutputStream fos = null;
                dao = null;
                fis = new FileInputStream(file);
                fos = new FileOutputStream(newfile);
                dao = new DataOutputStream(fos);
                Hybrid.encryptWithHMAC(fis, (DataOutputStream)dao, receiverKey, algorithm, seed, strength, mode, padding, BUFFERSIZE_FILE);
                Object var13_11 = null;
                if (dao == null) break block13;
                try {
                    dao.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e22) {}
            }
            break block14;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new IOException(ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var13_12 = null;
                if (dao != null) {
                    try {
                        dao.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptWithHMAC(InputStream is, DataOutputStream daos, PublicKey receiverKey, String algorithm, byte[] seed, int strength, String mode, String padding, int bufferlength) throws CryptoException, IOException {
        MacOutputStream macStr = null;
        FilterOutputStream dataStr = null;
        try {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                SecureRandom secRand = Seed.getSecureRandom(seed);
                KeyGenerator keyGen = KeyGenerator.getInstance(algorithm, "BC");
                keyGen.init(strength, secRand);
                SecretKey symKey = keyGen.generateKey();
                Cipher outputCipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                outputCipher.init(1, (Key)symKey, secRand);
                byte[] keyEnc = symKey.getEncoded();
                byte[] keyIV = outputCipher.getIV();
                Mac mac = Mac.getInstance("HMACSHA1", "BC");
                byte[] macKeyBytes = new byte[20];
                secRand.nextBytes(macKeyBytes);
                SecretKeySpec macKey = new SecretKeySpec(macKeyBytes, "HMACSHA1");
                mac.init(macKey);
                Cipher rsaEng = Cipher.getInstance("RSA/None/OAEPPadding", "BC");
                rsaEng.init(1, (Key)receiverKey, secRand);
                macStr = new MacOutputStream(daos, mac);
                dataStr = new DataOutputStream(macStr);
                ((DataOutputStream)dataStr).writeShort(32257);
                ((DataOutputStream)dataStr).writeShort(16);
                byte[] tmp = rsaEng.doFinal(keyEnc);
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                Clean.blank(tmp);
                ((DataOutputStream)dataStr).writeShort(17);
                tmp = rsaEng.doFinal(keyIV);
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                Clean.blank(tmp);
                ((DataOutputStream)dataStr).writeShort(18);
                tmp = outputCipher.doFinal(macKey.getEncoded());
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                Clean.blank(tmp);
                int l = 0;
                byte[] buf = new byte[bufferlength];
                byte[] out = null;
                while ((l = is.read(buf)) > -1) {
                    out = outputCipher.update(buf, 0, l);
                    if (out == null) continue;
                    ((DataOutputStream)dataStr).writeShort(1);
                    ((DataOutputStream)dataStr).writeInt(out.length);
                    dataStr.write(out);
                }
                out = outputCipher.doFinal();
                ((DataOutputStream)dataStr).writeShort(2);
                ((DataOutputStream)dataStr).writeInt(out.length);
                dataStr.write(out);
                Clean.blank(buf);
                buf = null;
                ((DataOutputStream)dataStr).writeShort(3);
                ((DataOutputStream)dataStr).flush();
                tmp = mac.doFinal();
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                Clean.blank(tmp);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException(ioe.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CryptoException(ex.getMessage());
            }
            Object var26_27 = null;
            if (dataStr == null) return;
        }
        catch (Throwable throwable) {
            Object var26_28 = null;
            if (dataStr == null) throw throwable;
            try {
                dataStr.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        dataStr.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer decryptAndVerifyHMAC(StringBuffer text, PrivateKey privKey, String algorithm, String mode, String padding) throws HeaderException, InvalidHMACException, CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Hybrid.decryptAndVerifyHMAC(new ByteArrayInputStream(Base64.decode((String)text.toString())), dao, privKey, algorithm, mode, padding, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(bao.toByteArray()));
                Object var9_11 = null;
                if (dao == null) return stringBuffer;
            }
            catch (HeaderException he) {
                throw new HeaderException(he.getMessage());
            }
            catch (InvalidHMACException ihe) {
                throw new InvalidHMACException(ihe.getMessage());
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static void decryptFileAndVerifyHMAC(String file, String newfile, PrivateKey privKey, String algorithm, String mode, String padding) throws CryptoException, HeaderException, InvalidHMACException, IOException {
        block45: {
            IOException e22;
            FileOutputStream outStr;
            FilterInputStream dataStr;
            block44: {
                short cmd;
                Mac mac = null;
                Cipher cipher = null;
                Cipher decHMAC = null;
                SecretKeySpec symKey = null;
                SecretKeySpec macKey = null;
                byte[] keyIV = null;
                byte[] macCode = null;
                DataInputStream dataIn = null;
                MacInputStream macStr = null;
                dataStr = null;
                outStr = null;
                Security.addProvider((Provider)new BouncyCastleProvider());
                SecureRandom secRand = SecureRandom.getInstance("SHA1PRNG", "SUN");
                dataIn = new DataInputStream(new FileInputStream(file));
                int l = 0;
                boolean ena = false;
                boolean stop = false;
                Cipher rsaEng = Cipher.getInstance("RSA/None/OAEPPadding", "BC");
                rsaEng.init(2, (Key)privKey, secRand);
                while (!stop) {
                    try {
                        byte[] d;
                        cmd = dataIn.readShort();
                        if (cmd == 32257) {
                            ena = true;
                            continue;
                        }
                        if (cmd == 1) {
                            if (!ena) {
                                throw new HeaderException("Broken header");
                            }
                            l = dataIn.readInt();
                            dataIn.skip(l);
                            continue;
                        }
                        if (cmd == 2) {
                            if (!ena) {
                                throw new HeaderException("Broken header");
                            }
                            l = dataIn.readInt();
                            dataIn.skip(l);
                            continue;
                        }
                        if (cmd == 3) {
                            if (!ena) {
                                throw new HeaderException("Broken header");
                            }
                            l = dataIn.readInt();
                            macCode = new byte[l];
                            dataIn.readFully(macCode);
                            continue;
                        }
                        if (cmd == 16) {
                            if (!ena) {
                                throw new HeaderException("Broken header");
                            }
                            l = dataIn.readInt();
                            d = new byte[l];
                            dataIn.readFully(d);
                            symKey = new SecretKeySpec(rsaEng.doFinal(d), algorithm);
                            continue;
                        }
                        if (cmd == 17) {
                            if (!ena) {
                                throw new HeaderException("Broken header");
                            }
                            l = dataIn.readInt();
                            keyIV = new byte[l];
                            dataIn.readFully(keyIV);
                            keyIV = rsaEng.doFinal(keyIV);
                            continue;
                        }
                        if (cmd != 18) continue;
                        if (!ena) {
                            throw new HeaderException("Broken header");
                        }
                        decHMAC = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                        decHMAC.init(2, (Key)symKey, new IvParameterSpec(keyIV));
                        l = dataIn.readInt();
                        d = new byte[l];
                        dataIn.readFully(d);
                        macKey = new SecretKeySpec(decHMAC.doFinal(d), "HMACSHA1");
                    }
                    catch (EOFException eof) {
                        stop = true;
                    }
                }
                mac = Mac.getInstance("HMACSHA1", "BC");
                mac.init(macKey);
                macStr = new MacInputStream(new FileInputStream(file), mac);
                dataStr = new DataInputStream(macStr);
                cmd = 0;
                byte[] buf = new byte[BUFFERSIZE_FILE];
                l = 0;
                do {
                    if ((cmd = ((DataInputStream)dataStr).readShort()) == 1) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd == 2) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd == 16) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd == 17) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd != 18) continue;
                    l = ((DataInputStream)dataStr).readInt();
                    ((DataInputStream)dataStr).read(buf, 0, l);
                } while (cmd != 3);
                buf = mac.doFinal();
                dataStr.close();
                if (!MessageDigest.isEqual(buf, macCode)) {
                    throw new InvalidHMACException("Invalid HMAC");
                }
                cipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                cipher.init(2, (Key)symKey, new IvParameterSpec(keyIV));
                outStr = new FileOutputStream(newfile);
                dataStr = new DataInputStream(new FileInputStream(file));
                stop = false;
                cmd = 0;
                l = 0;
                buf = new byte[BUFFERSIZE_FILE];
                byte[] out = null;
                while (true) {
                    if ((cmd = ((DataInputStream)dataStr).readShort()) == 1) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).readFully(buf, 0, l);
                        out = cipher.update(buf, 0, l);
                        if (out != null) {
                            outStr.write(out);
                        }
                    }
                    if (cmd == 2) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).readFully(buf, 0, l);
                        out = cipher.doFinal(buf, 0, l);
                        if (out == null) break;
                        outStr.write(out);
                        break;
                    }
                    if (cmd == 16) {
                        l = ((DataInputStream)dataStr).readInt();
                        dataStr.skip(l);
                    }
                    if (cmd == 17) {
                        l = ((DataInputStream)dataStr).readInt();
                        dataStr.skip(l);
                    }
                    if (cmd == 3) {
                        l = ((DataInputStream)dataStr).readInt();
                        dataStr.skip(l);
                    }
                    if (cmd != 18) continue;
                    l = ((DataInputStream)dataStr).readInt();
                    dataStr.skip(l);
                }
                Object var26_30 = null;
                if (outStr == null) break block44;
                try {
                    outStr.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (dataStr != null) {
                try {
                    dataStr.close();
                }
                catch (IOException e22) {}
            }
            break block45;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new IOException(ioe.getMessage());
                }
                catch (HeaderException he) {
                    he.printStackTrace();
                    throw new HeaderException(he.getMessage());
                }
                catch (InvalidHMACException ihe) {
                    ihe.printStackTrace();
                    throw new InvalidHMACException(ihe.getMessage());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new CryptoException(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var26_31 = null;
                if (outStr != null) {
                    try {
                        outStr.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (dataStr != null) {
                    try {
                        dataStr.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static void decryptAndVerifyHMAC(InputStream is, DataOutputStream daos, PrivateKey privKey, String algorithm, String mode, String padding, int bufferlength) throws IOException, HeaderException, InvalidHMACException, CryptoException {
        Mac mac = null;
        Cipher cipher = null;
        Cipher decHMAC = null;
        SecretKeySpec symKey = null;
        SecretKeySpec macKey = null;
        byte[] keyIV = null;
        byte[] macCode = null;
        DataInputStream dataIn = null;
        MacInputStream macStr = null;
        DataInputStream dataStr = null;
        try {
            short cmd;
            Security.addProvider((Provider)new BouncyCastleProvider());
            SecureRandom secRand = SecureRandom.getInstance("SHA1PRNG", "SUN");
            dataIn = new DataInputStream(is);
            int l = 0;
            boolean ena = false;
            boolean stop = false;
            Cipher rsaEng = Cipher.getInstance("RSA/None/OAEPPadding", "BC");
            rsaEng.init(2, (Key)privKey, secRand);
            while (!stop) {
                try {
                    byte[] d;
                    cmd = dataIn.readShort();
                    if (cmd == 32257) {
                        ena = true;
                        continue;
                    }
                    if (cmd == 1) {
                        if (!ena) {
                            throw new HeaderException("Broken header");
                        }
                        l = dataIn.readInt();
                        dataIn.skip(l);
                        continue;
                    }
                    if (cmd == 2) {
                        if (!ena) {
                            throw new HeaderException("Broken header");
                        }
                        l = dataIn.readInt();
                        dataIn.skip(l);
                        continue;
                    }
                    if (cmd == 3) {
                        if (!ena) {
                            throw new HeaderException("Broken header");
                        }
                        l = dataIn.readInt();
                        macCode = new byte[l];
                        dataIn.readFully(macCode);
                        continue;
                    }
                    if (cmd == 16) {
                        if (!ena) {
                            throw new HeaderException("Broken header");
                        }
                        l = dataIn.readInt();
                        d = new byte[l];
                        dataIn.readFully(d);
                        symKey = new SecretKeySpec(rsaEng.doFinal(d), algorithm);
                        continue;
                    }
                    if (cmd == 17) {
                        if (!ena) {
                            throw new HeaderException("Broken header");
                        }
                        l = dataIn.readInt();
                        keyIV = new byte[l];
                        dataIn.readFully(keyIV);
                        keyIV = rsaEng.doFinal(keyIV);
                        continue;
                    }
                    if (cmd != 18) continue;
                    if (!ena) {
                        throw new HeaderException("Broken header");
                    }
                    decHMAC = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                    decHMAC.init(2, (Key)symKey, new IvParameterSpec(keyIV));
                    l = dataIn.readInt();
                    d = new byte[l];
                    dataIn.readFully(d);
                    macKey = new SecretKeySpec(decHMAC.doFinal(d), "HMACSHA1");
                }
                catch (EOFException eof) {
                    stop = true;
                }
            }
            mac = Mac.getInstance("HMACSHA1", "BC");
            mac.init(macKey);
            is.reset();
            macStr = new MacInputStream(is, mac);
            dataStr = new DataInputStream(macStr);
            cmd = 0;
            byte[] buf = new byte[bufferlength];
            l = 0;
            do {
                if ((cmd = dataStr.readShort()) == 1) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd == 2) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd == 16) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd == 17) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd != 18) continue;
                l = dataStr.readInt();
                dataStr.read(buf, 0, l);
            } while (cmd != 3);
            buf = mac.doFinal();
            dataStr.close();
            if (!MessageDigest.isEqual(buf, macCode)) {
                throw new InvalidHMACException("Invalid HMAC");
            }
            cipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
            cipher.init(2, (Key)symKey, new IvParameterSpec(keyIV));
            is.reset();
            dataStr = new DataInputStream(is);
            stop = false;
            cmd = 0;
            l = 0;
            buf = new byte[bufferlength];
            byte[] out = null;
            while (true) {
                if ((cmd = dataStr.readShort()) == 1) {
                    l = dataStr.readInt();
                    dataStr.readFully(buf, 0, l);
                    out = cipher.update(buf, 0, l);
                    if (out != null) {
                        daos.write(out);
                    }
                }
                if (cmd == 2) {
                    l = dataStr.readInt();
                    dataStr.readFully(buf, 0, l);
                    out = cipher.doFinal(buf, 0, l);
                    if (out != null) {
                        daos.write(out);
                    }
                    break;
                }
                if (cmd == 16) {
                    l = dataStr.readInt();
                    dataStr.skip(l);
                }
                if (cmd == 17) {
                    l = dataStr.readInt();
                    dataStr.skip(l);
                }
                if (cmd == 3) {
                    l = dataStr.readInt();
                    dataStr.skip(l);
                }
                if (cmd != 18) continue;
                l = dataStr.readInt();
                dataStr.skip(l);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException(ioe.getMessage());
        }
        catch (HeaderException he) {
            he.printStackTrace();
            throw new HeaderException(he.getMessage());
        }
        catch (InvalidHMACException ihe) {
            ihe.printStackTrace();
            throw new InvalidHMACException(ihe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer encryptAndSign(StringBuffer text, PublicKey receiverKey, PrivateKey signingKey, X509Certificate cert, String signame, String algorithm, byte[] seed, int strength, String mode, String padding) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Hybrid.encryptAndSign(new ByteArrayInputStream(text.toString().getBytes()), dao, receiverKey, signingKey, cert, signame, algorithm, seed, strength, mode, padding, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
                Object var14_14 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static void encryptFileAndSign(String file, String newfile, PublicKey receiverKey, PrivateKey signingKey, X509Certificate cert, String signame, String algorithm, byte[] seed, int strength, String mode, String padding) throws CryptoException, IOException {
        block14: {
            IOException e22;
            FilterOutputStream dao;
            FileInputStream fis;
            block13: {
                fis = null;
                FileOutputStream fos = null;
                dao = null;
                fis = new FileInputStream(file);
                fos = new FileOutputStream(newfile);
                dao = new DataOutputStream(fos);
                Hybrid.encryptAndSign(fis, (DataOutputStream)dao, receiverKey, signingKey, cert, signame, algorithm, seed, strength, mode, padding, BUFFERSIZE_FILE);
                Object var16_14 = null;
                if (dao == null) break block13;
                try {
                    dao.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e22) {}
            }
            break block14;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new IOException(ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var16_15 = null;
                if (dao != null) {
                    try {
                        dao.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptAndSign(InputStream is, DataOutputStream daos, PublicKey receiverKey, PrivateKey signingKey, X509Certificate cert, String signame, String algorithm, byte[] seed, int strength, String mode, String padding, int bufferlength) throws CryptoException, IOException {
        SecureRandom secRand = null;
        KeyGenerator keyGen = null;
        SecretKey symKey = null;
        Cipher outputCipher = null;
        SignatureOutputStream sigStr = null;
        FilterOutputStream dataStr = null;
        try {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                secRand = Seed.getSecureRandom(seed);
                keyGen = KeyGenerator.getInstance(algorithm, "BC");
                keyGen.init(strength, secRand);
                symKey = keyGen.generateKey();
                outputCipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                outputCipher.init(1, (Key)symKey, secRand);
                byte[] keyEnc = symKey.getEncoded();
                byte[] keyIV = outputCipher.getIV();
                byte[] lock = new byte[24];
                secRand.nextBytes(lock);
                Signature sig = Signature.getInstance(signame, "BC");
                sig.initSign(signingKey, secRand);
                sig.update(lock);
                Cipher rsaEng = Cipher.getInstance("RSA/None/OAEPPadding", "BC");
                rsaEng.init(1, (Key)receiverKey, secRand);
                sigStr = new SignatureOutputStream(daos, sig);
                dataStr = new DataOutputStream(sigStr);
                ((DataOutputStream)dataStr).writeShort(32257);
                ((DataOutputStream)dataStr).writeShort(16);
                byte[] tmp = rsaEng.doFinal(keyEnc);
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                Clean.blank(tmp);
                ((DataOutputStream)dataStr).writeShort(17);
                tmp = rsaEng.doFinal(keyIV);
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                Clean.blank(tmp);
                ((DataOutputStream)dataStr).writeShort(18);
                tmp = outputCipher.doFinal(lock);
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                Clean.blank(tmp);
                outputCipher.init(1, (Key)symKey, new IvParameterSpec(keyIV));
                int l = 0;
                byte[] buf = new byte[bufferlength];
                byte[] out = null;
                while ((l = is.read(buf)) > -1) {
                    out = outputCipher.update(buf, 0, l);
                    if (out == null) continue;
                    ((DataOutputStream)dataStr).writeShort(1);
                    ((DataOutputStream)dataStr).writeInt(out.length);
                    dataStr.write(out);
                }
                out = outputCipher.doFinal();
                ((DataOutputStream)dataStr).writeShort(2);
                ((DataOutputStream)dataStr).writeInt(out.length);
                dataStr.write(out);
                Clean.blank(buf);
                buf = null;
                ((DataOutputStream)dataStr).writeShort(4);
                tmp = cert.getEncoded();
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                ((DataOutputStream)dataStr).writeShort(3);
                ((DataOutputStream)dataStr).flush();
                tmp = sig.sign();
                ((DataOutputStream)dataStr).writeInt(tmp.length);
                dataStr.write(tmp);
                Clean.blank(tmp);
                ((DataOutputStream)dataStr).flush();
                dataStr.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException(ioe.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CryptoException(ex.getMessage());
            }
            Object var28_29 = null;
            if (dataStr == null) return;
        }
        catch (Throwable throwable) {
            Object var28_30 = null;
            if (dataStr == null) throw throwable;
            try {
                dataStr.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        dataStr.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer decryptAndVerify(StringBuffer text, PrivateKey privKey, SignerCertificate signercert, String signame, String algorithm, String mode, String padding) throws HeaderException, InvalidSignatureException, CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Hybrid.decryptAndVerify(new ByteArrayInputStream(Base64.decode((String)text.toString())), dao, privKey, signercert, signame, algorithm, mode, padding, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(bao.toByteArray()));
                Object var11_13 = null;
                if (dao == null) return stringBuffer;
            }
            catch (HeaderException he) {
                throw new HeaderException(he.getMessage());
            }
            catch (InvalidSignatureException ise) {
                throw new InvalidSignatureException(ise.getMessage());
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    public static void decryptAndVerify(InputStream is, DataOutputStream daos, PrivateKey privKey, SignerCertificate signercert, String signame, String algorithm, String mode, String padding, int bufferlength) throws CryptoException, HeaderException, InvalidSignatureException, IOException {
        byte[] lockData = null;
        X509Certificate cert = null;
        SecretKeySpec symKey = null;
        byte[] keyIV = null;
        byte[] sigCode = null;
        DataInputStream dataIn = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            SecureRandom secRand = SecureRandom.getInstance("SHA1PRNG", "SUN");
            dataIn = new DataInputStream(is);
            int l = 0;
            boolean ena = false;
            boolean stop = false;
            Cipher rsaEng = Cipher.getInstance("RSA/None/OAEPPadding", "BC");
            rsaEng.init(2, (Key)privKey, secRand);
            while (!stop) {
                try {
                    byte[] d;
                    short cmd = dataIn.readShort();
                    if (cmd == 32257) {
                        ena = true;
                        continue;
                    }
                    if (cmd == 1) {
                        if (!ena) {
                            throw new Exception("Broken header");
                        }
                        l = dataIn.readInt();
                        dataIn.skip(l);
                        continue;
                    }
                    if (cmd == 2) {
                        if (!ena) {
                            throw new Exception("Broken header");
                        }
                        l = dataIn.readInt();
                        dataIn.skip(l);
                        continue;
                    }
                    if (cmd == 3) {
                        if (!ena) {
                            throw new Exception("Broken header");
                        }
                        l = dataIn.readInt();
                        sigCode = new byte[l];
                        dataIn.readFully(sigCode);
                        continue;
                    }
                    if (cmd == 16) {
                        if (!ena) {
                            throw new Exception("Broken header");
                        }
                        l = dataIn.readInt();
                        d = new byte[l];
                        dataIn.readFully(d);
                        symKey = new SecretKeySpec(rsaEng.doFinal(d), algorithm);
                        continue;
                    }
                    if (cmd == 17) {
                        if (!ena) {
                            throw new Exception("Broken header");
                        }
                        l = dataIn.readInt();
                        keyIV = new byte[l];
                        dataIn.readFully(keyIV);
                        keyIV = rsaEng.doFinal(keyIV);
                        continue;
                    }
                    if (cmd == 18) {
                        if (!ena) {
                            throw new Exception("Broken header");
                        }
                        Cipher decLock = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                        decLock.init(2, (Key)symKey, new IvParameterSpec(keyIV));
                        l = dataIn.readInt();
                        byte[] d2 = new byte[l];
                        dataIn.readFully(d2);
                        lockData = decLock.doFinal(d2);
                        decLock = null;
                        continue;
                    }
                    if (cmd != 4) continue;
                    if (!ena) {
                        throw new Exception("Broken header");
                    }
                    l = dataIn.readInt();
                    d = new byte[l];
                    dataIn.readFully(d);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(d));
                }
                catch (EOFException eof) {
                    stop = true;
                }
            }
            signercert.setCert(cert);
            Signature sig = Signature.getInstance(signame, "BC");
            sig.initVerify(cert);
            sig.update(lockData);
            is.reset();
            SignatureInputStream sigStr = new SignatureInputStream(is, sig);
            DataInputStream dataStr = new DataInputStream(sigStr);
            short cmd = 0;
            byte[] buf = new byte[bufferlength];
            l = 0;
            do {
                if ((cmd = dataStr.readShort()) == 1) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd == 2) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd == 16) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd == 17) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd == 18) {
                    l = dataStr.readInt();
                    dataStr.read(buf, 0, l);
                }
                if (cmd != 4) continue;
                l = dataStr.readInt();
                dataStr.read(buf, 0, l);
            } while (cmd != 3);
            dataStr.close();
            if (!sig.verify(sigCode)) {
                throw new InvalidSignatureException("Signature is invalid");
            }
            Cipher cipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
            cipher.init(2, (Key)symKey, new IvParameterSpec(keyIV));
            is.reset();
            dataStr = new DataInputStream(is);
            stop = false;
            cmd = 0;
            l = 0;
            buf = new byte[bufferlength];
            byte[] out = null;
            while (true) {
                if ((cmd = dataStr.readShort()) == 1) {
                    l = dataStr.readInt();
                    dataStr.readFully(buf, 0, l);
                    out = cipher.update(buf, 0, l);
                    if (out != null) {
                        daos.write(out);
                    }
                }
                if (cmd == 2) {
                    l = dataStr.readInt();
                    dataStr.readFully(buf, 0, l);
                    out = cipher.doFinal(buf, 0, l);
                    if (out == null) break;
                    daos.write(out);
                    break;
                }
                if (cmd == 16) {
                    l = dataStr.readInt();
                    dataStr.skip(l);
                }
                if (cmd == 17) {
                    l = dataStr.readInt();
                    dataStr.skip(l);
                }
                if (cmd == 18) {
                    l = dataStr.readInt();
                    dataStr.skip(l);
                }
                if (cmd == 4) {
                    l = dataStr.readInt();
                    dataStr.skip(l);
                }
                if (cmd != 3) continue;
                l = dataStr.readInt();
                dataStr.skip(l);
            }
            Clean.blank(buf);
            buf = null;
            dataStr.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException(ioe.getMessage());
        }
        catch (HeaderException he) {
            he.printStackTrace();
            throw new HeaderException(he.getMessage());
        }
        catch (InvalidSignatureException ise) {
            ise.printStackTrace();
            throw new InvalidSignatureException(ise.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoException(ex.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    public static void decryptFileAndVerify(String file, String newfile, PrivateKey privKey, SignerCertificate signercert, String signame, String algorithm, String mode, String padding) throws CryptoException, HeaderException, InvalidSignatureException, IOException {
        block49: {
            IOException e22;
            FilterInputStream dataStr;
            FileOutputStream outStr;
            block48: {
                byte[] lockData = null;
                X509Certificate cert = null;
                SecretKeySpec symKey = null;
                byte[] keyIV = null;
                byte[] sigCode = null;
                SignatureInputStream sigStr = null;
                DataInputStream dataIn = null;
                outStr = null;
                dataStr = null;
                Security.addProvider((Provider)new BouncyCastleProvider());
                SecureRandom secRand = SecureRandom.getInstance("SHA1PRNG", "SUN");
                dataIn = new DataInputStream(new FileInputStream(file));
                int l = 0;
                boolean ena = false;
                boolean stop = false;
                Cipher rsaEng = Cipher.getInstance("RSA/None/OAEPPadding", "BC");
                rsaEng.init(2, (Key)privKey, secRand);
                while (!stop) {
                    try {
                        byte[] d;
                        short cmd = dataIn.readShort();
                        if (cmd == 32257) {
                            ena = true;
                            continue;
                        }
                        if (cmd == 1) {
                            if (!ena) {
                                throw new Exception("Broken header");
                            }
                            l = dataIn.readInt();
                            dataIn.skip(l);
                            continue;
                        }
                        if (cmd == 2) {
                            if (!ena) {
                                throw new Exception("Broken header");
                            }
                            l = dataIn.readInt();
                            dataIn.skip(l);
                            continue;
                        }
                        if (cmd == 3) {
                            if (!ena) {
                                throw new Exception("Broken header");
                            }
                            l = dataIn.readInt();
                            sigCode = new byte[l];
                            dataIn.readFully(sigCode);
                            continue;
                        }
                        if (cmd == 16) {
                            if (!ena) {
                                throw new Exception("Broken header");
                            }
                            l = dataIn.readInt();
                            d = new byte[l];
                            dataIn.readFully(d);
                            symKey = new SecretKeySpec(rsaEng.doFinal(d), algorithm);
                            continue;
                        }
                        if (cmd == 17) {
                            if (!ena) {
                                throw new Exception("Broken header");
                            }
                            l = dataIn.readInt();
                            keyIV = new byte[l];
                            dataIn.readFully(keyIV);
                            keyIV = rsaEng.doFinal(keyIV);
                            continue;
                        }
                        if (cmd == 18) {
                            if (!ena) {
                                throw new Exception("Broken header");
                            }
                            Cipher decLock = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                            decLock.init(2, (Key)symKey, new IvParameterSpec(keyIV));
                            l = dataIn.readInt();
                            byte[] d2 = new byte[l];
                            dataIn.readFully(d2);
                            lockData = decLock.doFinal(d2);
                            decLock = null;
                            continue;
                        }
                        if (cmd != 4) continue;
                        if (!ena) {
                            throw new Exception("Broken header");
                        }
                        l = dataIn.readInt();
                        d = new byte[l];
                        dataIn.readFully(d);
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(d));
                    }
                    catch (EOFException eof) {
                        stop = true;
                    }
                }
                signercert.setCert(cert);
                Signature sig = Signature.getInstance(signame, "BC");
                sig.initVerify(cert);
                sig.update(lockData);
                sigStr = new SignatureInputStream(new FileInputStream(file), sig);
                dataStr = new DataInputStream(sigStr);
                short cmd = 0;
                byte[] buf = new byte[BUFFERSIZE_FILE];
                l = 0;
                do {
                    if ((cmd = ((DataInputStream)dataStr).readShort()) == 1) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd == 2) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd == 16) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd == 17) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd == 18) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).read(buf, 0, l);
                    }
                    if (cmd != 4) continue;
                    l = ((DataInputStream)dataStr).readInt();
                    ((DataInputStream)dataStr).read(buf, 0, l);
                } while (cmd != 3);
                dataStr.close();
                if (!sig.verify(sigCode)) {
                    throw new InvalidSignatureException("Signature is invalid");
                }
                Cipher cipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                cipher.init(2, (Key)symKey, new IvParameterSpec(keyIV));
                outStr = new FileOutputStream(newfile);
                dataStr = new DataInputStream(new FileInputStream(file));
                stop = false;
                cmd = 0;
                l = 0;
                buf = new byte[BUFFERSIZE_FILE];
                byte[] out = null;
                while (true) {
                    if ((cmd = ((DataInputStream)dataStr).readShort()) == 1) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).readFully(buf, 0, l);
                        out = cipher.update(buf, 0, l);
                        if (out != null) {
                            outStr.write(out);
                        }
                    }
                    if (cmd == 2) {
                        l = ((DataInputStream)dataStr).readInt();
                        ((DataInputStream)dataStr).readFully(buf, 0, l);
                        out = cipher.doFinal(buf, 0, l);
                        if (out == null) break;
                        outStr.write(out);
                        break;
                    }
                    if (cmd == 16) {
                        l = ((DataInputStream)dataStr).readInt();
                        dataStr.skip(l);
                    }
                    if (cmd == 17) {
                        l = ((DataInputStream)dataStr).readInt();
                        dataStr.skip(l);
                    }
                    if (cmd == 18) {
                        l = ((DataInputStream)dataStr).readInt();
                        dataStr.skip(l);
                    }
                    if (cmd == 4) {
                        l = ((DataInputStream)dataStr).readInt();
                        dataStr.skip(l);
                    }
                    if (cmd != 3) continue;
                    l = ((DataInputStream)dataStr).readInt();
                    dataStr.skip(l);
                }
                Clean.blank(buf);
                buf = null;
                Object var28_34 = null;
                if (outStr == null) break block48;
                try {
                    outStr.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (dataStr != null) {
                try {
                    dataStr.close();
                }
                catch (IOException e22) {}
            }
            break block49;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new IOException(ioe.getMessage());
                }
                catch (HeaderException he) {
                    he.printStackTrace();
                    throw new HeaderException(he.getMessage());
                }
                catch (InvalidSignatureException ise) {
                    ise.printStackTrace();
                    throw new InvalidSignatureException(ise.getMessage());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new CryptoException(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var28_35 = null;
                if (outStr != null) {
                    try {
                        outStr.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (dataStr != null) {
                    try {
                        dataStr.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

