/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserFieldDeclElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserFieldDeclsElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableDeclElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableDeclsElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableSetElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.common.field.Field;
import org.odftoolkit.simple.common.field.VariableContainer;
import org.w3c.dom.Node;

public class VariableField
extends Field {
    private final VariableType type;
    private final String name;
    private TextVariableDeclElement simpleVariableElement;
    private TextVariableDeclsElement simpleVariableElements;
    private TextUserFieldDeclElement userVariableElement;
    private TextUserFieldDeclsElement userVariableElements;

    VariableField(VariableContainer container, String name, VariableType type) {
        this.type = type;
        this.name = name;
        OdfElement containerElement = container.getVariableContainerElement();
        switch (type) {
            case SIMPLE: {
                this.simpleVariableElements = (TextVariableDeclsElement)OdfElement.findFirstChildNode(TextVariableDeclsElement.class, (Node)containerElement);
                if (this.simpleVariableElements == null) {
                    this.simpleVariableElements = (TextVariableDeclsElement)((OdfFileDom)containerElement.getOwnerDocument()).newOdfElement(TextVariableDeclsElement.class);
                    containerElement.insertBefore((Node)this.simpleVariableElements, containerElement.getFirstChild());
                } else {
                    for (TextVariableDeclElement simpleVariableElementTmp = (TextVariableDeclElement)this.simpleVariableElements.getFirstChild(); simpleVariableElementTmp != null; simpleVariableElementTmp = (TextVariableDeclElement)simpleVariableElementTmp.getNextSibling()) {
                        if (!name.equals(simpleVariableElementTmp.getTextNameAttribute())) continue;
                        this.simpleVariableElement = simpleVariableElementTmp;
                        break;
                    }
                }
                if (this.simpleVariableElement != null) break;
                this.simpleVariableElement = this.simpleVariableElements.newTextVariableDeclElement("string", name);
                break;
            }
            case USER: {
                this.userVariableElements = (TextUserFieldDeclsElement)OdfElement.findFirstChildNode(TextUserFieldDeclsElement.class, (Node)containerElement);
                if (this.userVariableElements == null) {
                    this.userVariableElements = (TextUserFieldDeclsElement)((OdfFileDom)containerElement.getOwnerDocument()).newOdfElement(TextUserFieldDeclsElement.class);
                    containerElement.insertBefore((Node)this.userVariableElements, containerElement.getFirstChild());
                } else {
                    for (TextUserFieldDeclElement userVariableElementTmp = (TextUserFieldDeclElement)this.userVariableElements.getFirstChild(); userVariableElementTmp != null; userVariableElementTmp = (TextUserFieldDeclElement)userVariableElementTmp.getNextSibling()) {
                        if (!name.equals(userVariableElementTmp.getTextNameAttribute())) continue;
                        this.userVariableElement = userVariableElementTmp;
                        break;
                    }
                }
                if (this.userVariableElement != null) break;
                this.userVariableElement = this.userVariableElements.newTextUserFieldDeclElement(0.0, "string", name);
                break;
            }
            case SEQUENCE: {
                throw new IllegalArgumentException("Simple Java API for ODF doesn't support this type now.");
            }
        }
        Component.registerComponent(this, this.getOdfElement());
    }

    public void updateField(String value, OdfElement refElement) {
        String officeNS = OdfDocumentNamespace.OFFICE.getUri();
        switch (this.type) {
            case SIMPLE: {
                TextVariableSetElement textVariableSetElement = null;
                if (refElement instanceof TextPElement) {
                    textVariableSetElement = ((TextPElement)refElement).newTextVariableSetElement(0.0, "string", this.name);
                } else if (refElement instanceof TextSpanElement) {
                    textVariableSetElement = ((TextSpanElement)refElement).newTextVariableSetElement(0.0, "string", this.name);
                } else {
                    TextPElement pElement = (TextPElement)((OdfFileDom)refElement.getOwnerDocument()).newOdfElement(TextPElement.class);
                    OdfElement parentEle = (OdfElement)refElement.getParentNode();
                    parentEle.insertBefore((Node)pElement, refElement.getNextSibling());
                    textVariableSetElement = pElement.newTextVariableSetElement(0.0, "string", this.name);
                }
                textVariableSetElement.removeAttributeNS(officeNS, "value");
                textVariableSetElement.setOfficeStringValueAttribute(value);
                textVariableSetElement.setTextContent(value);
                break;
            }
            case USER: {
                this.userVariableElement.setOfficeValueTypeAttribute("string");
                this.userVariableElement.setOfficeStringValueAttribute(value);
                break;
            }
            case SEQUENCE: {
                throw new IllegalArgumentException("Simple Java API for ODF doesn't support this type now.");
            }
        }
    }

    public void displayField(OdfElement refElement) {
        if (refElement instanceof TextSpanElement) {
            TextSpanElement spanEle = (TextSpanElement)refElement;
            switch (this.type) {
                case SIMPLE: {
                    spanEle.newTextVariableGetElement(this.name);
                    break;
                }
                case USER: {
                    spanEle.newTextUserFieldGetElement(this.name);
                    break;
                }
                case SEQUENCE: {
                    throw new IllegalArgumentException("Simple Java API for ODF doesn't support this type now.");
                }
            }
        } else {
            TextPElement textPElement;
            if (refElement instanceof TextPElement) {
                textPElement = (TextPElement)refElement;
            } else {
                textPElement = (TextPElement)((OdfFileDom)refElement.getOwnerDocument()).newOdfElement(TextPElement.class);
                OdfElement parentEle = (OdfElement)refElement.getParentNode();
                parentEle.insertBefore((Node)textPElement, refElement.getNextSibling());
            }
            switch (this.type) {
                case SIMPLE: {
                    textPElement.newTextVariableGetElement(this.name);
                    break;
                }
                case USER: {
                    textPElement.newTextUserFieldGetElement(this.name);
                    break;
                }
                case SEQUENCE: {
                    throw new IllegalArgumentException("Simple Java API for ODF doesn't support this type now.");
                }
            }
        }
    }

    public String getVariableName() {
        return this.name;
    }

    @Override
    public OdfElement getOdfElement() {
        switch (this.type) {
            case SIMPLE: {
                return this.simpleVariableElement;
            }
            case USER: {
                return this.userVariableElement;
            }
            case SEQUENCE: {
                throw new IllegalArgumentException("Simple Java API for ODF doesn't support this type now.");
            }
        }
        return null;
    }

    @Override
    public Field.FieldType getFieldType() {
        switch (this.type) {
            case SIMPLE: {
                return Field.FieldType.SIMPLE_VARIABLE_FIELD;
            }
            case USER: {
                return Field.FieldType.USER_VARIABLE_FIELD;
            }
            case SEQUENCE: {
                throw new IllegalArgumentException("Simple Java API for ODF doesn't support this type now.");
            }
        }
        return null;
    }

    public static enum VariableType {
        SIMPLE("simple"),
        USER("user"),
        SEQUENCE("sequence");

        private final String variableType;

        private VariableType(String type) {
            this.variableType = type;
        }

        public String toString() {
            return this.variableType;
        }
    }
}

