/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.ClassUtils;

public class ClientHttpRequestFactorySelector {
    private static final boolean HTTP_COMPONENTS_AVAILABLE = ClassUtils.isPresent((String)"org.apache.http.client.HttpClient", (ClassLoader)ClientHttpRequestFactory.class.getClassLoader());

    public static ClientHttpRequestFactory foo() {
        return new HttpComponentsClientHttpRequestFactory();
    }

    public static ClientHttpRequestFactory getRequestFactory() {
        int proxyPort;
        Properties properties = System.getProperties();
        String proxyHost = properties.getProperty("http.proxyHost");
        int n = proxyPort = properties.containsKey("http.proxyPort") ? Integer.valueOf(properties.getProperty("http.proxyPort")) : 80;
        if (HTTP_COMPONENTS_AVAILABLE) {
            return HttpComponentsClientRequestFactoryCreator.createRequestFactory(proxyHost, proxyPort);
        }
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (proxyHost != null) {
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        }
        return requestFactory;
    }

    public static ClientHttpRequestFactory bufferRequests(ClientHttpRequestFactory requestFactory) {
        return new BufferingClientHttpRequestFactory(requestFactory);
    }

    public static class HttpComponentsClientRequestFactoryCreator {
        public static ClientHttpRequestFactory createRequestFactory(String proxyHost, int proxyPort) {
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(){

                protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                    HttpClientContext context = new HttpClientContext();
                    context.setAttribute("http.protocol.expect-continue", (Object)false);
                    return context;
                }
            };
            if (proxyHost != null) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                CloseableHttpClient httpClient = HttpClients.custom().setProxy(proxy).build();
                requestFactory.setHttpClient((HttpClient)httpClient);
            }
            return requestFactory;
        }
    }
}

