/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.AbstractOAuth2ServiceProvider;
import org.springframework.social.oauth2.OAuth2Template;
import org.springframework.social.oauth2.TokenStrategy;
import org.springframework.web.client.RestOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOAuth2ServiceProvider
extends AbstractOAuth2ServiceProvider<RestOperations> {
    private TokenStrategy tokenStrategy;

    public GenericOAuth2ServiceProvider(String appId, String appSecret, String authorizeUrl, String authenticateUrl, String accessTokenUrl, boolean useParametersForClientCredentials, TokenStrategy tokenStrategy) {
        super(GenericOAuth2ServiceProvider.getOAuth2Template(appId, appSecret, authorizeUrl, authenticateUrl, accessTokenUrl, useParametersForClientCredentials));
        this.tokenStrategy = tokenStrategy;
    }

    @Override
    public RestOperations getApi(String accessToken) {
        return new GenericApiBinding(accessToken, this.tokenStrategy).getRestTemplate();
    }

    private static OAuth2Template getOAuth2Template(String appId, String appSecret, String authorizeUrl, String authenticateUrl, String accessTokenUrl, boolean useParameters) {
        OAuth2Template oAuth2Template = new OAuth2Template(appId, appSecret, authorizeUrl, authenticateUrl != null ? authenticateUrl : authorizeUrl, accessTokenUrl);
        oAuth2Template.setUseParametersForClientAuthentication(useParameters);
        return oAuth2Template;
    }

    private static class GenericApiBinding
    extends AbstractOAuth2ApiBinding {
        public GenericApiBinding(String accessToken, TokenStrategy tokenStrategy) {
            super(accessToken, tokenStrategy);
        }
    }
}

