/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.support.AbstractConnection;
import org.springframework.social.oauth1.OAuth1ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth1Connection<A>
extends AbstractConnection<A> {
    private static final long serialVersionUID = -808097401993144389L;
    private final transient OAuth1ServiceProvider<A> serviceProvider;
    private String accessToken;
    private String secret;
    private transient A api;

    public OAuth1Connection(String providerId, String providerUserId, String accessToken, String secret, OAuth1ServiceProvider<A> serviceProvider, ApiAdapter<A> apiAdapter) {
        super(apiAdapter);
        this.serviceProvider = serviceProvider;
        this.initAccessTokens(accessToken, secret);
        this.initApi();
        this.initKey(providerId, providerUserId);
    }

    public OAuth1Connection(ConnectionData data, OAuth1ServiceProvider<A> serviceProvider, ApiAdapter<A> apiAdapter) {
        super(data, apiAdapter);
        this.serviceProvider = serviceProvider;
        this.initAccessTokens(data.getAccessToken(), data.getSecret());
        this.initApi();
    }

    @Override
    public A getApi() {
        return this.api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionData createData() {
        Object object = this.getMonitor();
        synchronized (object) {
            return new ConnectionData(this.getKey().getProviderId(), this.getKey().getProviderUserId(), this.getDisplayName(), this.getProfileUrl(), this.getImageUrl(), this.accessToken, this.secret, null, null);
        }
    }

    private void initAccessTokens(String accessToken, String secret) {
        this.accessToken = accessToken;
        this.secret = secret;
    }

    private void initApi() {
        this.api = this.serviceProvider.getApi(this.accessToken, this.secret);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        result = 31 * result + (this.secret == null ? 0 : this.secret.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth1Connection other = (OAuth1Connection)obj;
        if (this.accessToken == null ? other.accessToken != null : !this.accessToken.equals(other.accessToken)) {
            return false;
        }
        return !(this.secret == null ? other.secret != null : !this.secret.equals(other.secret));
    }
}

