/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Supplier;
import org.silverpeas.core.admin.component.model.SilverpeasComponentDataProvider;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.kernel.ManagedBeanProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.Mutable;

public final class ServiceProvider {
    private ServiceProvider() {
    }

    public static <T> T getService(Class<T> type, Annotation ... qualifiers) {
        return (T)ServiceProvider.provide(() -> ServiceProvider.beanProvider().getManagedBean(type, qualifiers));
    }

    public static <T> T getService(String name) {
        return (T)ServiceProvider.provide(() -> ServiceProvider.beanProvider().getManagedBean(name));
    }

    public static <T> Set<T> getAllServices(Class<T> type, Annotation ... qualifiers) {
        return ServiceProvider.provide(() -> ServiceProvider.beanProvider().getAllManagedBeans(type, qualifiers));
    }

    public static <T> T getService(String applicationId, String apiName) {
        Mutable componentName = Mutable.ofNullable((Object)SilverpeasComponentInstance.getComponentName(applicationId));
        if (!componentName.isPresent()) {
            componentName.set((Object)applicationId);
        }
        boolean workflow = false;
        try {
            workflow = SilverpeasComponentDataProvider.get().isWorkflow((String)componentName.get());
        }
        catch (SilverpeasRuntimeException silverpeasRuntimeException) {
            // empty catch block
        }
        String serviceName = workflow ? "processManager" + apiName : ((String)componentName.get()).substring(0, 1).toLowerCase() + ((String)componentName.get()).substring(1) + apiName;
        return ServiceProvider.getService(serviceName);
    }

    private static <T> T provide(Supplier<T> beanSupplier) {
        try {
            return beanSupplier.get();
        }
        catch (RuntimeException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    private static ManagedBeanProvider beanProvider() {
        return ManagedBeanProvider.getInstance();
    }
}

