/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.scheduler.trigger;

import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.Date;
import org.silverpeas.core.scheduler.trigger.JobTriggerProvider;
import org.silverpeas.core.scheduler.trigger.JobTriggerVisitor;
import org.silverpeas.core.scheduler.trigger.TimeUnit;
import org.silverpeas.core.util.ArgumentAssertion;

public abstract class JobTrigger {
    private Date startDate;

    public abstract void accept(JobTriggerVisitor var1);

    public Date getStartDate() {
        return this.startDate;
    }

    public static JobTrigger triggerEvery(int time, TimeUnit unit) {
        return JobTriggerProvider.getJobTriggerWithPeriodicity(time, unit);
    }

    public static JobTrigger triggerAt(String cron) throws ParseException {
        return JobTriggerProvider.getJobTriggerWithCronExpression(cron);
    }

    public static JobTrigger triggerAt(OffsetDateTime dateTime) {
        return JobTriggerProvider.getJobTriggerAtDateTime(dateTime);
    }

    public JobTrigger startAt(Date startDate) {
        ArgumentAssertion.assertNotNull(startDate, "Either the start date of the job is null or it is anterior at now!");
        this.startDate = startDate;
        return this;
    }
}

