/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.ConnectionPool;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class DBUtil {
    private static final Object MUTEX = new Object();
    private static final int MAX_NB_ATTEMPT = 100;
    private static final int TEXT_FIELD_LENGTH = 1000;
    private static final int TEXT_AREA_LENGTH = 2000;
    private static final int DATE_FIELD_LENGTH = 10;
    private static final String TABLE_NAME = "TABLE_NAME";

    public static int getDateFieldLength() {
        return 10;
    }

    public static int getTextAreaLength() {
        return 2000;
    }

    public static int getTextFieldLength() {
        return 1000;
    }

    public String toString() {
        return super.toString();
    }

    public static Connection openConnection() throws SQLException {
        return ConnectionPool.getConnection();
    }

    public static String getUniqueId() {
        return UUID.randomUUID().toString();
    }

    public static int getNextId(String identifierName) {
        return DBUtil.getNextId(identifierName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextId(String identifierName, String tableFieldIdentifierName) {
        String identifierNameLowerCase = identifierName.toLowerCase(Locale.ROOT);
        for (int nbAttempts = 0; nbAttempts < 100; ++nbAttempts) {
            Object object = MUTEX;
            synchronized (object) {
                Integer nextUniqueMaxId = DBUtil.nextUniqueIdentifierValue(identifierNameLowerCase);
                if (nextUniqueMaxId == null) {
                    DBUtil.registeringIdentifierName(identifierNameLowerCase, tableFieldIdentifierName);
                } else if (nextUniqueMaxId != -1) {
                    return nextUniqueMaxId;
                }
                continue;
            }
        }
        throw new SilverpeasRuntimeException("computing of next id not possible for " + identifierName + " with " + tableFieldIdentifierName + "primary key");
    }

    private static Integer nextUniqueIdentifierValue(String identifierNameLowerCase) {
        return Transaction.performInNew(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private static void registeringIdentifierName(String identifierNameLowerCase, String tableFieldIdentifierName) {
        try {
            Transaction.performInNew(() -> {
                int currentUniqueValue = 0;
                try (Connection connection = DBUtil.openConnection();){
                    if (StringUtil.isDefined((String)tableFieldIdentifierName) && DBUtil.getAllTableNames(connection).contains(identifierNameLowerCase.toLowerCase())) {
                        try (PreparedStatement selectTableCurrentUniqueValueStmt = connection.prepareStatement(String.format("SELECT MAX(%s) FROM %s", tableFieldIdentifierName, identifierNameLowerCase));
                             ResultSet rs = selectTableCurrentUniqueValueStmt.executeQuery();){
                            if (rs.next()) {
                                currentUniqueValue = rs.getInt(1);
                            }
                        }
                    }
                    try (PreparedStatement registerIdentifierStmt = connection.prepareStatement("INSERT INTO UniqueId (maxId, tableName) VALUES (?, ?)");){
                        registerIdentifierStmt.setInt(1, currentUniqueValue);
                        registerIdentifierStmt.setString(2, identifierNameLowerCase);
                        registerIdentifierStmt.executeUpdate();
                    }
                    SilverLogger.getLogger(DBUtil.class).debug("A new entry has been registered into UniqueId table for '" + identifierNameLowerCase + "' table", new Object[0]);
                }
                return null;
            });
        }
        catch (Exception e) {
            SilverLogger.getLogger(DBUtil.class).warn("The unique identifier '" + identifierNameLowerCase + "' has not been registered because another server process has just done the same operation for the same resource.", new Object[0]);
        }
    }

    public static void close(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                SilverLogger.getLogger(DBUtil.class).error(e.getMessage(), (Throwable)e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                SilverLogger.getLogger(DBUtil.class).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(Statement st) {
        DBUtil.close(null, st);
    }

    public static void close(ResultSet rs) {
        DBUtil.close(rs, null);
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                SilverLogger.getLogger(DBUtil.class).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void rollback(Connection connection) {
        if (connection != null) {
            try {
                if (!connection.getAutoCommit() && !connection.isClosed()) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                SilverLogger.getLogger(DBUtil.class).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Set<String> getAllTableNames(Connection connection) throws SQLException {
        LinkedHashSet<String> tableNames = new LinkedHashSet<String>();
        DatabaseMetaData dbMetaData = connection.getMetaData();
        try (ResultSet tablesRs = dbMetaData.getTables(null, null, null, null);){
            tablesRs.getMetaData();
            while (tablesRs.next()) {
                tableNames.add(tablesRs.getString(TABLE_NAME).toLowerCase());
            }
        }
        return tableNames;
    }

    public static Set<String> getAllTableNames() {
        Set<String> set;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                set = DBUtil.getAllTableNames(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignore) {
                    return Collections.emptySet();
                }
            }
            connection.close();
        }
        return set;
    }
}

