/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.repository;

import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.persistence.datasource.repository.Parameters;
import org.silverpeas.kernel.util.StringUtil;

public interface QueryCriteria {
    public PaginationCriterion pagination();

    public Clause clause();

    public static class Clause {
        private final Parameters parameters;
        private final StringBuilder text = new StringBuilder();

        public <T extends Parameters> Clause(String criterionText, T parameters) {
            this.text.append(criterionText).append(" ");
            this.parameters = parameters;
        }

        public <T extends Parameters> Clause(T parameters) {
            this.parameters = parameters;
        }

        public Clause add(String criterionText) {
            if (StringUtil.isDefined((String)criterionText)) {
                this.text.append(criterionText.trim()).append(" ");
            }
            return this;
        }

        public Clause replaceLast(String criterionText) {
            int lastCriterion = this.text.toString().trim().lastIndexOf(" ");
            this.text.replace(lastCriterion + 1, this.text.length(), criterionText.trim()).append(" ");
            return this;
        }

        public String text() {
            return this.text.toString().trim();
        }

        public <T extends Parameters> T parameters() {
            return (T)this.parameters;
        }
    }
}

