/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client;

import java.util.Date;
import java.util.Optional;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.util.Link;
import org.silverpeas.kernel.logging.SilverLogger;

public class NotificationParameters {
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_URGENT = 1;
    public static final int PRIORITY_ERROR = 2;
    static final String USAGE_PRO = "addressUsePro";
    static final String USAGE_PERSO = "addressUsePerso";
    static final String USAGE_REP = "addressUseRep";
    static final String USAGE_URGENT = "addressUseUrgent";
    public static final int MAX_SIZE_TITLE = 1023;
    private int iMessagePriority = 0;
    private int addressId = BuiltInNotifAddress.COMPONENT_DEFINED.getId();
    private int iComponentInstance = -1;
    private int iFromUserId = -1;
    private String sTitle = "";
    private String senderName = "";
    private String sMessage = "";
    private Link link = Link.EMPTY_LINK;
    private String sSource = "";
    private String sSessionId = "";
    private String sOriginalExtraMessage = null;
    private boolean bAnswerAllowed = false;
    private boolean bSendImmediately = false;
    private Date dDate = new Date();
    private String sLanguage = null;
    private NotifAction eAction = null;
    private NotificationResourceData nNotificationResourceData = null;

    public int getMessagePriority() {
        return this.iMessagePriority;
    }

    public NotificationParameters setMessagePriority(int iMessagePriority) {
        this.iMessagePriority = iMessagePriority;
        return this;
    }

    public int getAddressId() {
        return this.addressId;
    }

    public NotificationParameters setAddressId(int notifMediaType) {
        this.addressId = notifMediaType;
        return this;
    }

    public boolean isAddressDefinedByComponent() {
        return this.getAddressId() == BuiltInNotifAddress.COMPONENT_DEFINED.getId();
    }

    public int getComponentInstance() {
        return this.iComponentInstance;
    }

    public NotificationParameters setComponentInstance(int iComponentInstance) {
        this.iComponentInstance = iComponentInstance < 0 ? -1 : iComponentInstance;
        return this;
    }

    public boolean isComponentInstanceDefined() {
        return this.iComponentInstance != -1;
    }

    public int getFromUserId() {
        return this.iFromUserId;
    }

    public NotificationParameters setFromUserId(int iFromUserId) {
        this.iFromUserId = iFromUserId < 0 ? -1 : iFromUserId;
        return this;
    }

    public boolean isFromUserIdDefined() {
        return this.iFromUserId != -1;
    }

    public String getTitle() {
        return this.sTitle;
    }

    public NotificationParameters setTitle(String sTitle) {
        this.sTitle = sTitle == null ? "" : sTitle;
        return this;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public NotificationParameters setSenderName(String senderName) {
        this.senderName = senderName;
        return this;
    }

    public String getMessage() {
        return this.sMessage;
    }

    public NotificationParameters setMessage(String sMessage) {
        this.sMessage = sMessage == null ? "" : sMessage;
        return this;
    }

    public Link getLink() {
        return this.link;
    }

    public NotificationParameters setLink(Link link) {
        this.link = link;
        return this;
    }

    public String getSource() {
        return this.sSource;
    }

    public NotificationParameters setSource(String sSource) {
        this.sSource = sSource;
        return this;
    }

    public String getSessionId() {
        return this.sSessionId;
    }

    public NotificationParameters setSessionId(String sSessionId) {
        this.sSessionId = sSessionId;
        return this;
    }

    public String getOriginalExtraMessage() {
        return this.sOriginalExtraMessage;
    }

    public NotificationParameters setOriginalExtraMessage(String sOriginalExtraMessage) {
        this.sOriginalExtraMessage = sOriginalExtraMessage;
        return this;
    }

    public boolean isAnswerAllowed() {
        return this.bAnswerAllowed;
    }

    public NotificationParameters setAnswerAllowed(boolean bAnswerAllowed) {
        this.bAnswerAllowed = bAnswerAllowed;
        return this;
    }

    public boolean isSendImmediately() {
        return this.bSendImmediately;
    }

    public NotificationParameters setSendImmediately(boolean bSendImmediately) {
        this.bSendImmediately = bSendImmediately;
        return this;
    }

    public Date getDate() {
        return this.dDate;
    }

    public NotificationParameters setDate(Date dDate) {
        this.dDate = dDate;
        return this;
    }

    public String getLanguage() {
        return this.sLanguage;
    }

    public NotificationParameters setLanguage(String sLanguage) {
        this.sLanguage = sLanguage;
        return this;
    }

    public NotifAction getAction() {
        return this.eAction;
    }

    public NotificationParameters setAction(NotifAction eAction) {
        this.eAction = eAction;
        return this;
    }

    public NotificationResourceData getNotificationResourceData() {
        return this.nNotificationResourceData;
    }

    public NotificationParameters setNotificationResourceData(NotificationResourceData nNotificationResourceData) {
        this.nNotificationResourceData = nNotificationResourceData;
        return this;
    }

    boolean isTitleExceedsMaxSize() {
        return this.getTitle().length() >= 1023;
    }

    void trace() {
        StringBuilder trace = new StringBuilder("Notification Parameters Dump: {");
        if (this.iMessagePriority == 0) {
            trace.append("MessagePriority: NORMAL, ");
        } else if (this.iMessagePriority == 1) {
            trace.append("MessagePriority: URGENT, ");
        } else if (this.iMessagePriority == 2) {
            trace.append("MessagePriority: ERROR, ");
        }
        Optional<BuiltInNotifAddress> mediaType = BuiltInNotifAddress.decode(this.addressId);
        trace.append("MediaType: ");
        if (mediaType.isPresent()) {
            trace.append(mediaType.get().name()).append(", ");
        } else {
            trace.append(this.addressId).append(", ");
        }
        trace.append("ComponentInstance: ").append(this.iComponentInstance);
        trace.append(", Title: ").append(this.sTitle);
        trace.append(", Message: ").append(this.sMessage);
        trace.append(", FromUserId: ").append(this.iFromUserId);
        trace.append(", FromSenderName: ").append(this.senderName);
        trace.append(", AnswerAllowed: ").append(this.bAnswerAllowed);
        trace.append(", SendImmediately: ").append(this.bSendImmediately);
        trace.append(", Source: ").append(this.sSource);
        trace.append(", SessionId: ").append(this.sSessionId);
        trace.append(", Date: ").append(this.dDate.toString());
        trace.append(", Action: ").append(this.eAction != null ? this.eAction.name() : "N/A");
        trace.append("}");
        SilverLogger.getLogger((Object)this).debug(trace.toString(), new Object[0]);
    }
}

