/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.message;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.core.notification.message.Message;
import org.silverpeas.core.notification.message.MessageListener;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

public class MessageContainer {
    private final List<MessageListener> listeners = new ArrayList<MessageListener>();
    private String language = DisplayI18NHelper.getDefaultLanguage();
    private final Set<Message> messages = new LinkedHashSet<Message>();

    MessageContainer() {
    }

    public LocalizationBundle getLocalizationBundle(String bundleBaseName, String lang) {
        return ResourceLocator.getLocalizationBundle((String)bundleBaseName, (String)lang);
    }

    public void addListener(MessageListener listener) {
        this.listeners.add(listener);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        for (MessageListener messageListener : this.listeners) {
            messageListener.beforeGetLanguage(this);
        }
        return this.language;
    }

    public void addMessage(Message message) {
        for (MessageListener messageListener : this.listeners) {
            messageListener.beforeAddMessage(this, message);
        }
        this.messages.add(message);
        for (MessageListener messageListener : this.listeners) {
            messageListener.afterMessageAdded(this, message);
        }
    }

    @NonNull
    public Set<Message> getMessages() {
        return this.messages;
    }
}

