/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.kernel.util.StringUtil;

public abstract class ImportExportDescriptor {
    public static final String NO_MIMETYPE = "";
    private String mimeType = "";
    private Map<String, Serializable> parameters = new HashMap<String, Serializable>();

    public String getMimeType() {
        return this.mimeType;
    }

    public <O extends ImportExportDescriptor> O inMimeType(String mimeType) {
        if (!StringUtil.isDefined((String)mimeType)) {
            this.mimeType = NO_MIMETYPE;
        }
        this.mimeType = mimeType;
        return (O)this;
    }

    public <T extends Serializable, O extends ImportExportDescriptor> O withParameter(String name, T value) {
        this.parameters.put(name, value);
        return (O)this;
    }

    public <T extends Serializable> void setParameter(String name, T value) {
        this.parameters.put(name, value);
    }

    public <O extends ImportExportDescriptor> O withoutParameter(String name) {
        this.parameters.remove(name);
        return (O)this;
    }

    public <T> T getParameter(String name) {
        return (T)this.parameters.get(name);
    }

    public List<String> getParameters() {
        return new ArrayList<String>(this.parameters.keySet());
    }

    public boolean isParameterSet(String name) {
        return this.parameters.containsKey(name);
    }
}

