/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.indicator;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.contribution.indicator.NewContributionIndicator;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.util.Pair;

@Singleton
public class ContributionIndicatorRegistry {
    private final Map<String, NewContributionIndicator> newRegistry = new HashMap<String, NewContributionIndicator>();

    protected ContributionIndicatorRegistry() {
    }

    public static ContributionIndicatorRegistry get() {
        return ServiceProvider.getService(ContributionIndicatorRegistry.class, new Annotation[0]);
    }

    public void addNewContributionIndicator(NewContributionIndicator indicator) {
        Pair<String, String> relatedTo = indicator.relatedToComponentAndResourceType();
        this.newRegistry.put((String)relatedTo.getFirst() + "@" + (String)relatedTo.getSecond(), indicator);
    }

    protected Optional<NewContributionIndicator> getNewContributionIndicatorBy(ContributionIdentifier cId) {
        String componentName = SilverpeasComponentInstance.getComponentName(cId.getComponentInstanceId());
        return Optional.ofNullable(this.newRegistry.get(componentName + "@" + cId.getType()));
    }
}

