/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.components.forums.model.Forum;
import org.silverpeas.components.forums.model.ForumDetail;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.components.forums.model.Message;
import org.silverpeas.components.forums.model.MessagePK;
import org.silverpeas.components.forums.model.Moderator;
import org.silverpeas.components.forums.service.ForumsRuntimeException;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class ForumsDAO {
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String SELECT = "SELECT ";
    private static final String WHERE = " WHERE ";
    private static final String SELECT_COUNT = "SELECT COUNT(";
    private static final String EQUAL_TO_PARAM = " = ? ";
    private static final String AND = " AND ";
    private static final String ORDER_BY = " ORDER BY ";
    private static final String DESC = " DESC";
    private static final String FORUM_COLUMN_FORUM_ID = "forumId";
    private static final String FORUM_COLUMN_FORUM_NAME = "forumName";
    private static final String FORUM_COLUMN_FORUM_DESCRIPTION = "forumDescription";
    private static final String FORUM_COLUMN_FORUM_ACTIVE = "forumActive";
    private static final String FORUM_COLUMN_FORUM_PARENT = "forumParent";
    private static final String FORUM_COLUMN_CATEGORY_ID = "categoryId";
    private static final String FORUM_COLUMN_INSTANCE_ID = "instanceId";
    private static final String FORUM_COLUMN_FORUM_CREATION_DATE = "forumCreationDate";
    private static final String FORUM_COLUMN_FORUM_CREATOR = "forumCreator";
    private static final String FORUM_COLUMN_FORUM_LOCK_LEVEL = "forumLockLevel";
    private static final String FORUM_COLUMNS = "forumId, forumName, forumDescription, forumActive, forumParent, categoryId, instanceId, forumCreationDate, forumCreator";
    private static final String MESSAGE_TABLE = "SC_Forums_Message";
    private static final String MESSAGE_COLUMN_MESSAGE_ID = "messageId";
    private static final String MESSAGE_COLUMN_MESSAGE_TITLE = "messageTitle";
    private static final String MESSAGE_COLUMN_MESSAGE_AUTHOR = "messageAuthor";
    private static final String MESSAGE_COLUMN_FORUM_ID = "forumId";
    private static final String MESSAGE_COLUMN_MESSAGE_PARENT_ID = "messageParentId";
    private static final String MESSAGE_COLUMN_MESSAGE_DATE = "messageDate";
    private static final String MESSAGE_COLUMN_STATUS = "status";
    private static final String MESSAGE_COLUMNS = "messageId, messageTitle, messageAuthor, forumId, messageParentId, messageDate , status";
    private static final String RIGHTS_TABLE = "SC_Forums_Rights";
    private static final String RIGHTS_COLUMN_USER_ID = "userId";
    private static final String RIGHTS_COLUMN_FORUM_ID = "forumId";
    private static final String RIGHTS_COLUMNS = "userId, forumId";
    private static final String HISTORY_TABLE = "SC_Forums_HistoryUser";
    private static final String HISTORY_COLUMN_USER_ID = "userId";
    private static final String HISTORY_COLUMN_MESSAGE_ID = "messageId";
    private static final String HISTORY_COLUMN_LAST_ACCESS = "lastAccess";
    private static final String HISTORY_COLUMNS = "userId, messageId, lastAccess";
    private static final String QUERY_GET_FORUMS_LIST = "SELECT forumId, forumName, forumDescription, forumActive, forumParent, categoryId, instanceId, forumCreationDate, forumCreator FROM sc_forums_forum WHERE instanceId = ?";
    private static final String QUERY_GET_FORUMS_IDS = "SELECT forumId FROM sc_forums_forum WHERE instanceId = ?";
    private static final String QUERY_GET_FORUMS_LIST_BY_CATEGORY_WITH_NOT_NULL_CATEGORY = "SELECT forumId, forumName, forumDescription, forumActive, forumParent, categoryId, instanceId, forumCreationDate, forumCreator FROM sc_forums_forum WHERE instanceId = ? AND categoryId = ?";
    private static final String QUERY_GET_FORUMS_LIST_BY_CATEGORY_WITH_NULL_CATEGORY = "SELECT forumId, forumName, forumDescription, forumActive, forumParent, categoryId, instanceId, forumCreationDate, forumCreator FROM sc_forums_forum WHERE instanceId = ? AND categoryId IS NULL";
    private static final String QUERY_GET_FORUM_SONS = "SELECT forumId FROM sc_forums_forum WHERE forumParent = ? AND instanceId = ?";
    private static final String QUERY_GET_FORUM = "SELECT forumId, forumName, forumDescription, forumActive, forumParent, categoryId, instanceId, forumCreationDate, forumCreator FROM sc_forums_forum WHERE forumId = ? AND instanceId = ?";
    private static final String QUERY_GET_FORUM_NAME = "SELECT forumName FROM sc_forums_forum WHERE forumId = ?";
    private static final String QUERY_IS_FORUM_ACTIVE = "SELECT forumActive FROM sc_forums_forum WHERE forumId = ?";
    private static final String QUERY_GET_FORUM_PARENT_ID = "SELECT forumParent FROM sc_forums_forum WHERE forumId = ?";
    private static final String QUERY_GET_FORUM_INSTANCE_ID = "SELECT instanceId FROM sc_forums_forum WHERE forumId = ?";
    private static final String QUERY_GET_FORUM_CREATOR_ID = "SELECT forumCreator FROM sc_forums_forum WHERE forumId = ?";
    private static final String QUERY_LOCK_FORUM = "UPDATE sc_forums_forum SET  forumLockLevel = ?, forumActive = ?, forumCloseDate = ?,instanceId = ? WHERE forumId = ?";
    private static final String QUERY_UNLOCK_FORUM_GET_LEVEL = "SELECT forumLockLevel FROM sc_forums_forum WHERE forumId = ?";
    private static final String QUERY_UNLOCK_FORUM_SET_ACTIVE = "UPDATE sc_forums_forum SET forumActive = ? WHERE forumId = ?";
    private static final String QUERY_CREATE_FORUM = "INSERT INTO sc_forums_forum (forumId, forumName, forumDescription, forumActive, forumParent, categoryId, instanceId, forumCreationDate, forumCreator) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String QUERY_UPDATE_FORUM = "UPDATE sc_forums_forum SET forumName = ?, forumDescription = ?, forumParent = ?, instanceId = ?, categoryId = ? WHERE forumId = ? ";
    private static final String QUERY_DELETE_FORUM_RIGHTS = "DELETE FROM SC_Forums_Rights WHERE forumId = ?";
    private static final String QUERY_DELETE_FORUM_MESSAGE = "DELETE FROM SC_Forums_Message WHERE forumId = ?";
    private static final String QUERY_DELETE_FORUM_FORUM = "DELETE FROM sc_forums_forum WHERE forumId = ?";
    private static final String QUERY_GET_ALL_FORUMS_BY_INSTANCE_ID = "SELECT forumId FROM sc_forums_forum WHERE instanceId = ?";
    private static final String QUERY_GET_FORUM_DETAIL = "SELECT forumId, forumName, forumDescription, forumActive, forumParent, categoryId, instanceId, forumCreationDate, forumCreator FROM sc_forums_forum WHERE forumId = ?";
    private static final String FORUM_RIGHTS_DELETION = "DELETE FROM SC_Forums_Rights where forumId in ";
    private static final String FORUM_HISTORY_DELETION = "DELETE FROM SC_Forums_HistoryUser where messageId in (select messageId from SC_Forums_Message as m JOIN sc_forums_forum as f on m.forumId = f.forumId and instanceId= ?)";
    private static final String FORUM_MESSAGES_DELETION = "DELETE FROM SC_Forums_Message where forumId in (select forumId from sc_forums_forum where instanceId= ?)";
    private static final String FORUMS_DELETION = "delete from sc_forums_forum where instanceId= ?";
    private static final String FROM = " FROM ";
    private static final String QUERY_GET_MESSAGES_LIST_BY_FORUM = "SELECT messageId, messageTitle, messageAuthor, forumId, messageParentId, messageDate , status FROM SC_Forums_Message WHERE forumId = ?";
    private static final String QUERY_GET_MESSAGES_IDS_BY_FORUM = "SELECT messageId FROM SC_Forums_Message WHERE forumId = ? ";
    private static final String QUERY_GET_MESSAGES_IDS_BY_FORUM_AND_MESSAGE = "SELECT messageId FROM SC_Forums_Message WHERE forumId = ? AND messageParentId = ?";
    private static final String QUERY_GET_NB_MESSAGES_SUBJECTS = "SELECT COUNT(messageId) FROM SC_Forums_Message WHERE forumId = ? AND messageParentId = 0 AND status = ? ";
    private static final String QUERY_GET_NB_MESSAGES_NOT_SUBJECTS = "SELECT COUNT(messageId) FROM SC_Forums_Message WHERE forumId = ? AND messageParentId != 0 AND status = ? ";
    private static final String QUERY_GET_AUTHOR_NB_MESSAGES = "SELECT COUNT(messageId) FROM SC_Forums_Message WHERE messageAuthor = ? AND status = ? ";
    private static final String QUERY_GET_NB_RESPONSES = "SELECT messageId FROM SC_Forums_Message WHERE forumId = ? AND messageParentId = ? AND status = ?";
    private static final String QUERY_GET_LAST_MESSAGE = "SELECT messageId FROM SC_Forums_Message WHERE forumId = ? AND messageParentId != 0 AND status = ?  ORDER BY messageDate DESC, messageId DESC";
    private static final String QUERY_GET_ALL_MESSAGES_BY_FORUM = "SELECT messageId FROM SC_Forums_Message WHERE forumId = ? ORDER BY messageDate DESC, messageId DESC";
    private static final String QUERY_GET_MESSAGE_INFOS = "SELECT messageId, messageTitle, messageAuthor, forumId, messageParentId, messageDate , status FROM SC_Forums_Message WHERE messageId = ?";
    private static final String QUERY_GET_MESSAGE = "SELECT messageId, messageTitle, messageAuthor, forumId, messageParentId, messageDate , status FROM SC_Forums_Message WHERE messageId = ?";
    private static final String QUERY_GET_MESSAGE_TITLE = "SELECT messageTitle FROM SC_Forums_Message WHERE messageId = ?";
    private static final String QUERY_GET_MESSAGE_PARENT_ID = "SELECT messageParentId FROM SC_Forums_Message WHERE messageId = ?";
    private static final String QUERY_GET_THREAD = "SELECT messageId, messageTitle, messageAuthor, forumId, messageParentId, messageDate , status FROM SC_Forums_Message WHERE messageId = ? AND messageParentId = ?";
    private static final String QUERY_CREATE_MESSAGE = "INSERT INTO SC_Forums_Message (messageId, messageTitle, messageAuthor, forumId, messageParentId, messageDate , status) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String QUERY_UPDATE_MESSAGE = "UPDATE SC_Forums_Message SET messageTitle = ? , status = ?  WHERE messageId = ?";
    private static final String QUERY_DELETE_MESSAGE_MESSAGE = "DELETE FROM SC_Forums_Message WHERE messageId = ?";
    private static final String QUERY_GET_MESSAGE_SONS = "SELECT messageId FROM SC_Forums_Message WHERE messageParentId = ?";
    private static final String QUERY_IS_MODERATOR = "SELECT forumId FROM SC_Forums_Rights WHERE userId = ?";
    private static final String QUERY_ADD_MODERATOR = "INSERT INTO SC_Forums_Rights (userId, forumId) VALUES (?, ?)";
    private static final String QUERY_REMOVE_MODERATOR = "DELETE FROM SC_Forums_Rights WHERE userId = ? AND forumId = ?";
    private static final String QUERY_REMOVE_ALL_MODERATORS = "DELETE FROM SC_Forums_Rights WHERE forumId = ?";
    private static final String QUERY_GET_MODERATORS = "SELECT userId, forumId FROM SC_Forums_Rights WHERE forumId = ?";
    private static final String QUERY_MOVE_MESSAGE = "UPDATE SC_Forums_Message SET forumId = ? WHERE messageId = ?";
    private static final String QUERY_GET_LAST_VISIT = "SELECT lastAccess FROM SC_Forums_HistoryUser WHERE userId = ? AND messageId = ? ORDER BY lastAccess DESC";
    private static final String QUERY_ADD_LAST_VISIT = "INSERT INTO SC_Forums_HistoryUser (userId, messageId, lastAccess) VALUES (?, ?, ?)";
    private static final String QUERY_DELETE_VISIT = "DELETE FROM SC_Forums_HistoryUser WHERE userId = ? AND messageId = ?";

    private ForumsDAO() {
    }

    public static Collection<ForumDetail> selectByForumPKs(Connection con, Collection<ForumPK> forumPKs) throws SQLException {
        ArrayList<ForumDetail> forumDetails = new ArrayList<ForumDetail>(forumPKs.size());
        for (ForumPK forumPK : forumPKs) {
            forumDetails.add(ForumsDAO.getForumDetail(con, forumPK));
        }
        return forumDetails;
    }

    public static Collection<Forum> getForumsByKeys(Connection con, Collection<ForumPK> forumPKs) throws SQLException {
        ArrayList<Forum> forums = new ArrayList<Forum>();
        for (ForumPK forumPK : forumPKs) {
            Forum forum = ForumsDAO.getForum(con, forumPK);
            if (forum == null) continue;
            forums.add(forum);
        }
        return forums;
    }

    public static Collection<Message> getMessagesByKeys(Connection con, Collection<MessagePK> messagePKs) throws SQLException {
        return ForumsDAO.getMessagesByKeys(con, messagePKs, false);
    }

    public static Collection<Message> getThreadsByKeys(Connection con, Collection<MessagePK> messagePKs) throws SQLException {
        return ForumsDAO.getMessagesByKeys(con, messagePKs, true);
    }

    private static Collection<Message> getMessagesByKeys(Connection con, Collection<MessagePK> messagePKs, boolean onlyThreads) throws SQLException {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (MessagePK messagePK : messagePKs) {
            Message message = onlyThreads ? ForumsDAO.getThread(con, messagePK) : ForumsDAO.getMessage(con, messagePK);
            if (message == null) continue;
            String instanceId = messagePK.getComponentName();
            if (StringUtil.isDefined((String)instanceId)) {
                String forumInstanceId = ForumsDAO.getForumInstanceId(con, message.getForumId());
                if (!instanceId.equals(forumInstanceId)) continue;
                message.setInstanceId(instanceId);
                messages.add(message);
                continue;
            }
            messages.add(message);
        }
        return messages;
    }

    public static List<Forum> getForumsList(Connection con, ForumPK forumPK) throws SQLException {
        ArrayList<Forum> forums = new ArrayList<Forum>();
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_FORUMS_LIST);){
            selectStmt.setString(1, forumPK.getComponentName());
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    forums.add(ForumsDAO.resultSet2Forum(rs));
                }
            }
        }
        return forums;
    }

    public static List<String> getForumsIds(Connection con, ForumPK forumPK) throws SQLException {
        ArrayList<String> forumsIds = new ArrayList<String>();
        try (PreparedStatement selectStmt = con.prepareStatement("SELECT forumId FROM sc_forums_forum WHERE instanceId = ?");){
            selectStmt.setString(1, forumPK.getComponentName());
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    forumsIds.add(String.valueOf(rs.getInt("forumId")));
                }
            }
        }
        return forumsIds;
    }

    public static List<Forum> getForumsListByCategory(Connection con, ForumPK forumPK, String categoryId) throws SQLException {
        String selectQuery = StringUtil.isDefined((String)categoryId) ? QUERY_GET_FORUMS_LIST_BY_CATEGORY_WITH_NOT_NULL_CATEGORY : QUERY_GET_FORUMS_LIST_BY_CATEGORY_WITH_NULL_CATEGORY;
        ArrayList<Forum> forums = new ArrayList<Forum>();
        try (PreparedStatement selectStmt = con.prepareStatement(selectQuery);){
            selectStmt.setString(1, forumPK.getComponentName());
            if (StringUtil.isDefined((String)categoryId)) {
                selectStmt.setString(2, categoryId);
            }
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    forums.add(ForumsDAO.resultSet2Forum(rs));
                }
            }
        }
        return forums;
    }

    public static List<String> getForumSonsIds(Connection con, ForumPK forumPK) throws SQLException {
        ArrayList<String> forumIds = new ArrayList<String>();
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_FORUM_SONS);){
            selectStmt.setInt(1, Integer.parseInt(forumPK.getId()));
            selectStmt.setString(2, forumPK.getComponentName());
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    forumIds.add(String.valueOf(rs.getInt("forumId")));
                }
            }
        }
        return forumIds;
    }

    public static Forum getForum(Connection con, ForumPK forumPK) throws SQLException {
        int forumId = Integer.parseInt(forumPK.getId());
        String instanceId = forumPK.getComponentName();
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_FORUM);){
            selectStmt.setInt(1, forumId);
            selectStmt.setString(2, instanceId);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    Forum forum = ForumsDAO.resultSet2Forum(rs);
                    forum.setPk(forumPK);
                    Forum forum2 = forum;
                    return forum2;
                }
            }
        }
        return null;
    }

    public static String getForumName(Connection con, int forumId) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_FORUM_NAME);){
            selectStmt.setInt(1, forumId);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString(FORUM_COLUMN_FORUM_NAME);
                    return string;
                }
            }
        }
        return null;
    }

    public static boolean isForumActive(Connection con, int forumId) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_IS_FORUM_ACTIVE);){
            selectStmt.setInt(1, forumId);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    boolean bl = rs.getInt(FORUM_COLUMN_FORUM_ACTIVE) == 1;
                    return bl;
                }
            }
        }
        return false;
    }

    public static int getForumParentId(Connection con, int forumId) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_FORUM_PARENT_ID);){
            selectStmt.setInt(1, forumId);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(FORUM_COLUMN_FORUM_PARENT);
                    return n;
                }
            }
        }
        return -1;
    }

    public static String getForumInstanceId(Connection con, int forumId) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_FORUM_INSTANCE_ID);){
            selectStmt.setInt(1, forumId);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString(FORUM_COLUMN_INSTANCE_ID);
                    return string;
                }
            }
        }
        return null;
    }

    public static String getForumCreatorId(Connection con, int forumId) throws SQLException {
        try (PreparedStatement stmt = con.prepareStatement(QUERY_GET_FORUM_CREATOR_ID);){
            stmt.setInt(1, forumId);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString(FORUM_COLUMN_FORUM_CREATOR);
                    return string;
                }
                throw new ForumsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"forum", (Object)forumId));
            }
        }
    }

    public static void lockForum(Connection con, ForumPK forumPK, int level) throws SQLException {
        try (PreparedStatement updateStmt = con.prepareStatement(QUERY_LOCK_FORUM);){
            updateStmt.setInt(1, level);
            updateStmt.setInt(2, 0);
            updateStmt.setString(3, DateUtil.date2SQLDate((Date)new Date()));
            updateStmt.setString(4, forumPK.getComponentName());
            updateStmt.setInt(5, Integer.parseInt(forumPK.getId()));
            updateStmt.executeUpdate();
        }
    }

    public static int unlockForum(Connection con, ForumPK forumPK, int level) throws SQLException {
        int result;
        block20: {
            result = 0;
            int forumLocklevel = 0;
            try (PreparedStatement declareStmt = con.prepareStatement(QUERY_UNLOCK_FORUM_GET_LEVEL);){
                declareStmt.setInt(1, Integer.parseInt(forumPK.getId()));
                try (ResultSet rs = declareStmt.executeQuery();){
                    if (rs.next()) {
                        forumLocklevel = rs.getInt(FORUM_COLUMN_FORUM_LOCK_LEVEL);
                    }
                    if (forumLocklevel >= level) {
                        try (PreparedStatement declareStmt1 = con.prepareStatement(QUERY_UNLOCK_FORUM_SET_ACTIVE);){
                            declareStmt1.setInt(1, 1);
                            declareStmt1.setInt(2, Integer.parseInt(forumPK.getId()));
                            declareStmt1.executeUpdate();
                            result = 1;
                            break block20;
                        }
                    }
                    result = 0;
                }
            }
        }
        return result;
    }

    public static int createForum(Connection con, ForumPK forumPK, String forumName, String forumDescription, String forumCreator, int forumParent, String categoryId) throws SQLException {
        try (PreparedStatement insertStmt = con.prepareStatement(QUERY_CREATE_FORUM);){
            int forumId = DBUtil.getNextId((String)"sc_forums_forum", (String)"forumId");
            insertStmt.setInt(1, forumId);
            insertStmt.setString(2, forumName);
            insertStmt.setString(3, forumDescription);
            insertStmt.setInt(4, 1);
            insertStmt.setInt(5, forumParent);
            if (StringUtil.isDefined((String)categoryId)) {
                insertStmt.setString(6, categoryId);
            } else {
                insertStmt.setNull(6, 12);
            }
            insertStmt.setString(7, forumPK.getComponentName());
            insertStmt.setString(8, DateUtil.date2SQLDate((Date)new Date()));
            insertStmt.setString(9, forumCreator);
            insertStmt.executeUpdate();
            int n = forumId;
            return n;
        }
    }

    public static void updateForum(Connection con, ForumPK forumPK, String forumName, String forumDescription, int forumParent, String categoryId) throws SQLException {
        try (PreparedStatement updateStmt = con.prepareStatement(QUERY_UPDATE_FORUM);){
            updateStmt.setString(1, forumName);
            updateStmt.setString(2, forumDescription);
            updateStmt.setInt(3, forumParent);
            updateStmt.setString(4, forumPK.getComponentName());
            if (StringUtil.isDefined((String)categoryId)) {
                updateStmt.setString(5, categoryId);
            } else {
                updateStmt.setNull(5, 12);
            }
            updateStmt.setInt(6, Integer.parseInt(forumPK.getId()));
            updateStmt.executeUpdate();
        }
    }

    public static void deleteForum(Connection con, ForumPK forumPK) throws SQLException {
        String sForumId = forumPK.getId();
        int forumId = Integer.parseInt(sForumId);
        try (PreparedStatement deleteStmt1 = con.prepareStatement("DELETE FROM SC_Forums_Rights WHERE forumId = ?");){
            deleteStmt1.setString(1, sForumId);
            deleteStmt1.executeUpdate();
            try (PreparedStatement deleteStmt2 = con.prepareStatement(QUERY_DELETE_FORUM_MESSAGE);){
                deleteStmt2.setInt(1, forumId);
                deleteStmt2.executeUpdate();
                try (PreparedStatement deleteStmt3 = con.prepareStatement(QUERY_DELETE_FORUM_FORUM);){
                    deleteStmt3.setInt(1, forumId);
                    deleteStmt3.executeUpdate();
                }
            }
        }
    }

    public static void deleteAllForums(Connection con, String instanceId) throws SQLException {
        Collection<Integer> forumIds = ForumsDAO.getAllForumsByInstanceId(con, instanceId);
        if (!forumIds.isEmpty()) {
            String listOfIds = forumIds.stream().map(i -> "'" + i + "'").collect(Collectors.joining(",", "(", ")"));
            try (PreparedStatement statement = con.prepareStatement(FORUM_RIGHTS_DELETION + listOfIds);){
                statement.execute();
            }
        }
        try (PreparedStatement statement = con.prepareStatement(FORUM_HISTORY_DELETION);){
            statement.setString(1, instanceId);
            statement.execute();
        }
        statement = con.prepareStatement(FORUM_MESSAGES_DELETION);
        try {
            statement.setString(1, instanceId);
            statement.execute();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        statement = con.prepareStatement(FORUMS_DELETION);
        try {
            statement.setString(1, instanceId);
            statement.execute();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static List<Message> getMessagesList(Connection con, ForumPK forumPK) throws SQLException {
        ArrayList<Message> messages = new ArrayList<Message>();
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_MESSAGES_LIST_BY_FORUM);){
            selectStmt.setInt(1, Integer.parseInt(forumPK.getId()));
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    messages.add(ForumsDAO.resultSet2Message(rs, forumPK.getInstanceId()));
                }
            }
        }
        return messages;
    }

    public static List<String> getMessagesIds(Connection con, ForumPK forumPK, int messageParentId) throws SQLException {
        String query = messageParentId != -1 ? QUERY_GET_MESSAGES_IDS_BY_FORUM_AND_MESSAGE : QUERY_GET_MESSAGES_IDS_BY_FORUM;
        ArrayList<String> messagesIds = new ArrayList<String>();
        try (PreparedStatement selectStmt = con.prepareStatement(query);){
            selectStmt.setInt(1, Integer.parseInt(forumPK.getId()));
            if (messageParentId != -1) {
                selectStmt.setInt(2, messageParentId);
            }
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    messagesIds.add(String.valueOf(rs.getInt("messageId")));
                }
            }
        }
        return messagesIds;
    }

    public static List<String> getMessagesIds(Connection con, ForumPK forumPK) throws SQLException {
        return ForumsDAO.getMessagesIds(con, forumPK, -1);
    }

    public static List<String> getSubjectsIds(Connection con, ForumPK forumPK) throws SQLException {
        return ForumsDAO.getMessagesIds(con, forumPK, 0);
    }

    public static int getNbMessages(Connection con, int forumId, String type, String status) throws SQLException {
        String selectQuery = "Subjects".equals(type) ? QUERY_GET_NB_MESSAGES_SUBJECTS : QUERY_GET_NB_MESSAGES_NOT_SUBJECTS;
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery);){
            prepStmt.setInt(1, forumId);
            prepStmt.setString(2, status);
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
            }
        }
        return 0;
    }

    public static int getAuthorNbMessages(Connection con, String userId, String status) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(QUERY_GET_AUTHOR_NB_MESSAGES);){
            prepStmt.setString(1, userId);
            prepStmt.setString(2, status);
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
            }
        }
        return 0;
    }

    public static int getNbResponses(Connection con, int forumId, int messageId, String status) {
        ArrayList<Integer> nextMessageIds = new ArrayList<Integer>();
        try (PreparedStatement prepStmt = con.prepareStatement(QUERY_GET_NB_RESPONSES);){
            prepStmt.setInt(1, forumId);
            prepStmt.setInt(2, messageId);
            prepStmt.setString(3, status);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    nextMessageIds.add(rs.getInt("messageId"));
                }
            }
        }
        catch (SQLException sqle) {
            SilverLogger.getLogger(ForumsDAO.class).error(sqle.getMessage(), (Throwable)sqle);
            return 0;
        }
        int nb = nextMessageIds.size();
        int n = nextMessageIds.size();
        for (int i = 0; i < n; ++i) {
            int nextMessageId = (Integer)nextMessageIds.get(i);
            nb += ForumsDAO.getNbResponses(con, forumId, nextMessageId, status);
        }
        return nb;
    }

    public static Message getLastMessage(Connection con, ForumPK forumPK, String status) throws SQLException {
        int messageId = -1;
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_LAST_MESSAGE);){
            selectStmt.setInt(1, Integer.parseInt(forumPK.getId()));
            selectStmt.setString(2, status);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    messageId = rs.getInt(1);
                }
            }
        }
        if (messageId != -1) {
            MessagePK messagePK = new MessagePK(forumPK.getComponentName(), String.valueOf(messageId));
            return ForumsDAO.getMessage(con, messagePK);
        }
        return null;
    }

    public static List<Message> getLastThreads(Connection con, ForumPK[] forumPKs, int count) throws SQLException {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (forumPKs.length > 0) {
            int messagesCount;
            StringBuilder selectQuery = new StringBuilder("SELECT messageId FROM SC_Forums_Message WHERE messageParentId = ? AND forumId IN(");
            int n = forumPKs.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    selectQuery.append(", ");
                }
                selectQuery.append(forumPKs[i].getId());
            }
            selectQuery.append(")").append(ORDER_BY).append(MESSAGE_COLUMN_MESSAGE_DATE).append(DESC);
            ArrayList<String> messageIds = new ArrayList<String>(count);
            try (PreparedStatement selectStmt = con.prepareStatement(selectQuery.toString());){
                selectStmt.setInt(1, 0);
                try (ResultSet rs = selectStmt.executeQuery();){
                    for (messagesCount = 0; rs.next() && messagesCount < count; ++messagesCount) {
                        messageIds.add(String.valueOf(rs.getInt("messageId")));
                    }
                }
            }
            String componentName = forumPKs[0].getComponentName();
            for (int i = 0; i < messagesCount; ++i) {
                MessagePK messagePK = new MessagePK(componentName, (String)messageIds.get(i));
                messages.add(ForumsDAO.getMessage(con, messagePK));
            }
        }
        return messages;
    }

    public static Collection<Message> getNotAnsweredLastThreads(Connection con, ForumPK[] forumPKs, int count) throws SQLException {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (forumPKs.length > 0) {
            int messagesCount;
            StringBuilder selectQuery = new StringBuilder("SELECT messageId, forumId FROM SC_Forums_Message WHERE messageParentId = ? AND forumId IN(");
            int n = forumPKs.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    selectQuery.append(", ");
                }
                selectQuery.append(forumPKs[i].getId());
            }
            selectQuery.append(") ORDER BY messageDate DESC");
            ArrayList<String> messageIds = new ArrayList<String>(count);
            try (PreparedStatement selectStmt = con.prepareStatement(selectQuery.toString());){
                selectStmt.setInt(1, 0);
                try (ResultSet rs = selectStmt.executeQuery();){
                    int forumId;
                    int messageId;
                    for (messagesCount = 0; rs.next() && messagesCount < count; messagesCount += ForumsDAO.fillMessageIds(con, messageIds, messageId, forumId)) {
                        messageId = rs.getInt("messageId");
                        forumId = rs.getInt("forumId");
                    }
                }
            }
            String componentName = forumPKs[0].getComponentName();
            for (int i = 0; i < messagesCount; ++i) {
                MessagePK messagePK = new MessagePK(componentName, messageIds.get(i));
                messages.add(ForumsDAO.getMessage(con, messagePK));
            }
        }
        return messages;
    }

    private static int fillMessageIds(Connection con, ArrayList<String> messageIds, int messageId, int forumId) throws SQLException {
        String query = "SELECT COUNT(messageId) FROM SC_Forums_Message WHERE forumId = ? AND messageParentId = ?";
        int messagesCount = 0;
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setInt(1, forumId);
            prepStmt.setInt(2, messageId);
            try (ResultSet rs2 = prepStmt.executeQuery();){
                int sonsCount;
                if (rs2.next() && (sonsCount = rs2.getInt(1)) == 0) {
                    messageIds.add(String.valueOf(messageId));
                    ++messagesCount;
                }
            }
        }
        return messagesCount;
    }

    public static Collection<String> getLastMessageRSS(Connection con, String instanceId) throws SQLException {
        ArrayList<String> messageIds = new ArrayList<String>();
        Collection<Integer> forumIds = ForumsDAO.getAllForumsByInstanceId(con, instanceId);
        for (int forumId : forumIds) {
            messageIds.addAll(ForumsDAO.getAllMessageByForum(con, forumId));
        }
        return messageIds;
    }

    private static Collection<Integer> getAllForumsByInstanceId(Connection con, String instanceId) throws SQLException {
        ArrayList<Integer> forumIds = new ArrayList<Integer>();
        try (PreparedStatement selectStmt = con.prepareStatement("SELECT forumId FROM sc_forums_forum WHERE instanceId = ?");){
            selectStmt.setString(1, instanceId);
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    forumIds.add(rs.getInt(1));
                }
            }
        }
        return forumIds;
    }

    private static Collection<String> getAllMessageByForum(Connection con, int forumId) throws SQLException {
        ArrayList<String> messageIds = new ArrayList<String>();
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_ALL_MESSAGES_BY_FORUM);){
            selectStmt.setInt(1, forumId);
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    messageIds.add(String.valueOf(rs.getInt(1)));
                }
            }
        }
        return messageIds;
    }

    public static Message getLastMessage(Connection con, ForumPK forumPK, List<String> messageParentIds, String status) throws SQLException {
        int messageParentIdsCount;
        StringBuilder selectQuery = new StringBuilder("SELECT messageId FROM SC_Forums_Message");
        int n = messageParentIdsCount = messageParentIds != null ? messageParentIds.size() : 0;
        if (messageParentIdsCount > 0) {
            selectQuery.append(WHERE).append(MESSAGE_COLUMN_STATUS).append(" = ? AND ");
            selectQuery.append(" (");
            for (int i = 0; i < messageParentIdsCount; ++i) {
                if (i > 0) {
                    selectQuery.append(" OR ");
                }
                selectQuery.append(MESSAGE_COLUMN_MESSAGE_PARENT_ID).append(" = ?").append(" OR ").append("messageId").append(" = ?");
            }
            selectQuery.append(")");
        }
        selectQuery.append(ORDER_BY).append(MESSAGE_COLUMN_MESSAGE_DATE).append(" DESC, ").append("messageId").append(DESC);
        String messageId = "";
        try (PreparedStatement selectStmt = con.prepareStatement(selectQuery.toString());){
            selectStmt.setString(1, status);
            if (messageParentIdsCount > 0) {
                int index = 2;
                for (int i = 0; i < messageParentIdsCount; ++i) {
                    int messageParentId = Integer.parseInt(messageParentIds.get(i));
                    selectStmt.setInt(index++, messageParentId);
                    selectStmt.setInt(index++, messageParentId);
                }
            }
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    messageId = String.valueOf(rs.getInt(1));
                }
            }
        }
        Message message = null;
        if (!"".equals(messageId)) {
            MessagePK messagePK = new MessagePK(forumPK.getComponentName(), messageId);
            message = ForumsDAO.getMessage(con, messagePK);
        }
        return message;
    }

    public static List getMessageInfos(Connection con, MessagePK messagePK) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement("SELECT messageId, messageTitle, messageAuthor, forumId, messageParentId, messageDate , status FROM SC_Forums_Message WHERE messageId = ?");){
            selectStmt.setInt(1, Integer.parseInt(messagePK.getId()));
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    List list = ForumsDAO.resultSet2VectorMessage(rs);
                    return list;
                }
            }
        }
        return new ArrayList();
    }

    public static Message getMessage(Connection con, MessagePK messagePK) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement("SELECT messageId, messageTitle, messageAuthor, forumId, messageParentId, messageDate , status FROM SC_Forums_Message WHERE messageId = ?");){
            selectStmt.setInt(1, Integer.parseInt(messagePK.getId()));
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    Message message = ForumsDAO.resultSet2Message(rs, messagePK.getInstanceId());
                    message.setInstanceId(messagePK.getComponentName());
                    message.setPk(messagePK);
                    Message message2 = message;
                    return message2;
                }
            }
        }
        return null;
    }

    public static String getMessageTitle(Connection con, int messageId) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_MESSAGE_TITLE);){
            selectStmt.setInt(1, messageId);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString(MESSAGE_COLUMN_MESSAGE_TITLE);
                    return string;
                }
            }
        }
        return "";
    }

    public static int getMessageParentId(Connection con, int messageId) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_MESSAGE_PARENT_ID);){
            selectStmt.setInt(1, messageId);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(MESSAGE_COLUMN_MESSAGE_PARENT_ID);
                    return n;
                }
            }
        }
        return -1;
    }

    public static Message getThread(Connection con, MessagePK messagePK) throws SQLException {
        int messageId = Integer.parseInt(messagePK.getId());
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_THREAD);){
            selectStmt.setInt(1, messageId);
            selectStmt.setInt(2, 0);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    Message message = ForumsDAO.resultSet2Message(rs, messagePK.getInstanceId());
                    message.setPk(messagePK);
                    Message message2 = message;
                    return message2;
                }
            }
        }
        return null;
    }

    public static int createMessage(Connection con, String messageTitle, String messageAuthor, Date messageDate, int forumId, int messageParent, String status) throws SQLException {
        Date finalMessageDate = messageDate;
        if (finalMessageDate == null) {
            finalMessageDate = new Date();
        }
        try (PreparedStatement insertStmt = con.prepareStatement(QUERY_CREATE_MESSAGE);){
            int messageId = DBUtil.getNextId((String)MESSAGE_TABLE, (String)"messageId");
            insertStmt.setInt(1, messageId);
            insertStmt.setString(2, messageTitle);
            insertStmt.setString(3, messageAuthor);
            insertStmt.setInt(4, forumId);
            insertStmt.setInt(5, messageParent);
            insertStmt.setTimestamp(6, new Timestamp(finalMessageDate.getTime()));
            insertStmt.setString(7, status);
            insertStmt.executeUpdate();
            ForumsDAO.addLastVisit(con, messageAuthor, messageId);
            int n = messageId;
            return n;
        }
    }

    public static void updateMessage(Connection con, MessagePK messagePK, String title, String status) throws SQLException {
        try (PreparedStatement updateStmt = con.prepareStatement(QUERY_UPDATE_MESSAGE);){
            updateStmt.setString(1, title);
            updateStmt.setString(2, status);
            updateStmt.setInt(3, Integer.parseInt(messagePK.getId()));
            updateStmt.executeUpdate();
        }
    }

    public static void deleteMessage(Connection con, MessagePK messagePK) throws SQLException {
        try (PreparedStatement deleteStmt = con.prepareStatement(QUERY_DELETE_MESSAGE_MESSAGE);){
            deleteStmt.setInt(1, Integer.parseInt(messagePK.getId()));
            deleteStmt.executeUpdate();
        }
    }

    public static Collection<String> getMessageSons(Connection con, MessagePK messagePK) throws SQLException {
        ArrayList<String> messagesIds = new ArrayList<String>();
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_MESSAGE_SONS);){
            selectStmt.setInt(1, Integer.parseInt(messagePK.getId()));
            try (ResultSet rs = selectStmt.executeQuery();){
                while (rs.next()) {
                    messagesIds.add(String.valueOf(rs.getInt("messageId")));
                }
            }
        }
        return messagesIds;
    }

    public static boolean isModerator(Connection con, ForumPK forumPK, String userId) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(QUERY_IS_MODERATOR);){
            prepStmt.setString(1, userId);
            try (ResultSet rs = prepStmt.executeQuery();){
                String forumId = forumPK.getId();
                while (rs.next()) {
                    if (!rs.getString("forumId").trim().equals(forumId)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public static void addModerator(Connection con, ForumPK forumPK, String userId) throws SQLException {
        try (PreparedStatement insertStmt = con.prepareStatement(QUERY_ADD_MODERATOR);){
            insertStmt.setString(1, userId);
            insertStmt.setString(2, forumPK.getId());
            insertStmt.executeUpdate();
        }
    }

    public static void removeModerator(Connection con, ForumPK forumPK, String userId) throws SQLException {
        try (PreparedStatement deleteStmt = con.prepareStatement(QUERY_REMOVE_MODERATOR);){
            deleteStmt.setString(1, userId);
            deleteStmt.setString(2, forumPK.getId());
            deleteStmt.executeUpdate();
        }
    }

    public static void removeAllModerators(Connection con, ForumPK forumPK) throws SQLException {
        try (PreparedStatement deleteStmt = con.prepareStatement("DELETE FROM SC_Forums_Rights WHERE forumId = ?");){
            deleteStmt.setString(1, forumPK.getId());
            deleteStmt.executeUpdate();
        }
    }

    public static List<Moderator> getModerators(Connection con, int forumId) throws SQLException {
        ArrayList<Moderator> moderators = new ArrayList<Moderator>();
        try (PreparedStatement stmt = con.prepareStatement(QUERY_GET_MODERATORS);){
            stmt.setString(1, Integer.toString(forumId));
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    moderators.add(Moderator.from(rs.getString("userId"), Integer.valueOf(rs.getString("forumId"))));
                }
            }
        }
        return moderators;
    }

    public static void moveMessage(Connection con, MessagePK messagePK, ForumPK forumPK) throws SQLException {
        try (PreparedStatement updateStmt = con.prepareStatement(QUERY_MOVE_MESSAGE);){
            updateStmt.setInt(1, Integer.parseInt(forumPK.getId()));
            updateStmt.setInt(2, Integer.parseInt(messagePK.getId()));
            updateStmt.executeUpdate();
        }
    }

    public static Collection<String> getAllMessageSons(Connection con, MessagePK messagePK) throws SQLException {
        ArrayList<String> messagesIds = new ArrayList<String>();
        Collection<String> currentMessagesIds = ForumsDAO.getMessageSons(con, messagePK);
        for (String messageId : currentMessagesIds) {
            messagesIds.add(messageId);
            messagesIds.addAll(ForumsDAO.getAllMessageSons(con, new MessagePK(messagePK.getInstanceId(), messageId)));
        }
        return messagesIds;
    }

    public static ForumDetail getForumDetail(Connection con, ForumPK forumPK) throws SQLException {
        try (PreparedStatement stmt = con.prepareStatement(QUERY_GET_FORUM_DETAIL);){
            stmt.setInt(1, Integer.parseInt(forumPK.getId()));
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    ForumDetail forumDetail = ForumsDAO.resultSet2ForumDetail(rs, forumPK);
                    return forumDetail;
                }
                throw new ForumsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"forum", (Object)forumPK.getId()));
            }
        }
    }

    public static Date getLastVisit(Connection con, String userId, int messageId) throws SQLException {
        try (PreparedStatement selectStmt = con.prepareStatement(QUERY_GET_LAST_VISIT);){
            selectStmt.setString(1, userId);
            selectStmt.setInt(2, messageId);
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    Date date = new Date(Long.parseLong(rs.getString(HISTORY_COLUMN_LAST_ACCESS)));
                    return date;
                }
            }
        }
        return null;
    }

    public static Date getLastVisit(Connection con, String userId, List<String> messageIds) throws SQLException {
        int messageIdsCount;
        StringBuilder selectQuery = new StringBuilder("SELECT lastAccess FROM SC_Forums_HistoryUser WHERE userId = ?");
        int n = messageIdsCount = messageIds != null ? messageIds.size() : 0;
        if (messageIdsCount > 0) {
            selectQuery.append(" AND (");
            for (int i = 0; i < messageIdsCount; ++i) {
                if (i > 0) {
                    selectQuery.append(" OR ");
                }
                selectQuery.append("messageId").append(" = ?");
            }
            selectQuery.append(") ORDER BY ").append(HISTORY_COLUMN_LAST_ACCESS).append(DESC);
        }
        Date lastVisit = null;
        try (PreparedStatement selectStmt = con.prepareStatement(selectQuery.toString());){
            int index = 1;
            selectStmt.setString(index++, userId);
            for (int i = 0; i < messageIdsCount; ++i) {
                int messageId = Integer.parseInt(messageIds.get(i));
                selectStmt.setInt(index++, messageId);
            }
            try (ResultSet rs = selectStmt.executeQuery();){
                if (rs.next()) {
                    lastVisit = new Date(Long.parseLong(rs.getString(1)));
                }
            }
        }
        return lastVisit;
    }

    public static void addLastVisit(Connection con, String userId, int messageId) throws SQLException {
        ForumsDAO.deleteVisit(con, userId, messageId);
        Date date = new Date();
        try (PreparedStatement insertStmt = con.prepareStatement(QUERY_ADD_LAST_VISIT);){
            insertStmt.setString(1, userId);
            insertStmt.setInt(2, messageId);
            insertStmt.setString(3, Long.toString(date.getTime()));
            insertStmt.executeUpdate();
        }
    }

    public static void deleteVisit(Connection con, String userId, int messageId) throws SQLException {
        try (PreparedStatement deleteStmt = con.prepareStatement(QUERY_DELETE_VISIT);){
            deleteStmt.setString(1, userId);
            deleteStmt.setInt(2, messageId);
            deleteStmt.executeUpdate();
        }
    }

    private static ForumDetail resultSet2ForumDetail(ResultSet rs, ForumPK forumPK) throws SQLException {
        Date creationDate;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        try {
            creationDate = formatter.parse(rs.getString(FORUM_COLUMN_FORUM_CREATION_DATE));
        }
        catch (ParseException e) {
            throw new SQLException("ForumsDAO : resultSet2ForumDetail() : internal error : creationDate format unknown for forumPK = " + String.valueOf((Object)forumPK) + " : " + e.toString(), e);
        }
        String name = rs.getString(FORUM_COLUMN_FORUM_NAME);
        String description = rs.getString(FORUM_COLUMN_FORUM_DESCRIPTION);
        String creatorId = rs.getString(FORUM_COLUMN_FORUM_CREATOR);
        forumPK.setComponentName(rs.getString(FORUM_COLUMN_INSTANCE_ID));
        return new ForumDetail(forumPK, name, description, creatorId, creationDate);
    }

    private static Forum resultSet2Forum(ResultSet rs) throws SQLException {
        String category = rs.getString(FORUM_COLUMN_CATEGORY_ID);
        category = category != null ? category.trim() : null;
        try {
            Date date = DateUtil.parseDate((String)rs.getString(FORUM_COLUMN_FORUM_CREATION_DATE));
            Forum forum = new Forum(rs.getInt("forumId"), rs.getString(FORUM_COLUMN_INSTANCE_ID), rs.getString(FORUM_COLUMN_FORUM_NAME).trim(), rs.getString(FORUM_COLUMN_FORUM_DESCRIPTION), rs.getInt(FORUM_COLUMN_FORUM_ACTIVE) == 1, rs.getInt(FORUM_COLUMN_FORUM_PARENT), category);
            forum.setCreationDate(date);
            return forum;
        }
        catch (ParseException e) {
            throw new SQLException(e);
        }
    }

    private static List resultSet2VectorMessage(ResultSet rs) throws SQLException {
        ArrayList<Object> message = new ArrayList<Object>();
        Timestamp timestamp = rs.getTimestamp(MESSAGE_COLUMN_MESSAGE_DATE);
        Date date = timestamp != null ? new Date(timestamp.getTime()) : null;
        message.add(String.valueOf(rs.getInt("messageId")));
        message.add(rs.getString(MESSAGE_COLUMN_MESSAGE_TITLE).trim());
        message.add(rs.getString(MESSAGE_COLUMN_MESSAGE_AUTHOR));
        message.add(date);
        message.add(String.valueOf(rs.getInt("forumId")));
        message.add(String.valueOf(rs.getInt(MESSAGE_COLUMN_MESSAGE_PARENT_ID)));
        return message;
    }

    private static Message resultSet2Message(ResultSet rs, String instanceId) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(MESSAGE_COLUMN_MESSAGE_DATE);
        Date date = timestamp != null ? new Date(timestamp.getTime()) : null;
        Message message = new Message(rs.getInt("messageId"), instanceId, rs.getString(MESSAGE_COLUMN_MESSAGE_TITLE).trim(), rs.getString(MESSAGE_COLUMN_MESSAGE_AUTHOR), date, rs.getInt("forumId"), rs.getInt(MESSAGE_COLUMN_MESSAGE_PARENT_ID));
        message.setStatus(rs.getString(MESSAGE_COLUMN_STATUS));
        return message;
    }
}

