/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.silverpeas.components.forums.model.MessagePK;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.WithAttachment;
import org.silverpeas.core.contribution.rating.model.ContributionRating;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.model.Rateable;
import org.silverpeas.core.contribution.rating.service.RatingService;

public class Message
implements Contribution,
Rateable,
Serializable,
WithAttachment {
    private static final String TYPE = "forum_message";
    public static final String STATUS_VALIDATE = "V";
    public static final String STATUS_FOR_VALIDATION = "A";
    public static final String STATUS_REFUSED = "R";
    public static final String RESOURCE_TYPE = "ForumMessage";
    private static final long serialVersionUID = 705520417746270396L;
    private int id;
    private String title;
    private String author;
    private Date date;
    private int forumId;
    private int parentId;
    private String text;
    private String instanceId;
    private MessagePK pk;
    private String status;
    private ContributionRating contributionRating;

    public Message(int id, String instanceId, String title, String author, Date date, int forumId, int parentId) {
        this.id = id;
        this.title = title;
        this.author = author;
        this.date = date;
        this.forumId = forumId;
        this.parentId = parentId;
        this.instanceId = instanceId;
    }

    public int getId() {
        return this.id;
    }

    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    public void setId(int id) {
        this.id = id;
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((String)this.getInstanceId(), (String)this.getIdAsString(), (String)this.getContributionType());
    }

    public User getCreator() {
        return User.getById((String)this.getAuthor());
    }

    public Date getCreationDate() {
        return this.getDate();
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public Date getLastUpdateDate() {
        return this.getDate();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean canBeAccessedBy(User user) {
        return false;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getForumId() {
        return this.forumId;
    }

    public String getForumIdAsString() {
        return String.valueOf(this.forumId);
    }

    public void setForumId(int forumId) {
        this.forumId = forumId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getParentIdAsString() {
        return String.valueOf(this.parentId);
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public MessagePK getPk() {
        return this.pk;
    }

    public void setPk(MessagePK pk) {
        this.pk = pk;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isSubject() {
        return this.parentId == 0;
    }

    public boolean isValid() {
        return STATUS_VALIDATE.equals(this.status);
    }

    public boolean isToBeValidated() {
        return STATUS_FOR_VALIDATION.equals(this.status);
    }

    public boolean isRefused() {
        return STATUS_REFUSED.equals(this.status);
    }

    public static String getResourceType() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (this.forumId != message.forumId) {
            return false;
        }
        if (this.id != message.id) {
            return false;
        }
        if (this.parentId != message.parentId) {
            return false;
        }
        if (!Objects.equals(this.author, message.author)) {
            return false;
        }
        if (!Objects.equals(this.date, message.date)) {
            return false;
        }
        if (!Objects.equals(this.instanceId, message.instanceId)) {
            return false;
        }
        if (!Objects.equals((Object)this.pk, (Object)message.pk)) {
            return false;
        }
        if (!Objects.equals(this.status, message.status)) {
            return false;
        }
        if (!Objects.equals(this.text, message.text)) {
            return false;
        }
        return Objects.equals(this.title, message.title);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + this.forumId;
        result = 31 * result + this.parentId;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.pk != null ? this.pk.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Message{id=" + this.id + ", title=" + this.title + ", author=" + this.author + ", date=" + String.valueOf(this.date) + ", forumId=" + this.forumId + ", parentId=" + this.parentId + ", text=" + this.text + ", instanceId=" + this.instanceId + ", pk=" + String.valueOf((Object)this.pk) + ", status=" + this.status + "}";
    }

    public ContributionRating getRating() {
        if (this.contributionRating == null) {
            this.contributionRating = RatingService.get().getRating(new ContributionRatingPK(String.valueOf(this.getId()), this.getInstanceId(), RESOURCE_TYPE));
        }
        return this.contributionRating;
    }
}

