/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.attribute;

import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeReferenceListWrapper {
    private static final Logger log = LoggerFactory.getLogger(AttributeReferenceListWrapper.class);
    private Set<AttributeReference> attributeReferences = new HashSet<AttributeReference>();

    public AttributeReferenceListWrapper(String attributeReferencesString) {
        String[] split;
        for (String af : split = StringUtils.split((String)attributeReferencesString, (String)",")) {
            log.debug("--> Attribute -> " + af);
            AttributeReference attributeReference = new AttributeReference(af.trim());
            this.attributeReferences.add(attributeReference);
        }
    }

    public static AttributeReferenceListWrapper of(Set<AttributeReference> attributeReferences) {
        AttributeReferenceListWrapper wrapper = new AttributeReferenceListWrapper("");
        wrapper.attributeReferences = attributeReferences;
        return wrapper;
    }

    public String toString() {
        if (this.attributeReferences == null || this.attributeReferences.isEmpty()) {
            return "";
        }
        return this.attributeReferences.stream().map(AttributeReference::toString).collect(Collectors.joining(","));
    }

    public Set<AttributeReference> getAttributeReferences() {
        return this.attributeReferences;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeReferenceListWrapper)) {
            return false;
        }
        AttributeReferenceListWrapper other = (AttributeReferenceListWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<AttributeReference> this$attributeReferences = this.getAttributeReferences();
        Set<AttributeReference> other$attributeReferences = other.getAttributeReferences();
        return !(this$attributeReferences == null ? other$attributeReferences != null : !((Object)this$attributeReferences).equals(other$attributeReferences));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeReferenceListWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<AttributeReference> $attributeReferences = this.getAttributeReferences();
        result = result * 59 + ($attributeReferences == null ? 43 : ((Object)$attributeReferences).hashCode());
        return result;
    }
}

