/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.search;

import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.index.indexing.model.FieldDescription;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.index.search.model.SearchResult;
import org.silverpeas.core.search.SearchService;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.search.ResultEntity;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="search")
@Authenticated
public class SearchResource
extends RESTWebService {
    static final String PATH = "search";

    @GET
    @Produces(value={"application/json"})
    public List<ResultEntity> search(@QueryParam(value="query") String query, @QueryParam(value="taxonomyPosition") String position, @QueryParam(value="spaceId") String spaceId, @QueryParam(value="appId") List<String> appIds, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate, @QueryParam(value="form") String form) {
        QueryDescription queryDescription = new QueryDescription(query);
        queryDescription.setSearchingUser(this.getUser().getId());
        queryDescription.setTaxonomyPosition(position);
        queryDescription.setRequestedLanguage("*");
        this.setCreationDateInterval(queryDescription, startDate, endDate);
        this.setComponents(queryDescription, spaceId, appIds);
        if (StringUtil.isDefined((String)form)) {
            ArrayList<String> paramNames = Collections.list(this.getHttpRequest().getParameterNames());
            this.setQueryFormFields(queryDescription, form, paramNames);
        }
        SearchService searchService = SearchService.get();
        ArrayList<ResultEntity> entities = new ArrayList<ResultEntity>();
        try {
            List results = searchService.search(queryDescription);
            for (SearchResult result : results) {
                entities.add(ResultEntity.fromSearchResult(result));
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error("Error during search...", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return entities;
    }

    private void setComponents(QueryDescription queryDescription, String spaceId, List<String> appIds) {
        String userId = this.getUser().getId();
        Consumer<String> addComponent = arg_0 -> ((QueryDescription)queryDescription).addComponent(arg_0);
        if (!StringUtil.isDefined((String)spaceId) && appIds.isEmpty()) {
            Arrays.stream(this.getOrganisationController().getAvailCompoIds(userId)).forEach(addComponent);
        } else if (!appIds.isEmpty()) {
            appIds.stream().filter(i -> this.getOrganisationController().isComponentAvailableToUser(i, userId)).forEach(addComponent);
        } else {
            Arrays.stream(this.getOrganisationController().getAvailCompoIds(spaceId, userId)).forEach(addComponent);
        }
    }

    private void setCreationDateInterval(QueryDescription queryDescription, String startDate, String endDate) {
        if (StringUtil.isDefined((String)startDate)) {
            try {
                queryDescription.setRequestedCreatedAfter(LocalDate.parse(startDate));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)((Object)this)).error("Can't parse start date as Long : {0}", (Object[])new String[]{startDate}, (Throwable)e);
            }
        }
        if (StringUtil.isDefined((String)endDate)) {
            try {
                queryDescription.setRequestedCreatedBefore(LocalDate.parse(endDate));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)((Object)this)).error("Can't parse end date as Long : {0}", (Object[])new String[]{endDate}, (Throwable)e);
            }
        }
    }

    private void setQueryFormFields(QueryDescription queryDescription, String form, List<String> paramNames) {
        ArrayList<FieldDescription> formQuery = new ArrayList<FieldDescription>();
        for (String paramName : paramNames) {
            String value;
            String fieldName;
            if (paramName.startsWith("field_")) {
                fieldName = paramName.replace("field_", "");
                value = this.getHttpRequest().getParameter(paramName);
                formQuery.add(new FieldDescription(form + "$$" + fieldName, value, "fr"));
                continue;
            }
            if (!paramName.startsWith("fieldDate_")) continue;
            fieldName = paramName.replace("fieldDate_", "");
            value = this.getHttpRequest().getParameter(paramName);
            String sDate = value.substring(0, value.indexOf(","));
            String eDate = value.substring(value.indexOf(",") + 1);
            Date fromDate = null;
            Date toDate = null;
            try {
                fromDate = DateUtil.parseISO8601Date((String)sDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                toDate = DateUtil.parseISO8601Date((String)eDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (fromDate == null && toDate == null) continue;
            formQuery.add(new FieldDescription(form + "$$" + fieldName, fromDate, toDate, "fr"));
        }
        queryDescription.setFieldQueries(formQuery);
    }

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return "";
    }
}

