/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.search;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.core.index.search.model.SearchResult;
import org.silverpeas.kernel.util.StringUtil;

public class ResultEntity {
    @XmlElement(defaultValue="")
    private String name;
    @XmlElement(defaultValue="")
    private String description;
    @XmlElement
    private String creationDate;
    @XmlElement
    private String updateDate;
    @XmlElement
    private String type;
    @XmlElement
    private String id;
    @XmlElement
    private String componentId;
    @XmlElement
    private String thumbnailURL;
    @XmlElement
    private Map<String, String> fieldsForFacets;

    private ResultEntity(SearchResult gsr) {
        this.name = gsr.getName();
        this.description = gsr.getDescription();
        if (gsr.getCreationLocalDate() != null) {
            this.creationDate = gsr.getCreationLocalDate().toString();
        }
        if (gsr.getLastUpdateLocalDate() != null) {
            this.updateDate = gsr.getLastUpdateLocalDate().toString();
        }
        this.id = gsr.getId();
        this.type = gsr.getType();
        this.componentId = gsr.getInstanceId();
        if (StringUtil.isDefined((String)gsr.getThumbnailURL())) {
            this.thumbnailURL = gsr.getThumbnailURL().replaceFirst("/FileServer/", "/OnlineFileServer/");
        }
        this.fieldsForFacets = gsr.getFormFieldsForFacets();
    }

    public static ResultEntity fromSearchResult(SearchResult gsr) {
        return new ResultEntity(gsr);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getThumbnailURL() {
        return this.thumbnailURL;
    }

    public void setThumbnailURL(String thumbnailURL) {
        this.thumbnailURL = thumbnailURL;
    }

    public Map<String, String> getFieldsForFacets() {
        return this.fieldsForFacets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultEntity that = (ResultEntity)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return this.componentId != null ? this.componentId.equals(that.componentId) : that.componentId == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.componentId != null ? this.componentId.hashCode() : 0);
        return result;
    }
}

