/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.profile;

import java.util.Arrays;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.util.StringUtil;

public class UserProfilesSearchCriteriaBuilder {
    private UserDetailsSearchCriteria searchCriteria = new UserDetailsSearchCriteria();
    private boolean includeRemoved = false;

    public static UserProfilesSearchCriteriaBuilder aSearchCriteria() {
        return new UserProfilesSearchCriteriaBuilder();
    }

    public UserProfilesSearchCriteriaBuilder withName(String name) {
        if (StringUtil.isDefined((String)name)) {
            String filterByName = name.replace('*', '%');
            this.searchCriteria.onName(filterByName);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withComponentInstanceId(String instanceId) {
        if (StringUtil.isDefined((String)instanceId)) {
            this.searchCriteria.onComponentInstanceId(instanceId);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withResourceId(String resourceId) {
        if (StringUtil.isDefined((String)resourceId)) {
            this.searchCriteria.onResourceId(resourceId);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withRoles(String[] roleIds, boolean matchingAllRoles) {
        if (roleIds != null && roleIds.length > 0) {
            this.searchCriteria.onRoleNames(roleIds);
            if (matchingAllRoles) {
                this.searchCriteria.matchingAllRoleNames();
            }
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withGroupIds(String ... groupIds) {
        if (ArrayUtil.isNotEmpty((Object[])groupIds)) {
            if (ArrayUtil.contains((Object[])groupIds, (Object)"all")) {
                this.searchCriteria.onGroupIds(UserDetailsSearchCriteria.ANY_GROUPS);
            } else {
                this.searchCriteria.onGroupIds(groupIds);
            }
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withDomainIds(String ... domainIds) {
        this.searchCriteria.onDomainIds(domainIds);
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withAccessLevels(UserAccessLevel ... accessLevels) {
        if (accessLevels != null && accessLevels.length > 0) {
            this.searchCriteria.onAccessLevels(accessLevels);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withUserIds(String ... userIds) {
        if (userIds != null && userIds.length > 0) {
            this.searchCriteria.onUserIds(userIds);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withUserSpecificIds(String ... userSpecificIds) {
        if (userSpecificIds != null && userSpecificIds.length > 0) {
            this.searchCriteria.onUserSpecificIds(userSpecificIds);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withUserStatesToExclude(UserState ... userStates) {
        if (userStates != null && userStates.length > 0) {
            this.searchCriteria.onUserStatesToExclude(userStates);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder includeAlsoRemovedUsers() {
        this.includeRemoved = true;
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withPaginationPage(PaginationPage page) {
        this.searchCriteria.onPagination(page);
        return this;
    }

    public UserDetailsSearchCriteria build() {
        if (!this.includeRemoved) {
            UserState[] allExcludedStates;
            if (this.searchCriteria.isCriterionOnUserStatesToExcludeSet()) {
                UserState[] excludedStates = this.searchCriteria.getCriterionOnUserStatesToExclude();
                allExcludedStates = Arrays.copyOf(excludedStates, excludedStates.length + 1);
                allExcludedStates[excludedStates.length] = UserState.REMOVED;
            } else {
                allExcludedStates = new UserState[]{UserState.REMOVED};
            }
            this.searchCriteria.onUserStatesToExclude(allExcludedStates);
        } else {
            this.searchCriteria.includeRemovedUsers();
        }
        return this.searchCriteria;
    }

    private UserProfilesSearchCriteriaBuilder() {
    }
}

