/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;

@Service
class UserProfileService {
    UserProfileService() {
    }

    public Group getGroupAccessibleToUser(String groupId, UserDetail user) {
        Group theGroup = Group.getById((String)groupId);
        if (theGroup == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (user.isDomainRestricted() && theGroup.getDomainId() != null && !user.getDomainId().equals(theGroup.getDomainId())) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The user with id {0} isn''t authorized to access the group with id {1}", new Object[]{user.getId(), groupId});
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return theGroup;
    }

    public List<Group> getGroupsAccessibleToUser(List<String> groupIds, UserDetail user) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String groupId : groupIds) {
            Group group = this.getGroupAccessibleToUser(groupId, user);
            groups.add(group);
        }
        return groups;
    }
}

