/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.pdc.pdc.model.ClassifyValue;
import org.silverpeas.core.pdc.pdc.model.PdcAxisValue;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.webapi.pdc.LocalizedClassifyValue;
import org.silverpeas.core.webapi.pdc.LocalizedPdcAxisValue;
import org.silverpeas.core.webapi.pdc.PdcValueEntity;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
public class PdcPositionValueEntity
extends PdcValueEntity {
    private static final long serialVersionUID = -6826039385078009600L;
    @XmlElement(defaultValue="")
    @NotNull
    private String meaning;

    public static PdcPositionValueEntity fromClassifiyValue(ClassifyValue value, String inLanguage) {
        List termPath = value.getFullPath();
        Value term = (Value)value.getFullPath().get(termPath.size() - 1);
        PdcPositionValueEntity positionValue = new PdcPositionValueEntity(PdcPositionValueEntity.withId(value.getValue()), PdcPositionValueEntity.inAxis(value.getAxisId()), PdcPositionValueEntity.withTranslatedMeaningOf(value, inLanguage));
        String treeId = term.getTreeId();
        if (StringUtil.isDefined((String)treeId) && Integer.valueOf(treeId) >= 0) {
            positionValue.setTreeId(treeId);
        }
        return positionValue;
    }

    static PdcPositionValueEntity fromPdcAxisValue(PdcAxisValue value, String inLanguage) {
        PdcPositionValueEntity positionValue = new PdcPositionValueEntity(PdcPositionValueEntity.withId(value.getValuePath() + "/"), PdcPositionValueEntity.inAxis(value.getAxisId()), PdcPositionValueEntity.withTranslatedMeaningOf(value, inLanguage));
        String treeId = String.valueOf(value.getAxisId());
        positionValue.setTreeId(treeId);
        return positionValue;
    }

    public static PdcPositionValueEntity aPositionValue(int axisId, String valueId) {
        return new PdcPositionValueEntity(valueId, axisId, "");
    }

    public ClassifyValue toClassifyValue() {
        ClassifyValue value = new ClassifyValue(this.getAxisId(), this.getId());
        return value;
    }

    public PdcAxisValue toPdcAxisValue() {
        return PdcAxisValue.aPdcAxisValue((String)this.getTermId(), (String)String.valueOf(this.getAxisId()));
    }

    public String getMeaning() {
        return this.meaning;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdcPositionValueEntity other = (PdcPositionValueEntity)obj;
        if (!super.equals(other)) {
            return false;
        }
        return !(this.meaning != null ? !this.meaning.equals(other.meaning) : other.meaning != null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + super.hashCode();
        hash = 59 * hash + (this.meaning != null ? this.meaning.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder synonymArray = new StringBuilder("[");
        for (String synonym : this.getSynonyms()) {
            synonymArray.append(synonym).append(", ");
        }
        if (synonymArray.length() > 1) {
            synonymArray.replace(synonymArray.length() - 2, synonymArray.length(), "]");
        } else {
            synonymArray.append("]");
        }
        return "PdcPositionValue{id=" + this.getId() + ", axisId=" + this.getAxisId() + ", treeId=" + this.getTreeId() + ", meaning=" + this.getMeaning() + ", synonyms=" + synonymArray.toString() + "}";
    }

    private static String withId(String valueId) {
        return valueId;
    }

    private static int inAxis(int axisId) {
        return axisId;
    }

    private static int inAxis(String axisId) {
        return Integer.valueOf(axisId);
    }

    private static String withTranslatedMeaningOf(ClassifyValue value, String inLanguage) {
        LocalizedClassifyValue localizedValue = LocalizedClassifyValue.decorate(value, inLanguage);
        return localizedValue.getLocalizedPath();
    }

    private static String withTranslatedMeaningOf(PdcAxisValue value, String inLanguage) {
        LocalizedPdcAxisValue localizedValue = LocalizedPdcAxisValue.decorate(value, inLanguage);
        return localizedValue.getLocalizedPath();
    }

    protected PdcPositionValueEntity() {
    }

    private PdcPositionValueEntity(String id, int axisId, String path) {
        super(id, axisId);
        this.meaning = path;
    }
}

