/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.documenttemplate;

import java.util.Optional;
import javax.inject.Inject;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.documenttemplate.DocumentTemplateService;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.viewer.service.ViewerContext;
import org.silverpeas.core.webapi.viewer.ResourceView;
import org.silverpeas.core.webapi.viewer.ResourceViewProvider;
import org.silverpeas.core.webapi.viewer.ResourceViewProviderRegistry;

@Provider
public class DocumentTemplateResourceViewProvider
implements ResourceViewProvider,
Initialization {
    @Inject
    private DocumentTemplateService service;

    public void init() {
        ResourceViewProviderRegistry.get().addNewEmbedMediaProvider(this);
    }

    @Override
    public Optional<ResourceView> getByIdAndLanguage(String mediaId, String language) {
        return this.service.getById(mediaId).map(t -> new DocumentTemplateResourceView((DocumentTemplate)t, language));
    }

    @Override
    public String relatedToService() {
        return "documentTemplate";
    }

    private static class DocumentTemplateResourceView
    implements ResourceView {
        private final DocumentTemplate template;
        private final String language;

        private DocumentTemplateResourceView(DocumentTemplate template, String language) {
            this.template = template;
            this.language = language;
        }

        @Override
        public String getId() {
            return this.template.getId();
        }

        @Override
        public String getName() {
            return this.template.getName(this.language);
        }

        @Override
        public String getContentType() {
            return this.template.getContentType();
        }

        @Override
        public ViewerContext getViewerContext() {
            return this.template.getViewerContext(this.language);
        }

        public boolean canBeAccessedBy(User user) {
            return true;
        }

        @Override
        public boolean isDownloadableBy(User user) {
            return false;
        }
    }
}

