/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.comment;

import java.net.URI;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.comment.CommentRuntimeException;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.model.CommentId;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.comment.CommentEntity;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

@RequestScoped
@Path(value="comments/{componentId}/{contentType}/{contentId}")
@Authorized
public class CommentResource
extends RESTWebService {
    static final String PATH = "comments";
    @Inject
    private CommentService commentService;
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="contentType")
    private String contentType;
    @PathParam(value="contentId")
    private String contentId;
    @Inject
    private PublicationService publicationService;

    protected String getResourceBasePath() {
        return PATH;
    }

    @GET
    @Path(value="{commentId}")
    @Produces(value={"application/json"})
    public CommentEntity getComment(@PathParam(value="commentId") String onCommentId) {
        try {
            CommentId id = new CommentId(this.inComponentId(), onCommentId);
            Comment theComment = this.commentService().getComment(id);
            URI commentURI = this.getUri().getRequestUri();
            return this.asWebEntity(theComment, this.identifiedBy(commentURI));
        }
        catch (CommentRuntimeException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public CommentEntity[] getAllComments() {
        try {
            ResourceReference ref = new ResourceReference(this.onContentId(), this.inComponentId());
            List theComments = this.commentService().getAllCommentsOnResource(this.onContentType(), ref);
            return this.asWebEntities(theComments);
        }
        catch (CommentRuntimeException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response saveNewComment(CommentEntity commentToSave) {
        this.checkIsValid(commentToSave);
        try {
            Comment comment = commentToSave.toComment();
            Comment savedComment = commentToSave.isIndexed() ? this.commentService().createAndIndexComment(comment) : this.commentService().createComment(comment);
            URI commentURI = this.getUri().getRequestUriBuilder().path(savedComment.getId()).build(new Object[0]);
            return Response.created((URI)commentURI).entity((Object)this.asWebEntity(savedComment, this.identifiedBy(commentURI))).build();
        }
        catch (CommentRuntimeException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.CONFLICT);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{commentId}")
    public CommentEntity updateComment(@PathParam(value="commentId") String commentId, CommentEntity commentToUpdate) {
        this.checkIsValid(commentToUpdate);
        if (!commentToUpdate.getId().equals(commentId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        CommentId id = new CommentId(this.inComponentId(), commentId);
        try {
            Comment comment = this.commentService().getComment(id);
            if (!comment.canBeModifiedBy(this.getUser())) {
                throw new ForbiddenException();
            }
            comment.setMessage(commentToUpdate.getText());
            if (commentToUpdate.isIndexed()) {
                this.commentService().updateAndIndexComment(comment);
            } else {
                this.commentService().updateComment(comment);
            }
            URI commentURI = this.getUri().getRequestUriBuilder().path(comment.getId()).build(new Object[0]);
            return this.asWebEntity(comment, this.identifiedBy(commentURI));
        }
        catch (CommentRuntimeException | SilverpeasRuntimeException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error(ex);
            throw new WebApplicationException(ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @DELETE
    @Path(value="{commentId}")
    public void deleteComment(@PathParam(value="commentId") String onCommentId) {
        try {
            CommentId id = new CommentId(this.inComponentId(), onCommentId);
            Comment comment = this.commentService().getComment(id);
            if (!comment.canBeDeletedBy(this.getUser())) {
                throw new ForbiddenException();
            }
            this.commentService().deleteComment(id);
        }
        catch (CommentRuntimeException | SilverpeasRuntimeException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error(ex.getMessage(), ex);
            throw new WebApplicationException(ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected String inComponentId() {
        return this.getComponentId();
    }

    protected String onContentType() {
        return this.contentType;
    }

    protected String onContentId() {
        return this.contentId;
    }

    protected CommentService commentService() {
        return this.commentService;
    }

    protected CommentEntity[] asWebEntities(List<Comment> comments) {
        CommentEntity[] entities = new CommentEntity[comments.size()];
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = comments.get(i);
            URI commentURI = this.getUri().getRequestUriBuilder().path(comment.getId()).build(new Object[0]);
            entities[i] = this.asWebEntity(comment, this.identifiedBy(commentURI));
        }
        return entities;
    }

    protected CommentEntity asWebEntity(Comment comment, URI commentURI) {
        return CommentEntity.fromComment(comment).withURI(commentURI).withCurrentUserLanguage(this.getUserPreferences().getLanguage());
    }

    protected URI identifiedBy(URI uri) {
        return uri;
    }

    public String getComponentId() {
        return this.componentId;
    }

    protected String getContentType() {
        return this.contentType;
    }

    protected String getContentId() {
        return this.contentId;
    }

    protected void checkIsValid(CommentEntity theComment) {
        if (this.getUser().isAnonymous() || this.getUser().isAccessGuest()) {
            throw new WebApplicationException("anonymous or guest user cannot manage comments", Response.Status.FORBIDDEN);
        }
        if (!(theComment.getComponentId().equals(this.getComponentId()) && theComment.getResourceType().equals(this.getContentType()) && theComment.getResourceId().equals(this.getContentId()))) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    public void validateUserAuthorization(UserPrivilegeValidation validation) {
        if ("Publication".equals(this.getContentType())) {
            PublicationDetail publi = this.publicationService.getDetail(new PublicationPK(this.getContentId(), this.getComponentId()));
            validation.validateUserAuthorizationOnPublication(this.getHttpServletRequest(), this.getUser(), publi);
        } else {
            super.validateUserAuthorization(validation);
        }
    }
}

