/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.bundle;

import java.io.IOException;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@RequestScoped
@Path(value="bundles")
@Authenticated
public class BundleResource
extends RESTWebService {
    static final String PATH = "bundles";
    private static final String GENERAL_SETTINGS = "org.silverpeas.general";
    private static final String PROPERTIES_FILE_EXT = ".properties";
    private static final String LANG_SEPARATOR = "_";

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void validateUserAuthentication(UserPrivilegeValidation validation) {
        block2: {
            try {
                super.validateUserAuthentication(validation.skipLastUserAccessTimeRegistering(this.getHttpServletRequest()));
            }
            catch (WebApplicationException wae) {
                if (Response.Status.UNAUTHORIZED.getStatusCode() == wae.getResponse().getStatus()) break block2;
                throw wae;
            }
        }
    }

    @GET
    @Path(value="just/{bundle: org/silverpeas/[a-zA-Z0-9/._$]+}")
    @Produces(value={"text/plain"})
    public Response getLocalizedBundle(@PathParam(value="bundle") String bundle) throws IOException {
        return this.getLocalizedBundle(bundle, true);
    }

    @GET
    @Path(value="{bundle: org/silverpeas/[a-zA-Z0-9/._$]+}")
    @Produces(value={"text/plain"})
    public Response getLocalizedBundle(@PathParam(value="bundle") String bundle, @QueryParam(value="withoutGeneral") boolean withoutGeneral) throws IOException {
        boolean withGeneral = !withoutGeneral;
        LocalizationBundle resource = this.getBundle(bundle);
        String language = resource.getLocale().getLanguage();
        String bundleName = resource.getBaseBundleName() + " - " + language;
        String generalBundleName = "org.silverpeas.multilang.generalMultilang - " + language;
        try {
            if (!bundle.trim().isEmpty() && bundle.contains("multilang")) {
                StringWriter messages = new StringWriter();
                Properties properties = new Properties();
                Properties generalProperties = new Properties();
                Set keys = withGeneral ? resource.keySet() : resource.specificKeySet();
                for (String key : keys) {
                    if (withGeneral && key.startsWith("GML.")) {
                        generalProperties.setProperty(key, resource.getString(key));
                        continue;
                    }
                    properties.setProperty(key, resource.getString(key));
                }
                properties.store(messages, bundleName);
                if (withGeneral) {
                    generalProperties.store(messages, generalBundleName);
                }
                return Response.ok((Object)messages.toString().replaceAll("([^'])[']([^'])", "$1''$2")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"It is not a localized bundle with translations").build();
        }
        catch (MissingResourceException ex) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    private LocalizationBundle getBundle(String bundle) {
        String language = this.getLanguage();
        String localizedBundle = bundle;
        if (bundle.endsWith(PROPERTIES_FILE_EXT)) {
            localizedBundle = bundle.substring(0, bundle.indexOf(PROPERTIES_FILE_EXT));
        }
        if (localizedBundle.lastIndexOf(LANG_SEPARATOR) == localizedBundle.length() - 3) {
            String askedLanguage = localizedBundle.substring(bundle.lastIndexOf(LANG_SEPARATOR) + 1);
            if (!askedLanguage.equals("$$")) {
                language = askedLanguage;
            }
            localizedBundle = localizedBundle.substring(0, bundle.lastIndexOf(LANG_SEPARATOR));
        }
        localizedBundle = localizedBundle.replaceAll("/", ".");
        return ResourceLocator.getLocalizationBundle((String)localizedBundle, (String)language);
    }

    @GET
    @Path(value="settings/{bundle: org/silverpeas/[a-zA-Z0-9/._$]+}")
    @Produces(value={"text/plain"})
    public Response getSettingsBundle(@PathParam(value="bundle") String bundle, @QueryParam(value="withGeneral") boolean withGeneral) throws IOException {
        String settingsBundle = bundle;
        if (bundle.endsWith(PROPERTIES_FILE_EXT)) {
            settingsBundle = bundle.substring(0, bundle.indexOf(PROPERTIES_FILE_EXT));
        }
        if (settingsBundle.lastIndexOf(LANG_SEPARATOR) == settingsBundle.length() - 3) {
            settingsBundle = settingsBundle.substring(0, bundle.lastIndexOf(LANG_SEPARATOR));
        }
        settingsBundle = settingsBundle.replaceAll("/", ".");
        SettingBundle settings = ResourceLocator.getSettingBundle((String)settingsBundle);
        try {
            if (!bundle.trim().isEmpty() && !bundle.contains("multilang")) {
                StringWriter messages = new StringWriter();
                Properties properties = new Properties();
                Properties generalProperties = new Properties();
                if (withGeneral) {
                    SettingBundle generalSettings = ResourceLocator.getSettingBundle((String)GENERAL_SETTINGS);
                    for (String key : generalSettings.keySet()) {
                        generalProperties.setProperty(key, generalSettings.getString(key));
                    }
                }
                for (String key : settings.keySet()) {
                    properties.setProperty(key, settings.getString(key));
                }
                properties.store(messages, settingsBundle);
                generalProperties.store(messages, GENERAL_SETTINGS);
                return Response.ok((Object)messages.toString()).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"It is not a settings bundle").build();
        }
        catch (MissingResourceException ex) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    private String getLanguage() {
        String language = this.getUser() != null ? this.getUserPreferences().getLanguage() : (this.getHttpRequest().getLocale() != null ? DisplayI18NHelper.verifyLanguage((String)this.getHttpRequest().getLocale().getLanguage()) : DisplayI18NHelper.getDefaultLanguage());
        return language;
    }
}

