/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.scim;

import edu.psu.swe.scim.spec.protocol.data.PatchOperation;
import edu.psu.swe.scim.spec.resources.Email;
import edu.psu.swe.scim.spec.resources.Name;
import edu.psu.swe.scim.spec.resources.ScimUser;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.web.http.RequestParameterDecoder;
import org.silverpeas.core.webapi.admin.scim.ScimLogger;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.Mutable;

public class PatchOperationApplier {
    private static final String VALUE_ATTR_NAME = "value";
    private static final String PRIMARY_ATTR_NAME = "primary";
    private final ScimUser scimUser;

    PatchOperationApplier(ScimUser scimUser) {
        this.scimUser = scimUser;
    }

    void apply(PatchOperation operation) {
        String attrName = operation.getPath().getValuePathExpression().getAttributePath().getFullAttributeName();
        if (attrName.equals("active")) {
            this.applyActiveData(operation);
        } else if (attrName.equals("externalId")) {
            this.applyExternalIdData(operation);
        } else if (attrName.contains("emails")) {
            this.applyMailData(operation);
        } else if (attrName.contains("name.")) {
            this.applyNameData(operation, attrName);
        } else if (attrName.equals("userName")) {
            this.applyLoginData(operation);
        } else {
            ScimLogger.logger().debug(() -> {
                String value = this.getValue(operation, VALUE_ATTR_NAME, String.class);
                return MessageFormat.format("attribute {0} with value {1} has been skipped as it is not handled by Silverpeas", attrName, value);
            });
        }
    }

    private void applyExternalIdData(PatchOperation operation) {
        PatchOperation.Type o = operation.getOperation();
        if (o == PatchOperation.Type.ADD || o == PatchOperation.Type.REPLACE) {
            this.scimUser.setExternalId(this.getValue(operation, VALUE_ATTR_NAME, String.class));
        } else if (o == PatchOperation.Type.REMOVE) {
            throw new SilverpeasRuntimeException("cannot remove external id?!!");
        }
    }

    private void applyLoginData(PatchOperation operation) {
        PatchOperation.Type o = operation.getOperation();
        if (o == PatchOperation.Type.ADD || o == PatchOperation.Type.REPLACE) {
            this.scimUser.setUserName(this.getValue(operation, VALUE_ATTR_NAME, String.class));
        } else if (o == PatchOperation.Type.REMOVE) {
            throw new SilverpeasRuntimeException("cannot remove login!");
        }
    }

    private void applyNameData(PatchOperation operation, String attrName) {
        PatchOperation.Type o = operation.getOperation();
        Name name = this.scimUser.getName();
        if (name == null) {
            name = new Name();
            this.scimUser.setName(name);
        }
        if (o == PatchOperation.Type.ADD || o == PatchOperation.Type.REPLACE) {
            String value = this.getValue(operation, VALUE_ATTR_NAME, String.class);
            if (attrName.endsWith(".givenName")) {
                name.setGivenName(value);
            } else if (attrName.endsWith(".familyName")) {
                name.setFamilyName(value);
            }
        } else if (o == PatchOperation.Type.REMOVE) {
            if (attrName.endsWith(".givenName")) {
                name.setGivenName(null);
            } else if (attrName.endsWith(".familyName")) {
                name.setFamilyName(null);
            }
        }
    }

    private void applyMailData(PatchOperation operation) {
        boolean isPrimary = this.getValue(operation, PRIMARY_ATTR_NAME, Boolean.class);
        if (isPrimary) {
            ArrayList<Email> emails = this.scimUser.getEmails();
            if (emails == null) {
                emails = new ArrayList<Email>();
                this.scimUser.setEmails(emails);
            }
            emails.clear();
            PatchOperation.Type o = operation.getOperation();
            if (o == PatchOperation.Type.ADD || o == PatchOperation.Type.REPLACE) {
                String value = this.getValue(operation, VALUE_ATTR_NAME, String.class);
                Email email = new Email();
                email.setValue(value);
                email.setPrimary(Boolean.valueOf(true));
                emails.add(email);
            }
        }
    }

    private void applyActiveData(PatchOperation operation) {
        PatchOperation.Type o = operation.getOperation();
        if (o == PatchOperation.Type.ADD || o == PatchOperation.Type.REPLACE) {
            this.scimUser.setActive(this.getValue(operation, VALUE_ATTR_NAME, Boolean.class));
        } else if (o == PatchOperation.Type.REMOVE) {
            throw new SilverpeasRuntimeException("cannot remove active state...");
        }
    }

    private <T> T getValue(PatchOperation operation, String attributeName, Class<T> clazz) {
        Mutable valueToPatch = Mutable.empty();
        Object value = operation.getValue();
        if (value instanceof List) {
            ((List)value).forEach(i -> i.forEach((k, v) -> {
                if (attributeName.equals(k)) {
                    if (clazz.isAssignableFrom(String.class)) {
                        valueToPatch.set((Object)v.toString());
                    } else if (clazz.isAssignableFrom(Long.class)) {
                        valueToPatch.set((Object)RequestParameterDecoder.asLong((Object)v));
                    } else if (clazz.isAssignableFrom(Integer.class)) {
                        valueToPatch.set((Object)RequestParameterDecoder.asInteger((Object)v));
                    } else if (clazz.isAssignableFrom(Boolean.class)) {
                        valueToPatch.set((Object)RequestParameterDecoder.asBoolean((Object)v));
                    } else {
                        throw new UnsupportedOperationException(MessageFormat.format("The type {0} is not handled for attribute {1}...", clazz.getName(), attributeName));
                    }
                }
            }));
        }
        return (T)valueToPatch.get();
    }
}

