/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.component;

import java.util.Optional;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.kernel.cache.model.SimpleCache;

public class SilverpeasComponentInstanceRoleProvider {
    private static final String HIGHEST_USER_ROLE_PREFIX = "@HIGHEST_COMPONENT_USER_ROLE_PREFIX@";

    private SilverpeasComponentInstanceRoleProvider() {
    }

    public static SilverpeasRole getHighestOfCurrentUserOn(String componentInstanceId) {
        String cacheKey = HIGHEST_USER_ROLE_PREFIX + componentInstanceId;
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        SilverpeasRole highestOfCurrentUser = (SilverpeasRole)cache.get((Object)cacheKey, SilverpeasRole.class);
        if (highestOfCurrentUser == null) {
            Optional silverpeasComponentInstance = OrganizationControllerProvider.getOrganisationController().getComponentInstance(componentInstanceId);
            if (silverpeasComponentInstance.isPresent()) {
                highestOfCurrentUser = ((SilverpeasComponentInstance)silverpeasComponentInstance.get()).getHighestSilverpeasRolesFor(User.getCurrentRequester());
            }
            cache.put((Object)cacheKey, (Object)highestOfCurrentUser);
        }
        return highestOfCurrentUser;
    }
}

