/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.admin.AbstractAdminResource;
import org.silverpeas.core.webapi.admin.ComponentEntity;
import org.silverpeas.core.webapi.admin.PersonalComponentEntity;
import org.silverpeas.core.webapi.admin.SpaceAppearanceEntity;
import org.silverpeas.core.webapi.admin.SpaceEntity;
import org.silverpeas.core.webapi.admin.StructureElementEntity;
import org.silverpeas.core.webapi.admin.UsersAndGroupsRoleEntity;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="spaces")
@Authenticated
public class SpaceResource
extends AbstractAdminResource {
    protected String getResourceBasePath() {
        return "spaces";
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<SpaceEntity> getAll(@QueryParam(value="forceGettingFavorite") boolean forceGettingFavorite) {
        try {
            return this.asWebEntities(this.loadSpaces(OrganizationController.get().getAllRootSpaceIds()), forceGettingFavorite);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}")
    @Produces(value={"application/json"})
    public SpaceEntity get(@PathParam(value="spaceId") String spaceId, @QueryParam(value="forceGettingFavorite") boolean forceGettingFavorite) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            return this.asWebEntity(this.loadSpace(spaceId), forceGettingFavorite);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/usersAndGroupsRoles")
    @Produces(value={"application/json"})
    public Map<SilverpeasRole, UsersAndGroupsRoleEntity> getUsersAndGroupsRoles(@PathParam(value="spaceId") String spaceId, @QueryParam(value="roles") String roles) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            return StringUtil.isDefined((String)roles) ? this.getUsersInSpacePerPlayedRoles(spaceId, Stream.of(StringUtils.split((String)roles, (String)",")).map(SilverpeasRole::fromString).filter(Predicate.not(Predicate.isEqual(SilverpeasRole.NONE)))) : this.getAllUsersInSpacePerRoles(spaceId);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private Map<SilverpeasRole, UsersAndGroupsRoleEntity> getAllUsersInSpacePerRoles(String spaceId) {
        SpaceInst spaceInst = this.getOrganisationController().getSpaceInstById(spaceId);
        if (spaceInst == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Stream<SilverpeasRole> roles = spaceInst.getAllSpaceProfilesInst().stream().map(BaseRightProfile::getName).map(SilverpeasRole::fromString).filter(Predicate.not(Predicate.isEqual(SilverpeasRole.NONE)));
        return this.getUsersInSpacePerPlayedRoles(spaceId, roles);
    }

    private Map<SilverpeasRole, UsersAndGroupsRoleEntity> getUsersInSpacePerPlayedRoles(String spaceId, Stream<SilverpeasRole> roles) {
        LocalizationBundle resource = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.jobStartPagePeas.multilang.jobStartPagePeasBundle", (String)this.getUserPreferences().getLanguage());
        LinkedHashMap<SilverpeasRole, UsersAndGroupsRoleEntity> result = new LinkedHashMap<SilverpeasRole, UsersAndGroupsRoleEntity>();
        roles.forEach(role -> {
            UsersAndGroupsRoleEntity roleEntity = result.computeIfAbsent((SilverpeasRole)role, r -> UsersAndGroupsRoleEntity.createFrom(role, resource.getString("JSPP." + role.getName())).withURI(this.getUri().getWebResourcePathBuilder().path(spaceId).path("usersAndGroupsRoles").queryParam("roles", new Object[]{role.getName()}).build(new Object[0])).withParentURI(this.getUri().getWebResourcePathBuilder().path(spaceId).build(new Object[0])));
            SpaceProfile profile = this.getOrganisationController().getSpaceProfile(spaceId, role);
            if (profile == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            profile.getAllUserIds().forEach(uid -> roleEntity.addUser(this.getUri().getBaseUriBuilder().path("profile/users").path(uid).build(new Object[0])));
            profile.getAllGroupIds().forEach(gid -> roleEntity.addGroup(this.getUri().getBaseUriBuilder().path("profile/groups").path(gid).build(new Object[0])));
        });
        return result;
    }

    @PUT
    @Path(value="{spaceId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public SpaceEntity update(@PathParam(value="spaceId") String spaceId, SpaceEntity spaceEntity) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            SpaceEntity oldSpaceEntity = this.get(spaceId, true);
            if (!oldSpaceEntity.getFavorite().equals(spaceEntity.getFavorite())) {
                if (spaceEntity.getFavorite().equals(String.valueOf(Boolean.TRUE))) {
                    this.getLookDelegate().addToUserFavorites(this.loadSpace(spaceId));
                } else if (spaceEntity.getFavorite().equals(String.valueOf(Boolean.FALSE))) {
                    this.getLookDelegate().removeFromUserFavorites(this.loadSpace(spaceId));
                }
            }
            return this.asWebEntity(this.loadSpace(spaceId), true);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/spaces")
    @Produces(value={"application/json"})
    public Collection<SpaceEntity> getSpaces(@PathParam(value="spaceId") String spaceId, @QueryParam(value="forceGettingFavorite") boolean forceGettingFavorite) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            return this.asWebEntities(this.loadSpaces(this.orgaController.getAllSubSpaceIds(spaceId)), forceGettingFavorite);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/components")
    @Produces(value={"application/json"})
    public Collection<ComponentEntity> getComponents(@PathParam(value="spaceId") String spaceId) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            return this.asWebEntities(this.loadComponents(this.orgaController.getAllComponentIds(spaceId)));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/content")
    @Produces(value={"application/json"})
    public Response getContent(@PathParam(value="spaceId") String spaceId, @QueryParam(value="forceGettingFavorite") boolean forceGettingFavorite) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            ArrayList<StructureElementEntity> content = new ArrayList<StructureElementEntity>();
            content.addAll(this.getSpaces(spaceId, forceGettingFavorite));
            content.addAll(this.getComponents(spaceId));
            return Response.ok(content).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{spaceId}/appearance")
    @Produces(value={"application/json"})
    public SpaceAppearanceEntity getAppearance(@PathParam(value="spaceId") String spaceId) {
        try {
            this.verifyUserAuthorizedToAccessSpace(spaceId);
            SpaceInstLight space = this.loadSpace(spaceId);
            return this.asWebEntity(space, this.getLookDelegate().getLook(space), this.getLookDelegate().getWallpaper(space), this.getLookDelegate().getCSS(space));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="personal")
    @Produces(value={"application/json"})
    public Response getPersonals(@QueryParam(value="getNotUsedComponents") boolean getNotUsedComponents, @QueryParam(value="getUsedComponents") boolean getUsedComponents, @QueryParam(value="getUsedTools") boolean getUsedTools) {
        try {
            boolean getAll = !getNotUsedComponents && !getUsedComponents && !getUsedTools;
            ArrayList personals = new ArrayList();
            if (getAll) {
                PersonalComponent.getAll().stream().map(p -> PersonalComponentInstance.from((User)this.getUser(), (PersonalComponent)p)).map(this::asWebPersonalEntity).forEach(personals::add);
            }
            if (getAll || getNotUsedComponents) {
                personals.addAll(this.asWebPersonalEntities(this.getAdminPersonalDelegate().getNotUsedComponents()));
            }
            if (getAll || getUsedComponents) {
                personals.addAll(this.asWebPersonalEntities(this.getAdminPersonalDelegate().getUsedComponents()));
            }
            if (getAll || getUsedTools) {
                personals.addAll(this.asWebPersonalEntities(this.getAdminPersonalDelegate().getUsedTools()));
            }
            return Response.ok(personals).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @PUT
    @Path(value="personal/{componentName}")
    @Produces(value={"application/json"})
    public PersonalComponentEntity useComponent(@PathParam(value="componentName") String componentName) {
        try {
            return this.asWebPersonalEntity((SilverpeasComponentInstance)this.getAdminPersonalDelegate().useComponent(componentName));
        }
        catch (AdminException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error("{0} is already instantiated into personal space", new Object[]{componentName});
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @DELETE
    @Path(value="personal/{componentName}")
    @Produces(value={"application/json"})
    public PersonalComponentEntity discardComponent(@PathParam(value="componentName") String componentName) {
        try {
            return this.asWebPersonalEntity((SilverpeasComponent)this.getAdminPersonalDelegate().discardComponent(componentName));
        }
        catch (AdminException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error("{0} is not instantiated into personal space", new Object[]{componentName});
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public String getComponentId() {
        return null;
    }
}

