/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.override;

import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.util.viewgenerator.html.JavascriptPluginInclusion;
import org.silverpeas.kernel.util.StringUtil;

public class LoadScriptTag
extends TagSupport {
    private static final long serialVersionUID = 1439996118011433471L;
    private String webContext = URLUtil.getApplicationURL();
    private String src;
    private String jsPromiseScope;
    private String jsPromiseName;

    public void setWebContext(String webContext) {
        this.webContext = webContext;
    }

    public String getWebContext() {
        return this.webContext;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getSrc() {
        return this.src;
    }

    public String getJsPromiseScope() {
        return this.jsPromiseScope;
    }

    public void setJsPromiseScope(String jsPromiseScope) {
        this.jsPromiseScope = jsPromiseScope;
    }

    public String getJsPromiseName() {
        return this.jsPromiseName;
    }

    public void setJsPromiseName(String jsPromiseName) {
        this.jsPromiseName = jsPromiseName;
    }

    public int doEndTag() throws JspException {
        String source = this.src.startsWith("/") && !this.src.startsWith(this.webContext) ? this.webContext + this.src : this.src;
        script dynamicLoading = new script().setType("text/javascript").addElement(LoadScriptTag.generateDynamicScriptLoading(source, this.jsPromiseName, this.jsPromiseScope));
        dynamicLoading.output((Writer)this.pageContext.getOut());
        return 6;
    }

    public static String generateDynamicScriptLoading(String src, String jsPromiseName, String jsPromiseScope) {
        String key = "$jsDynamic$script$" + src;
        if (CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)key) == null) {
            CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)key, (Object)true);
            if (StringUtil.isNotDefined((String)jsPromiseName)) {
                return "jQuery.ajax({type:'GET',url:'" + JavascriptPluginInclusion.normalizeWebResourceUrl(src) + "',dataType:'script',cache:true});";
            }
            Object scope = StringUtil.isDefined((String)jsPromiseScope) ? jsPromiseScope + "." : "var ";
            return (String)scope + jsPromiseName + "=new Promise(function(resolve, reject){jQuery.ajax({type:'GET',url:'" + JavascriptPluginInclusion.normalizeWebResourceUrl(src) + "',dataType:'script',cache:true,success:function(){resolve();}});});";
        }
        return "";
    }
}

