/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspTagException;
import org.apache.taglibs.standard.tag.rt.core.ForEachTag;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.util.comparator.AbstractComplexComparator;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPaneSilverpeasV5;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.Pagination;
import org.silverpeas.kernel.logging.SilverLogger;

public class ArrayLinesTag
extends ForEachTag {
    private static final long serialVersionUID = 1621133978805756811L;
    public static final String AJAX_EXPORT_PARAMETER_NAME = "ArrayPaneAjaxExport";

    public void setItems(Object items) throws JspTagException {
        ArrayPane arrayPane = this.getArrayPane();
        if (items instanceof List && arrayPane instanceof ArrayPaneSilverpeasV5) {
            ArrayPaneSilverpeasV5 spArrayPane = (ArrayPaneSilverpeasV5)arrayPane;
            this.optimize(spArrayPane, (List)items);
        } else {
            super.setItems(items);
        }
    }

    private void optimize(ArrayPaneSilverpeasV5 spArrayPane, List<?> list) throws JspTagException {
        SilverpeasList silverpeasList = SilverpeasList.wrap(list);
        HttpRequest httpRequest = HttpRequest.decorate((ServletRequest)this.pageContext.getRequest());
        boolean isAjaxExportAction = httpRequest.getParameterAsBoolean(AJAX_EXPORT_PARAMETER_NAME);
        if (silverpeasList.isSlice()) {
            if (isAjaxExportAction) {
                SilverLogger.getLogger((Object)((Object)this)).warn("On URL ''{0}'' export is requested on optimized array by high performance loading (load linked to repository queries), the export action is extracting only the current displayed page... Please implement a special export to get an export of all data", new Object[]{httpRequest.getRequestURL()});
            }
            spArrayPane.setPaginationList(silverpeasList);
            super.setItems((Object)silverpeasList);
        } else {
            this.sort(spArrayPane, (List<?>)silverpeasList);
            if (isAjaxExportAction) {
                spArrayPane.setPaginationList(silverpeasList);
                super.setItems((Object)silverpeasList);
            } else {
                Pagination pagination = spArrayPane.getPagination(list.size());
                SilverpeasList paginatedList = pagination.getPaginatedListFrom(silverpeasList);
                spArrayPane.setPaginationList(paginatedList);
                super.setItems(paginatedList);
            }
        }
    }

    private void sort(ArrayPaneSilverpeasV5 spArrayPane, List<?> list) {
        BiFunction<Object, Integer, Comparable<Object>> compareOn;
        List<ArrayColumn> columns = spArrayPane.getColumns();
        int columnToSort = spArrayPane.getColumnToSort();
        int columnIndex = Math.abs(columnToSort) - 1;
        if (0 <= columnIndex && columnIndex < columns.size() && (compareOn = columns.get(columnIndex).getCompareOn()) != null) {
            boolean asc = columnToSort >= 0;
            list.sort((Comparator<?>)((Object)new OptimizedLineComparator(columnIndex, asc, compareOn)));
        }
    }

    public ArrayPane getArrayPane() {
        return (ArrayPane)this.pageContext.getAttribute("pageContextArrayPane");
    }

    private static class OptimizedLineComparator
    extends AbstractComplexComparator<Object> {
        private static final long serialVersionUID = 8089102273880269806L;
        final int columnIndex;
        final transient List<BiFunction<Object, Integer, Comparable<Object>>> compareOnList;
        final boolean asc;

        @SafeVarargs
        private OptimizedLineComparator(int columnIndex, boolean asc, BiFunction<Object, Integer, Comparable<Object>> ... compareOnList) {
            this.columnIndex = columnIndex;
            this.compareOnList = Arrays.stream(compareOnList).collect(Collectors.toList());
            this.asc = asc;
        }

        protected AbstractComplexComparator.ValueBuffer getValuesToCompare(Object value) {
            AbstractComplexComparator.ValueBuffer valueBuffer = new AbstractComplexComparator.ValueBuffer((AbstractComplexComparator)this);
            this.compareOnList.forEach(c -> valueBuffer.append(c.apply(value, this.columnIndex), this.asc));
            return valueBuffer;
        }
    }
}

