/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.owasp.encoder.Encode;
import org.silverpeas.kernel.util.StringUtil;

public final class WebRedirection {
    public static final String REDIRECT_TO_ATTACHMENT = "RedirectToAttachmentId";
    public static final String REDIRECT_TO_COMPONENT = "RedirectToComponentId";
    public static final String REDIRECT_TO_SPACE = "RedirectToSpaceId";
    public static final String REDIRECT_RESOURCE_TYPE = "RedirectToMapping";
    public static final String REDIRECT_URL = "gotoNew";

    public String getRedirectionURL(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String gotoUrl = (String)session.getAttribute(REDIRECT_URL);
        String componentId = (String)session.getAttribute(REDIRECT_TO_COMPONENT);
        String spaceId = (String)session.getAttribute(REDIRECT_TO_SPACE);
        StringBuilder builder = new StringBuilder();
        if (StringUtil.isDefined((String)gotoUrl)) {
            builder.append("goto=").append(Encode.forUriComponent((String)gotoUrl));
        } else if (StringUtil.isDefined((String)componentId)) {
            builder.append("ComponentId=").append(componentId);
        } else if (StringUtil.isDefined((String)spaceId)) {
            builder.append("SpaceId=").append(spaceId);
        }
        if (builder.length() > 0) {
            builder.insert(0, "/autoRedirect.jsp?");
        }
        return builder.toString();
    }
}

