/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.treemenu.process;

import java.util.function.Supplier;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.treemenu.model.MenuRuntimeException;
import org.silverpeas.core.web.treemenu.model.TreeFilter;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class TreeFilterFactory {
    private static final Supplier<TreeFilter> FAIL = () -> {
        throw new MenuRuntimeException("No default tree filter found!");
    };

    private TreeFilterFactory() {
    }

    public static TreeFilter getTreeFilter(String filterName) {
        String defaultFilter = "defaultFilter";
        Object filterType = StringUtil.isDefined((String)filterName) ? filterName + "Filter" : defaultFilter;
        return TreeFilterFactory.providesOrElse((String)filterType, TreeFilterFactory.providesOrElse(defaultFilter, FAIL)).get();
    }

    private static Supplier<TreeFilter> providesOrElse(String filter, Supplier<TreeFilter> defaultSupplier) {
        return () -> {
            try {
                return (TreeFilter)ServiceProvider.getService((String)filter);
            }
            catch (SilverpeasRuntimeException e) {
                return (TreeFilter)defaultSupplier.get();
            }
        };
    }
}

