/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.treemenu.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.web.treemenu.model.MenuItem;
import org.silverpeas.core.web.treemenu.model.MenuRuntimeException;
import org.silverpeas.core.web.treemenu.model.NodeType;
import org.silverpeas.core.web.treemenu.model.TreeFilter;

public class TreeBuilder {
    private static final String KMELIA = "kmelia";
    private final OrganizationController controller = OrganizationControllerProvider.getOrganisationController();
    private final String userId;
    private final String language;
    private final boolean ordered;

    TreeBuilder(String userId, String language, boolean ordered) {
        this.userId = userId;
        this.language = language;
        this.ordered = ordered;
    }

    public MenuItem buildLevelMenu(TreeFilter filter, MenuItem father) {
        if (father == null) {
            return this.buildFirstLevel(filter);
        }
        return this.buildOtherLevel(filter, father);
    }

    private MenuItem buildOtherLevel(TreeFilter filter, MenuItem father) {
        MenuItem menuItem;
        Collection nodeDetails;
        NodePK nodePK;
        ArrayList<MenuItem> children = new ArrayList<MenuItem>();
        father.setChildren(children);
        if (father.isLeaf()) {
            return father;
        }
        if (father.getType() == NodeType.COMPONENT && filter.acceptNodeType(NodeType.THEME)) {
            nodePK = new NodePK("0", father.getKey());
            nodeDetails = TreeBuilder.getNodeService().getChildrenDetails(nodePK);
            for (NodeDetail nodeDetail : nodeDetails) {
                if (nodeDetail.isBin() || nodeDetail.isUnclassified()) continue;
                menuItem = new MenuItem(Encode.forHtml((String)nodeDetail.getName(this.language)), nodeDetail.getNodePK().getId(), nodeDetail.getLevel(), NodeType.THEME, false, father, father.getKey());
                menuItem.setNbObjects(nodeDetail.getNbObjects());
                children.add(menuItem);
            }
        }
        if (father.getType() == NodeType.SPACE) {
            children.addAll(this.getSubSpacesContainingComponent(father));
            children.addAll(this.getComponents(filter, father));
        }
        if (father.getType() == NodeType.THEME && filter.acceptNodeType(NodeType.THEME)) {
            nodePK = new NodePK(father.getKey(), father.getComponentId());
            nodeDetails = TreeBuilder.getNodeService().getChildrenDetails(nodePK);
            for (NodeDetail nodeDetail : nodeDetails) {
                menuItem = new MenuItem(Encode.forHtml((String)nodeDetail.getName(this.language)), nodeDetail.getNodePK().getId(), nodeDetail.getLevel(), NodeType.THEME, false, father, father.getComponentId());
                menuItem.setNbObjects(nodeDetail.getNbObjects());
                children.add(menuItem);
            }
        }
        return father;
    }

    private static boolean getLeafValue(String componentId) {
        return !componentId.startsWith(KMELIA);
    }

    private MenuItem buildFirstLevel(TreeFilter filter) {
        MenuItem item = new MenuItem("root");
        ArrayList<MenuItem> children = new ArrayList<MenuItem>();
        item.setChildren(children);
        if (filter.acceptNodeType(NodeType.SPACE)) {
            List rootSpaces = this.controller.getRootSpacesContainingComponent(this.userId, KMELIA);
            this.sortIfAsked(rootSpaces, s -> s.isPersonalSpace() ? -1 : s.getOrderNum());
            TreeBuilder.buildMenuItemsFromSpaces(null, children, rootSpaces, this.language);
        } else if (filter.acceptNodeType(NodeType.COMPONENT) && !filter.getComponents().isEmpty()) {
            for (String componentName : filter.getComponents()) {
                List componentList = this.controller.getAvailComponentInstLights(this.userId, componentName);
                this.sortIfAsked(componentList, ComponentInstLight::getOrderNum);
                boolean isLeaf = TreeBuilder.getLeafValue(componentName);
                TreeBuilder.buildMenuItemsFromComponentInstances(item, children, componentList, isLeaf, this.language);
            }
        }
        return item;
    }

    private static void buildMenuItemsFromComponentInstances(MenuItem father, List<MenuItem> menuItems, List<ComponentInstLight> componentList, boolean isLeaf, String language) {
        for (ComponentInstLight compo : componentList) {
            MenuItem subElement = new MenuItem(Encode.forHtml((String)compo.getLabel(language)), compo.getId(), 0, NodeType.COMPONENT, isLeaf, null, null);
            father.setComponentName(compo.getName());
            father.setLabelStyle("icon-" + compo.getName());
            menuItems.add(subElement);
        }
    }

    private static void buildMenuItemsFromSpaces(MenuItem father, List<MenuItem> menuItems, List<SpaceInstLight> spaces, String language) {
        for (SpaceInstLight space : spaces) {
            if (space == null) continue;
            MenuItem subElement = new MenuItem(space.getName(language), space.getId(), 0, NodeType.SPACE, false, father, null);
            menuItems.add(subElement);
        }
    }

    private List<MenuItem> getSubSpacesContainingComponent(MenuItem father) {
        ArrayList<MenuItem> subElements = new ArrayList<MenuItem>();
        List subspaces = this.controller.getSubSpacesContainingComponent(father.getKey(), this.userId, KMELIA);
        this.sortIfAsked(subspaces, SpaceInstLight::getOrderNum);
        TreeBuilder.buildMenuItemsFromSpaces(father, subElements, subspaces, this.language);
        return subElements;
    }

    private List<MenuItem> getComponents(TreeFilter filter, MenuItem father) {
        ArrayList<MenuItem> subElements = new ArrayList<MenuItem>();
        String[] componentIds = this.controller.getAvailCompoIdsAtRoot(father.getKey(), this.userId);
        int level = father.getLevel() + 1;
        boolean isLeaf = false;
        List<String> allowedComponents = filter.getComponents();
        for (String componentId : componentIds) {
            MenuItem item;
            ComponentInstLight component = this.controller.getComponentInstLight(componentId);
            if (allowedComponents.isEmpty() && filter.acceptNodeType(NodeType.COMPONENT)) {
                isLeaf = TreeBuilder.getLeafValue(componentId);
                item = new MenuItem(Encode.forHtml((String)component.getLabel(this.language)), componentId, level, NodeType.COMPONENT, isLeaf, father, null);
                item.setComponentName(component.getName());
                item.setLabelStyle("icon-" + component.getName());
                subElements.add(item);
                continue;
            }
            if (!allowedComponents.contains(component.getName())) continue;
            item = new MenuItem(Encode.forHtml((String)component.getLabel(this.language)), componentId, level, NodeType.COMPONENT, isLeaf, father, componentId);
            item.setComponentName(component.getName());
            item.setLabelStyle("icon-" + component.getName());
            subElements.add(item);
        }
        return subElements;
    }

    private static NodeService getNodeService() {
        try {
            return NodeService.get();
        }
        catch (Exception e) {
            throw new MenuRuntimeException("TreeBuilder.getNodeService()", e);
        }
    }

    private <T> void sortIfAsked(List<T> resources, Function<T, Integer> order) {
        if (this.ordered) {
            resources.sort(Comparator.comparing(order));
        }
    }
}

