/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.tools.agenda.control;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.personalorganizer.model.Category;
import org.silverpeas.core.personalorganizer.model.HolidayDetail;
import org.silverpeas.core.personalorganizer.model.JournalHeader;
import org.silverpeas.core.personalorganizer.model.ParticipationStatus;
import org.silverpeas.core.personalorganizer.model.Schedulable;
import org.silverpeas.core.personalorganizer.model.SchedulableCount;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLEncoder;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.web.calendar.ical.ExportIcalManager;
import org.silverpeas.core.web.calendar.ical.ImportIcalManager;
import org.silverpeas.core.web.calendar.ical.SynchroIcalManager;
import org.silverpeas.core.web.mvc.controller.AbstractComponentSessionController;
import org.silverpeas.core.web.mvc.controller.ComponentContext;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.selection.Selection;
import org.silverpeas.core.web.tools.agenda.control.AgendaException;
import org.silverpeas.core.web.tools.agenda.control.AgendaRuntimeException;
import org.silverpeas.core.web.tools.agenda.model.CalendarImportSettings;
import org.silverpeas.core.web.tools.agenda.model.CalendarImportSettingsDao;
import org.silverpeas.core.web.tools.agenda.notification.AgendaUserNotification;
import org.silverpeas.core.web.tools.agenda.view.AgendaHtmlView;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;

public class AgendaSessionController
extends AbstractComponentSessionController {
    private static final String RAGENDA_JSP_MAIN = "/Ragenda/jsp/Main";
    private int currentDisplayType = 1;
    private boolean calendarVisible = true;
    private Calendar currentCalendar;
    private SilverpeasCalendar calendarBm;
    private Category category = null;
    private JournalHeader currentJournalHeader = null;
    private Collection<Attendee> currentAttendees = null;
    private Collection<Category> currentCategories = null;
    private ParticipationStatus participationStatus = null;
    private NotificationSender notifSender = null;
    private List<Date> nonSelectableDays = null;
    private List<String> holidaysDates = null;
    private String serverURL = null;
    private String agendaUserId = this.getUserId();
    private UserDetail agendaUserDetail = this.getUserDetail();
    private final CalendarImportSettingsDao importSettingsDao = CalendarImportSettingsDao.getInstance();
    public static final String ICALENDAR_MIME_TYPE = "text/calendar";
    public static final String EXPORT_SUCCEEDED = "0";
    public static final String EXPORT_FAILED = "1";
    public static final String EXPORT_EMPTY = "2";
    public static final String IMPORT_SUCCEEDED = "0";
    public static final String IMPORT_FAILED = "1";
    public static final String SYNCHRO_SUCCEEDED = "0";
    public static final String SYNCHRO_FAILED = "1";
    public static final String AGENDA_FILENAME_PREFIX = "agenda";
    public static final int WORKING_DAY = 0;
    public static final int HOLIDAY_DAY = 1;

    public AgendaSessionController(MainSessionController mainSessionCtrl, ComponentContext context) {
        super(mainSessionCtrl, context, "org.silverpeas.agenda.multilang.agenda");
        this.setComponentRootName(AGENDA_FILENAME_PREFIX);
        this.initEJB();
        AdminController admin = (AdminController)ServiceProvider.getService(AdminController.class, (Annotation[])new Annotation[0]);
        Domain defaultDomain = admin.getDomain(this.getUserDetail().getDomainId());
        this.serverURL = defaultDomain.getSilverpeasServerURL();
    }

    private boolean isUseRss() {
        return "yes".equals(this.getSettings().getString("calendarRss"));
    }

    @Override
    public String getRSSUrl() {
        if (this.isUseRss()) {
            return "/rssAgenda/" + this.getAgendaUserId() + "?userId=" + this.getUserId() + "&amp;login=" + URLEncoder.encodePathParamValue((String)this.getUserDetail().getLogin()) + "&amp;password=" + URLEncoder.encodePathParamValue((String)this.getOrganisationController().getUserFull(this.getUserId()).getPassword());
        }
        return null;
    }

    private void initEJB() {
        this.calendarBm = null;
        this.setCalendarBm();
    }

    private void setCalendarBm() {
        if (this.calendarBm == null) {
            try {
                this.calendarBm = (SilverpeasCalendar)ServiceProvider.getService(SilverpeasCalendar.class, (Annotation[])new Annotation[0]);
            }
            catch (Exception e) {
                throw new AgendaRuntimeException(e);
            }
        }
    }

    protected String getComponentInstName() {
        return AGENDA_FILENAME_PREFIX;
    }

    public String addJournal(String name, String description, String priority, String classification, Date startDay, String startHour, Date endDay, String endHour) {
        JournalHeader journal = new JournalHeader(name, this.getUserId());
        journal.setDescription(description);
        try {
            journal.getPriority().setValue(Integer.parseInt(priority));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        try {
            journal.getClassification().setString(classification);
            journal.setStartDay(DateUtil.date2SQLDate((Date)startDay));
            journal.setStartHour(startHour);
            journal.setEndDay(DateUtil.date2SQLDate((Date)endDay));
            journal.setEndHour(endHour);
        }
        catch (ParseException pe) {
            throw new AgendaRuntimeException(pe);
        }
        return this.calendarBm.addJournal(journal);
    }

    protected void notifyAttendees(String id, NotifAction action) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new AgendaUserNotification(action, this.getUserDetail(), this.getJournalHeader(id)));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    protected void notifyFromAttendee(String id, String attend) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new AgendaUserNotification(this.getUserDetail(), this.getJournalHeader(id), attend));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void updateJournal(String id, String name, String description, String priority, String classification, Date startDay, String startHour, Date endDay, String endHour) {
        boolean changed = false;
        JournalHeader journal = this.getJournalHeader(id);
        journal.setName(name);
        journal.setDescription(description);
        try {
            journal.getPriority().setValue(Integer.parseInt(priority));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        try {
            changed = this.eventHasChanged(journal, startDay, startHour, endDay, endHour);
            journal.getClassification().setString(classification);
            journal.setStartDay(DateUtil.date2SQLDate((Date)startDay));
            journal.setStartHour(startHour);
            journal.setEndDay(DateUtil.date2SQLDate((Date)endDay));
            journal.setEndHour(endHour);
        }
        catch (ParseException pe) {
            throw new AgendaRuntimeException(pe);
        }
        this.calendarBm.updateJournal(journal);
        if (changed) {
            this.notifyAttendees(id, NotifAction.UPDATE);
        }
    }

    private boolean eventHasChanged(JournalHeader journal, Date startDay, String startHour, Date endDay, String endHour) {
        return DateUtil.datesAreEqual((Date)journal.getStartDate(), (Date)startDay) && DateUtil.datesAreEqual((Date)journal.getEndDate(), (Date)endDay) && journal.getStartHour() != null && journal.getStartHour().equals(startHour) && journal.getEndHour() != null && journal.getEndHour().equals(endHour);
    }

    public void removeJournal(String id) {
        this.notifyAttendees(id, NotifAction.DELETE);
        this.calendarBm.removeJournal(id);
    }

    public JournalHeader getJournalHeader(String journalId) {
        return this.calendarBm.getJournalHeader(journalId);
    }

    public Collection<Attendee> getJournalAttendees(String journalId) throws AgendaException {
        try {
            return this.calendarBm.getJournalAttendees(journalId);
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public void setJournalAttendees(String journalId, String[] userIds) throws AgendaException {
        try {
            this.calendarBm.setJournalAttendees(journalId, userIds);
            this.notifyAttendees(journalId, NotifAction.CREATE);
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public void setJournalParticipationStatus(String journalId, String userId, String status) throws AgendaException {
        try {
            this.calendarBm.setJournalParticipationStatus(journalId, userId, status);
            this.notifyFromAttendee(journalId, status);
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public Collection<Category> getAllCategories() throws AgendaException {
        try {
            return this.calendarBm.getAllCategories();
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public Category getCategory(String categoryId) throws AgendaException {
        try {
            return this.calendarBm.getCategory(categoryId);
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public Collection<Category> getJournalCategories(String journalId) throws AgendaException {
        try {
            return this.calendarBm.getJournalCategories(journalId);
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public void setJournalCategories(String journalId, String[] categoryIds) throws AgendaException {
        try {
            this.calendarBm.setJournalCategories(journalId, categoryIds);
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public UserDetail[] getUserList() {
        return (UserDetail[])this.getOrganisationController().getAllUsers();
    }

    @Override
    public UserDetail getUserDetail(String userId) {
        return (UserDetail)this.getOrganisationController().getUserDetail(userId);
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public JournalHeader getCurrentJournalHeader() {
        return this.currentJournalHeader;
    }

    public void setCurrentJournalHeader(JournalHeader journalHeader) {
        this.currentJournalHeader = journalHeader;
    }

    public Collection<Attendee> getCurrentAttendees() {
        return this.currentAttendees;
    }

    public void setCurrentAttendees(Collection<Attendee> attendees) {
        this.currentAttendees = attendees;
    }

    public Collection<Category> getCurrentCategories() {
        return this.currentCategories;
    }

    public void setCurrentCategories(Collection<Category> categories) {
        this.currentCategories = categories;
    }

    public void setCalendarVisible(boolean visible) {
        this.calendarVisible = visible;
    }

    public ParticipationStatus getParticipationStatus() {
        if (this.participationStatus == null) {
            this.participationStatus = new ParticipationStatus("accepted");
        }
        return this.participationStatus;
    }

    public NotificationSender getNotificationSender() {
        if (this.notifSender == null) {
            this.notifSender = new NotificationSender(null);
        }
        return this.notifSender;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    public SettingBundle getSettings() {
        return ResourceLocator.getSettingBundle((String)"org.silverpeas.agenda.settings.agendaSettings");
    }

    public void viewByDay() {
        this.currentDisplayType = 1;
    }

    public void viewByWeek() {
        this.currentDisplayType = 2;
    }

    public void viewByMonth() {
        this.currentDisplayType = 3;
    }

    public void viewByYear() {
        this.currentDisplayType = 4;
    }

    public void viewChooseDays() {
        this.currentDisplayType = 5;
    }

    public int getCurrentDisplayType() {
        return this.currentDisplayType;
    }

    public AgendaHtmlView getCurrentHtmlView() throws RemoteException {
        AgendaHtmlView agendaView = null;
        Collection<JournalHeader> schedules = null;
        if (this.currentDisplayType == 1) {
            agendaView = new AgendaHtmlView(this.currentDisplayType, this.getCurrentDay(), this, this.getSettings());
            agendaView.setCalendarVisible(this.calendarVisible);
            schedules = this.getDaySchedulables();
        } else if (this.currentDisplayType == 2) {
            agendaView = new AgendaHtmlView(this.currentDisplayType, this.getWeekFirstDay(this.getCurrentDay()), this, this.getSettings());
            schedules = this.getWeekSchedulables();
        } else if (this.currentDisplayType == 3) {
            agendaView = new AgendaHtmlView(this.currentDisplayType, AgendaSessionController.getMonthFirstDay(this.getCurrentDay()), this, this.getSettings());
            schedules = this.countMonthSchedulables();
        } else if (this.currentDisplayType == 4) {
            agendaView = new AgendaHtmlView(this.currentDisplayType, AgendaSessionController.getYearFirstDay(this.getCurrentDay()), this, this.getSettings());
        } else {
            return null;
        }
        if (schedules != null) {
            for (JournalHeader obj : schedules) {
                if (obj instanceof Schedulable) {
                    agendaView.add((Schedulable)obj);
                }
                if (!(obj instanceof SchedulableCount)) continue;
                agendaView.add((SchedulableCount)obj);
            }
        }
        return agendaView;
    }

    public Collection<JournalHeader> getDaySchedulables() {
        String categoryId = null;
        if (this.getCategory() != null) {
            categoryId = this.getCategory().getId();
        }
        return this.calendarBm.getDaySchedulablesForUser(DateUtil.date2SQLDate((Date)this.getCurrentDay()), this.agendaUserId, categoryId, this.getParticipationStatus().getString());
    }

    public Collection<JournalHeader> getMonthSchedulables(Date date) {
        Date begin = AgendaSessionController.getMonthFirstDay(date);
        Date end = this.getMonthLastDay(date);
        String categoryId = null;
        if (this.getCategory() != null) {
            categoryId = this.getCategory().getId();
        }
        return this.calendarBm.getPeriodSchedulablesForUser(DateUtil.date2SQLDate((Date)begin), DateUtil.date2SQLDate((Date)end), this.agendaUserId, categoryId, this.getParticipationStatus().getString());
    }

    public Collection<JournalHeader> getWeekSchedulables() {
        Date begin = this.getWeekFirstDay(this.getCurrentDay());
        Date end = this.getWeekLastDay(this.getCurrentDay());
        String categoryId = null;
        if (this.getCategory() != null) {
            categoryId = this.getCategory().getId();
        }
        return this.calendarBm.getPeriodSchedulablesForUser(DateUtil.date2SQLDate((Date)begin), DateUtil.date2SQLDate((Date)end), this.agendaUserId, categoryId, this.getParticipationStatus().getString());
    }

    public Collection<SchedulableCount> countMonthSchedulables() {
        String month = DateUtil.date2SQLDate((Date)this.getCurrentDay()).substring(0, 8);
        String categoryId = null;
        if (this.getCategory() != null) {
            categoryId = this.getCategory().getId();
        }
        return this.calendarBm.countMonthSchedulablesForUser(month, this.agendaUserId, categoryId, this.getParticipationStatus().getString());
    }

    public Collection<JournalHeader> getBusyTime(String userId, Date day) throws RemoteException {
        ArrayList<JournalHeader> result = this.calendarBm.getDaySchedulablesForUser(DateUtil.date2SQLDate((Date)day), userId, null, "accepted");
        if (!userId.equals(this.getUserId())) {
            ArrayList<JournalHeader> subResult = new ArrayList<JournalHeader>();
            for (JournalHeader schedule : result) {
                boolean toView = false;
                if (!schedule.getClassification().isConfidential()) {
                    toView = true;
                } else if (schedule.getDelegatorId().equals(this.getUserId())) {
                    toView = true;
                } else {
                    Collection attendees = this.calendarBm.getJournalAttendees(schedule.getId());
                    for (Attendee attendee : attendees) {
                        if (!attendee.getUserId().equals(this.getUserId())) continue;
                        toView = true;
                    }
                }
                if (!toView) continue;
                subResult.add(schedule);
            }
            result = subResult;
        }
        return result;
    }

    public boolean isDayHasEvents(String userId, Date day) {
        Collection result = this.calendarBm.getDaySchedulablesForUser(DateUtil.date2SQLDate((Date)day), userId, null, "accepted");
        return result != null && !result.isEmpty();
    }

    public boolean hasTentativeSchedulables() throws RemoteException {
        return this.calendarBm.hasTentativeSchedulablesForUser(this.getUserId());
    }

    public Collection<JournalHeader> getTentativeSchedulables() throws AgendaException {
        try {
            return this.calendarBm.getTentativeSchedulablesForUser(this.getUserId());
        }
        catch (Exception e) {
            throw new AgendaException(e);
        }
    }

    public Date getCurrentDay() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        return this.currentCalendar.getTime();
    }

    public int getStartDayInWeek() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 1) {
            return this.currentCalendar.get(7);
        }
        return Integer.parseInt(this.getString("weekFirstDay"));
    }

    public int getStartDayInMonth() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 1) {
            return this.currentCalendar.get(5);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getWeekFirstDay(this.currentCalendar.getTime()));
        return cal.get(5);
    }

    public int getEndDayInMonth() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 1) {
            return this.currentCalendar.get(5);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getWeekLastDay(this.currentCalendar.getTime()));
        return cal.get(5);
    }

    public int getStartMonth() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 2) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getWeekFirstDay(this.currentCalendar.getTime()));
            return cal.get(2);
        }
        return this.currentCalendar.get(2);
    }

    public int getEndMonth() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 2) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getWeekLastDay(this.currentCalendar.getTime()));
            return cal.get(2);
        }
        return this.currentCalendar.get(2);
    }

    public int getStartYear() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 2) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getWeekFirstDay(this.currentCalendar.getTime()));
            return result.get(1);
        }
        return this.currentCalendar.get(1);
    }

    public int getEndYear() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getWeekLastDay(this.currentCalendar.getTime()));
        return cal.get(1);
    }

    public void setCurrentDay(Date date) {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        this.currentCalendar.setTime(date);
    }

    public void selectDay(String day) {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        try {
            Date date = DateUtil.stringToDate((String)day, (String)this.getLanguage());
            this.currentCalendar.setTime(date);
            this.viewByDay();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void next() {
        if (this.currentDisplayType == 1) {
            this.nextDay();
        } else if (this.currentDisplayType == 2) {
            this.nextWeek();
        } else if (this.currentDisplayType == 3) {
            this.nextMonth();
        } else if (this.currentDisplayType == 4) {
            this.nextYear();
        }
    }

    public void nextDay() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(5, 1);
        while (this.isHolidayDate(this.currentCalendar.getTime())) {
            this.currentCalendar.add(5, 1);
        }
    }

    public void nextWeek() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(5, 7);
    }

    public void nextMonth() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(2, 1);
    }

    public void nextYear() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(1, 1);
    }

    public void previous() {
        if (this.currentDisplayType == 1) {
            this.previousDay();
        } else if (this.currentDisplayType == 2) {
            this.previousWeek();
        } else if (this.currentDisplayType == 3) {
            this.previousMonth();
        } else if (this.currentDisplayType == 4) {
            this.previousYear();
        }
    }

    public void previousDay() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(5, -1);
        while (this.isHolidayDate(this.currentCalendar.getTime())) {
            this.currentCalendar.add(5, -1);
        }
    }

    public void previousWeek() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(5, -7);
    }

    public void previousMonth() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(2, -1);
    }

    public void previousYear() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(1, -1);
    }

    public Date getWeekFirstDay(Date date) {
        int firstDayOfWeek = Integer.parseInt(this.getString("weekFirstDay"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        while (calendar.get(7) != firstDayOfWeek) {
            calendar.add(5, -1);
        }
        return calendar.getTime();
    }

    public Date getWeekLastDay(Date date) {
        int lastDayOfWeek = Integer.parseInt(this.getString("weekLastDay"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        while (calendar.get(7) != lastDayOfWeek) {
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    public static Date getMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public Date getMonthLastDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int monthLastDay = cal.getActualMaximum(5);
        cal.set(5, monthLastDay);
        return cal.getTime();
    }

    public static Date getYearFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(2, 1);
        return calendar.getTime();
    }

    public String initSelectionPeas() {
        String ctx = URLUtil.getApplicationURL();
        Pair hostComponentName = new Pair((Object)this.getString(AGENDA_FILENAME_PREFIX), (Object)(ctx + RAGENDA_JSP_MAIN));
        Pair[] hostPath = new Pair[]{new Pair((Object)this.getString("editionListeDiffusion"), (Object)(ctx + RAGENDA_JSP_MAIN))};
        String hostUrl = ctx + "/Ragenda/jsp/saveMembers";
        String cancelUrl = ctx + "/Ragenda/jsp/saveMembers";
        Selection sel = this.getSelection();
        sel.resetAll();
        sel.setHostSpaceName("");
        sel.setHostPath(hostPath);
        sel.setHostComponentName((Pair<String, String>)hostComponentName);
        sel.setGoBackURL(hostUrl);
        sel.setCancelURL(cancelUrl);
        Collection<Attendee> members = this.getCurrentAttendees();
        if (members != null) {
            String[] usersSelected = new String[members.size()];
            int j = 0;
            for (Attendee attendee : members) {
                usersSelected[j] = attendee.getUserId();
                ++j;
            }
            sel.setSelectedElements(usersSelected);
        }
        sel.setPopupMode(true);
        sel.setElementSelectable(true);
        sel.setSetSelectable(false);
        return Selection.getSelectionURL();
    }

    public Collection<Attendee> getUserSelected() throws AgendaException {
        String[] selectedUsers;
        Selection sel = this.getSelection();
        ArrayList<Attendee> attendees = new ArrayList<Attendee>();
        Collection<Attendee> oldAttendees = null;
        JournalHeader journal = this.getCurrentJournalHeader();
        if (journal.getId() != null) {
            oldAttendees = this.getJournalAttendees(journal.getId());
        }
        if ((selectedUsers = sel.getSelectedElements()) != null) {
            for (String selectedUser : selectedUsers) {
                Attendee newAttendee = null;
                if (oldAttendees != null) {
                    for (Attendee attendee : oldAttendees) {
                        if (!attendee.getUserId().equals(selectedUser)) continue;
                        newAttendee = attendee;
                    }
                }
                if (newAttendee == null) {
                    newAttendee = new Attendee(selectedUser);
                }
                attendees.add(newAttendee);
            }
        }
        return attendees;
    }

    @Override
    public void close() {
        this.calendarBm = null;
    }

    public List<Date> getNonSelectableDays() {
        if (this.nonSelectableDays == null) {
            this.nonSelectableDays = new ArrayList<Date>();
        }
        return this.nonSelectableDays;
    }

    public void setNonSelectableDays(List<Date> list) {
        this.nonSelectableDays = list;
    }

    public List<String> getHolidaysDates() {
        if (this.holidaysDates == null) {
            this.holidaysDates = this.getHolidaysDatesInDb();
        }
        return this.holidaysDates;
    }

    public void setHolidaysDates(List<String> list) {
        this.holidaysDates = list;
    }

    public String initUserPanelOtherAgenda() {
        String ctx = URLUtil.getApplicationURL();
        Pair hostComponentName = new Pair((Object)this.getString(AGENDA_FILENAME_PREFIX), (Object)(ctx + RAGENDA_JSP_MAIN));
        Pair[] hostPath = new Pair[]{new Pair((Object)this.getString("viewOtherAgenda"), (Object)(ctx + URLUtil.getURL((String)AGENDA_FILENAME_PREFIX, null, null) + "Main"))};
        String hostUrl = ctx + URLUtil.getURL((String)AGENDA_FILENAME_PREFIX, null, null) + "ViewOtherAgenda";
        String cancelUrl = ctx + URLUtil.getURL((String)AGENDA_FILENAME_PREFIX, null, null) + "Main";
        Selection sel = this.getSelection();
        sel.resetAll();
        sel.setHostSpaceName("");
        sel.setHostPath(hostPath);
        sel.setHostComponentName((Pair<String, String>)hostComponentName);
        sel.setGoBackURL(hostUrl);
        sel.setCancelURL(cancelUrl);
        sel.setPopupMode(true);
        sel.setMultiSelect(false);
        sel.setSetSelectable(false);
        sel.setElementSelectable(true);
        return Selection.getSelectionURL();
    }

    public UserDetail getSelectedUser() {
        Selection sel = this.getSelection();
        UserDetail selectedUser = null;
        String[] selectedUsers = sel.getSelectedElements();
        if (selectedUsers != null) {
            selectedUser = this.getUserDetail(selectedUsers[0]);
        }
        return selectedUser;
    }

    public void setAgendaUserDetail(UserDetail userDetail) {
        this.agendaUserDetail = userDetail;
        this.agendaUserId = userDetail.getId();
    }

    public UserDetail getAgendaUserDetail() {
        return this.agendaUserDetail;
    }

    public String getAgendaUserId() {
        return this.agendaUserId;
    }

    public boolean isOtherAgendaMode() {
        return !this.agendaUserId.equals(this.getUserId());
    }

    public CalendarImportSettings getImportSettings() {
        return this.importSettingsDao.getUserSettings(this.getUserId());
    }

    public void saveUserSettings(CalendarImportSettings importSettings) throws AgendaException {
        this.importSettingsDao.saveUserSettings(importSettings);
    }

    public void updateUserSettings(CalendarImportSettings importSettings) throws AgendaException {
        this.importSettingsDao.updateUserSettings(importSettings);
    }

    public String exportIcalAgenda(String startDate, String endDate) throws AgendaException {
        return new ExportIcalManager(this).exportIcalAgenda(startDate, endDate);
    }

    public String exportIcalAgenda() throws AgendaException {
        return this.exportIcalAgenda(null, null);
    }

    public String importIcalAgenda(File fileCalendar) {
        return new ImportIcalManager(this).importIcalAgenda(fileCalendar);
    }

    public String synchroIcalAgenda(String urlICalendar, String loginIcalendar, String pwdIcalendar) throws MalformedURLException {
        URL iCalendarServerUrl = new URL(urlICalendar);
        return new SynchroIcalManager(this).synchroIcalAgenda(iCalendarServerUrl, this.getIcalendarFile(), loginIcalendar, pwdIcalendar);
    }

    public String synchroIcalAgenda(String urlICalendar) throws MalformedURLException {
        return this.synchroIcalAgenda(urlICalendar, null, null);
    }

    private File getIcalendarFile() {
        return new File(FileRepositoryManager.getTemporaryPath() + AGENDA_FILENAME_PREFIX + this.getUserId() + ".ics");
    }

    public List<String> getHolidaysDatesInDb() {
        return this.calendarBm.getHolidayDates(this.getAgendaUserId());
    }

    public void changeDateStatus(String date, String nextStatus) throws RemoteException, ParseException {
        int status = Integer.parseInt(nextStatus);
        HolidayDetail holiday = new HolidayDetail(DateUtil.parse((String)date), this.getUserId());
        if (status == 0) {
            this.calendarBm.removeHolidayDate(holiday);
        } else {
            this.calendarBm.addHolidayDate(holiday);
        }
        this.setHolidaysDates(this.getHolidaysDatesInDb());
    }

    public void changeDayOfWeekStatus(String year, String month, String day) throws RemoteException {
        int iMonth = Integer.parseInt(month);
        this.currentCalendar.set(1, Integer.parseInt(year));
        this.currentCalendar.set(2, iMonth);
        this.currentCalendar.set(5, 1);
        while (this.currentCalendar.get(7) != Integer.parseInt(day)) {
            this.currentCalendar.add(5, 1);
        }
        Date date = this.currentCalendar.getTime();
        HolidayDetail holidayDate = new HolidayDetail(date, this.getUserId());
        boolean isHoliday = this.calendarBm.isHolidayDate(holidayDate);
        ArrayList<HolidayDetail> holidayDates = new ArrayList<HolidayDetail>();
        while (this.currentCalendar.get(2) == iMonth) {
            holidayDates.add(new HolidayDetail(this.currentCalendar.getTime(), this.getUserId()));
            this.currentCalendar.add(5, 7);
        }
        if (isHoliday) {
            this.calendarBm.removeHolidayDates(holidayDates);
        } else {
            this.calendarBm.addHolidayDates(holidayDates);
        }
        this.setHolidaysDates(this.getHolidaysDatesInDb());
        this.currentCalendar.set(1, Integer.parseInt(year));
        this.currentCalendar.set(2, iMonth);
        this.currentCalendar.set(5, 1);
    }

    public boolean isHolidayDate(Date date) {
        HolidayDetail currentDate = new HolidayDetail(date, this.getAgendaUserId());
        return this.calendarBm.isHolidayDate(currentDate);
    }

    public boolean isHolidayDate(String agendaUserId, Date date) {
        HolidayDetail currentDate = new HolidayDetail(date, agendaUserId);
        return this.calendarBm.isHolidayDate(currentDate);
    }

    public boolean isSameDaysAreHolidays(Calendar cal, int currentMonth) {
        Calendar localCalendar = (Calendar)cal.clone();
        boolean isSameDaysAreHolidays = true;
        for (int day = 1; day < 5 && isSameDaysAreHolidays; ++day) {
            if (!this.isHolidayDate(localCalendar.getTime()) && localCalendar.get(2) == currentMonth) {
                isSameDaysAreHolidays = false;
            }
            localCalendar.add(5, 7);
        }
        return isSameDaysAreHolidays;
    }

    public String getMyAgendaUrl() {
        return "/SubscribeAgenda/agenda?userId=" + this.getUserId() + "&amp;login=" + URLEncoder.encodePathParamValue((String)this.getUserDetail().getLogin()) + "&amp;password=" + URLEncoder.encodePathParamValue((String)OrganizationControllerProvider.getOrganisationController().getUserFull(this.getUserId()).getPassword());
    }

    public String getCurrentViewType() {
        String viewType;
        switch (this.getCurrentDisplayType()) {
            case 1: {
                viewType = "Main";
                break;
            }
            case 2: {
                viewType = "ViewByWeek";
                break;
            }
            case 3: {
                viewType = "ViewByMonth";
                break;
            }
            case 4: {
                viewType = "ViewByYear";
                break;
            }
            default: {
                viewType = "Main";
            }
        }
        return viewType;
    }
}

